/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.AlertMonitor;
import com.persistit.Buffer;
import com.persistit.BufferPool;
import com.persistit.CheckpointManager;
import com.persistit.Exchange;
import com.persistit.IOTaskRunnable;
import com.persistit.JournalRecord;
import com.persistit.Key;
import com.persistit.Management;
import com.persistit.MediatedFileChannel;
import com.persistit.Persistit;
import com.persistit.RecoveryManager;
import com.persistit.TransactionPlayer;
import com.persistit.TransactionPlayerSupport;
import com.persistit.TransactionStatus;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.Volume;
import com.persistit.VolumeHandleLookup;
import com.persistit.exception.CorruptJournalException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitIOException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.RebalanceException;
import com.persistit.exception.VolumeNotFoundException;
import com.persistit.mxbeans.JournalManagerMXBean;
import com.persistit.util.Debug;
import com.persistit.util.SequencerConstants;
import com.persistit.util.ThreadSequencer;
import com.persistit.util.Util;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JournalManager
implements JournalManagerMXBean,
VolumeHandleLookup {
    static final int PAGE_COPIER_URGENT = 5;
    static final int URGENT = 10;
    static final int ALMOST_URGENT = 8;
    static final int HALF_URGENT = 5;
    static final int URGENT_COMMIT_DELAY_MILLIS = 50;
    static final int GENTLE_COMMIT_DELAY_MILLIS = 12;
    private static final int IO_MEASUREMENT_CYCLES = 8;
    private static final int TOO_MANY_WARN_THRESHOLD = 5;
    private static final int TOO_MANY_ERROR_THRESHOLD = 10;
    private static final long KILO = 1024L;
    static final Pattern PATH_PATTERN = Pattern.compile("(.+)\\.(\\d{12})");
    private long _journalCreatedTime;
    private final Map<PageNode, PageNode> _pageMap = new HashMap<PageNode, PageNode>();
    private final RangeRemovingArrayList<PageNode> _pageList = new RangeRemovingArrayList();
    private final Map<PageNode, PageNode> _branchMap = new HashMap<PageNode, PageNode>();
    private final Map<Volume, Integer> _volumeToHandleMap = new HashMap<Volume, Integer>();
    private final Map<Integer, Volume> _handleToVolumeMap = new HashMap<Integer, Volume>();
    private final Map<TreeDescriptor, Integer> _treeToHandleMap = new HashMap<TreeDescriptor, Integer>();
    private final Map<Integer, TreeDescriptor> _handleToTreeMap = new HashMap<Integer, TreeDescriptor>();
    private final Map<Long, TransactionMapItem> _liveTransactionMap = new HashMap<Long, TransactionMapItem>();
    private final Persistit _persistit;
    private long _blockSize;
    private volatile int _writeBufferSize = 0x1000000;
    private ByteBuffer _writeBuffer;
    private long _writeBufferAddress = Long.MAX_VALUE;
    private JournalFlusher _flusher;
    private JournalCopier _copier;
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final AtomicBoolean _copying = new AtomicBoolean();
    private final AtomicBoolean _copyFast = new AtomicBoolean();
    private final AtomicBoolean _flushing = new AtomicBoolean();
    private final AtomicBoolean _appendOnly = new AtomicBoolean();
    private final AtomicBoolean _ignoreMissingVolume = new AtomicBoolean();
    private String _journalFilePath;
    private volatile long _currentAddress;
    private volatile long _baseAddress;
    private final Map<Long, FileChannel> _journalFileChannels = new HashMap<Long, FileChannel>();
    private int _handleCounter = 0;
    private CheckpointManager.Checkpoint _lastValidCheckpoint = new CheckpointManager.Checkpoint(0L, 0L);
    private long _lastValidCheckpointJournalAddress = 0L;
    private long _lastValidCheckpointBaseAddress = 0L;
    private long _deleteBoundaryAddress = 0L;
    private int _lastReportedJournalFileCount = 0;
    private boolean _isNewEpoch = true;
    private volatile long _writePageCount = 0L;
    private volatile long _readPageCount = 0L;
    private volatile long _copiedPageCount = 0L;
    private volatile long _droppedPageCount = 0L;
    private final AtomicLong _totalCommits = new AtomicLong();
    private final AtomicLong _totalCommitWaitTime = new AtomicLong();
    private final AtomicLong _totalFlushCycles = new AtomicLong();
    private final AtomicLong _totalFlushIoTime = new AtomicLong();
    private volatile long _flushInterval = 100L;
    private volatile long _slowIoAlertThreshold = 2000L;
    private final TransactionPlayer _player = new TransactionPlayer(new JournalTransactionPlayerSupport());
    private final TransactionPlayer.TransactionPlayerListener _listener = new ProactiveRollbackListener();
    private final PruneTransactionPlayer _pruneCommited = new PruneTransactionPlayer();
    private final AtomicBoolean _writePagePruning = new AtomicBoolean(true);
    private final AtomicBoolean _rollbackPruning = new AtomicBoolean(true);
    private volatile long _copierInterval = 10000L;
    private volatile int _copiesPerCycle = 1000;
    private volatile long _copierTimestampLimit = Long.MAX_VALUE;
    private volatile long _earliestCommittedTimestamp = Long.MAX_VALUE;
    private volatile long _earliestAbortedTimestamp = Long.MAX_VALUE;
    private boolean _allowHandlesForTempVolumesAndTrees;
    private volatile int _urgentFileCountThreshold = 15;
    private volatile long _throttleSleepInterval;

    public synchronized void init(RecoveryManager rman, String path, long maximumSize) throws PersistitException {
        this._writeBuffer = ByteBuffer.allocate(this._writeBufferSize);
        if (rman != null && rman.getKeystoneAddress() != -1L) {
            this._journalFilePath = rman.getJournalFilePath();
            this._blockSize = rman.getBlockSize();
            this._currentAddress = rman.getKeystoneAddress() + this._blockSize;
            this._baseAddress = rman.getBaseAddress();
            this._journalCreatedTime = rman.getJournalCreatedTime();
            this._lastValidCheckpoint = rman.getLastValidCheckpoint();
            rman.collectRecoveredPages(this._pageMap, this._branchMap);
            rman.collectRecoveredVolumeMaps(this._handleToVolumeMap, this._volumeToHandleMap);
            rman.collectRecoveredTreeMaps(this._handleToTreeMap, this._treeToHandleMap);
            rman.collectRecoveredTransactionMap(this._liveTransactionMap);
            for (Integer handle : this._handleToTreeMap.keySet()) {
                this._handleCounter = Math.max(this._handleCounter, handle + 1);
            }
            for (Integer handle : this._handleToVolumeMap.keySet()) {
                this._handleCounter = Math.max(this._handleCounter, handle + 1);
            }
            Iterator<Object> iterator = this._pageMap.values().iterator();
            while (iterator.hasNext()) {
                PageNode root;
                for (PageNode pn = root = (PageNode)iterator.next(); pn != null; pn = pn.getPrevious()) {
                    this._pageList.add(pn);
                }
            }
            Collections.sort(this._pageList, PageNode.READ_COMPARATOR);
        } else {
            this._journalFilePath = JournalManager.journalPath(path).getAbsoluteFile().toString();
            this._blockSize = maximumSize;
            this._currentAddress = 0L;
            this._journalCreatedTime = System.currentTimeMillis();
        }
        this._closed.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startJournal() throws PersistitException {
        JournalManager journalManager = this;
        synchronized (journalManager) {
            this.prepareWriteBuffer(64);
        }
        this._flusher = new JournalFlusher();
        this._copier = new JournalCopier();
        this._copier.start();
        this._flusher.start();
    }

    public synchronized void populateJournalInfo(Management.JournalInfo info) {
        info.closed = this._closed.get();
        if (this._blockSize == 0L) {
            return;
        }
        info.copiedPageCount = this._copiedPageCount;
        info.droppedPageCount = this._droppedPageCount;
        info.copying = this._copying.get();
        info.currentGeneration = this._currentAddress;
        info.currentJournalAddress = this._writeBuffer == null ? 0L : this._writeBufferAddress + (long)this._writeBuffer.position();
        info.currentJournalFile = this.addressToFile(this._currentAddress).getPath();
        info.flushing = this._flushing.get();
        info.journaledPageCount = this._writePageCount;
        info.readPageCount = this._readPageCount;
        if (this._lastValidCheckpointJournalAddress != 0L) {
            info.lastValidCheckpointSystemTime = this._lastValidCheckpoint.getSystemTimeMillis();
            info.lastValidCheckpointTimestamp = this._lastValidCheckpoint.getTimestamp();
            info.lastValidCheckpointJournalFile = this.addressToFile(this._lastValidCheckpointJournalAddress).getPath();
            info.lastValidCheckpointJournalAddress = this._lastValidCheckpointJournalAddress;
        } else {
            info.lastValidCheckpointSystemTime = 0L;
            info.lastValidCheckpointTimestamp = 0L;
            info.lastValidCheckpointJournalFile = null;
            info.lastValidCheckpointJournalAddress = 0L;
        }
        info.blockSize = this._blockSize;
        info.pageMapSize = this._pageMap.size();
        info.baseAddress = this._baseAddress;
        info.appendOnly = this._appendOnly.get();
        info.fastCopying = this._copyFast.get();
    }

    @Override
    public synchronized int getLiveTransactionMapSize() {
        return this._liveTransactionMap.size();
    }

    @Override
    public synchronized int getPageMapSize() {
        return this._pageMap.size();
    }

    @Override
    public synchronized int getPageListSize() {
        return this._pageList.size();
    }

    @Override
    public synchronized long getBaseAddress() {
        return this._baseAddress;
    }

    @Override
    public synchronized long getCurrentAddress() {
        return this._currentAddress;
    }

    @Override
    public long getBlockSize() {
        return this._blockSize;
    }

    @Override
    public boolean isAppendOnly() {
        return this._appendOnly.get();
    }

    @Override
    public boolean isIgnoreMissingVolumes() {
        return this._ignoreMissingVolume.get();
    }

    @Override
    public boolean isCopyingFast() {
        return this._copyFast.get();
    }

    @Override
    public void setAppendOnly(boolean appendOnly) {
        this._appendOnly.set(appendOnly);
    }

    @Override
    public void setIgnoreMissingVolumes(boolean ignore) {
        this._ignoreMissingVolume.set(ignore);
    }

    @Override
    public void setCopyingFast(boolean fast) {
        this._copyFast.set(fast);
    }

    @Override
    public long getFlushInterval() {
        return this._flusher.getPollInterval();
    }

    @Override
    public void setFlushInterval(long flushInterval) {
        this._flusher.setPollInterval(flushInterval);
    }

    @Override
    public long getCopierInterval() {
        return this._copier.getPollInterval();
    }

    @Override
    public void setCopierInterval(long copierInterval) {
        this._copier.setPollInterval(copierInterval);
    }

    @Override
    public void setRollbackPruningEnabled(boolean rollbackPruning) {
        this._rollbackPruning.set(rollbackPruning);
    }

    @Override
    public void setWritePagePruningEnabled(boolean writePruning) {
        this._writePagePruning.set(writePruning);
    }

    public JournalManager(Persistit persistit) {
        this._persistit = persistit;
    }

    @Override
    public boolean isClosed() {
        return this._closed.get();
    }

    @Override
    public boolean isCopying() {
        return this._copying.get();
    }

    @Override
    public boolean isRollbackPruningEnabled() {
        return this._rollbackPruning.get();
    }

    @Override
    public boolean isWritePagePruningEnabled() {
        return this._writePagePruning.get();
    }

    @Override
    public String getJournalFilePath() {
        return this._journalFilePath;
    }

    @Override
    public long getJournaledPageCount() {
        return this._writePageCount;
    }

    @Override
    public long getReadPageCount() {
        return this._readPageCount;
    }

    @Override
    public long getCopiedPageCount() {
        return this._copiedPageCount;
    }

    @Override
    public long getDroppedPageCount() {
        return this._droppedPageCount;
    }

    public long getEarliestCommittedTransactionTimestamp() {
        return this._earliestCommittedTimestamp;
    }

    public long getEarliestAbortedTransactionTimestamp() {
        return this._earliestAbortedTimestamp;
    }

    @Override
    public long getJournalCreatedTime() {
        return this._journalCreatedTime;
    }

    public CheckpointManager.Checkpoint getLastValidCheckpoint() {
        return this._lastValidCheckpoint;
    }

    @Override
    public long getLastValidCheckpointTimestamp() {
        return this._lastValidCheckpoint.getTimestamp();
    }

    @Override
    public String getLastCopierException() {
        return Util.toString(this._copier.getLastException());
    }

    @Override
    public String getLastFlusherException() {
        return Util.toString(this._flusher.getLastException());
    }

    @Override
    public long getLastValidCheckpointTimeMillis() {
        return this._lastValidCheckpoint.getSystemTimeMillis();
    }

    @Override
    public long getSlowIoAlertThreshold() {
        return this._slowIoAlertThreshold;
    }

    @Override
    public long getTotalCompletedCommits() {
        return this._totalCommits.get();
    }

    @Override
    public long getCommitCompletionWaitTime() {
        return this._totalCommitWaitTime.get() / 1000000L;
    }

    @Override
    public long getCurrentTimestamp() {
        return this._persistit.getCurrentTimestamp();
    }

    @Override
    public void setSlowIoAlertThreshold(long slowIoAlertThreshold) {
        Util.rangeCheck(slowIoAlertThreshold, 100L, Long.MAX_VALUE);
        this._slowIoAlertThreshold = slowIoAlertThreshold;
    }

    @Override
    public int getUrgentFileCountThreshold() {
        return this._urgentFileCountThreshold;
    }

    @Override
    public void setUrgentFileCountThreshold(int threshold) {
        Util.rangeCheck(threshold, 5, 100);
        this._urgentFileCountThreshold = threshold;
    }

    @Override
    public int urgency() {
        if (this._copyFast.get()) {
            return 10;
        }
        int remainingFiles = this._urgentFileCountThreshold - this.getJournalFileCount();
        return Math.max(0, Math.min(10 - remainingFiles, 10));
    }

    public void throttle() throws PersistitInterruptedException {
        long interval = this._throttleSleepInterval;
        if (interval > 0L) {
            Util.sleep(interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int handleForVolume(Volume volume) throws PersistitException {
        if (volume.getHandle() != 0) {
            return volume.getHandle();
        }
        if (!this._allowHandlesForTempVolumesAndTrees && volume.isTemporary()) {
            throw new IllegalStateException("Creating handle for temporary volume " + volume);
        }
        if (volume.getHandle() != 0) {
            return volume.getHandle();
        }
        JournalManager journalManager = this;
        synchronized (journalManager) {
            if (volume.getHandle() != 0) {
                return volume.getHandle();
            }
            Integer handle = this._volumeToHandleMap.get(volume);
            if (handle == null) {
                Debug.$assert0.t(!this._handleToVolumeMap.containsKey(handle = Integer.valueOf(++this._handleCounter)));
                this.writeVolumeHandleToJournal(volume, handle);
                this._volumeToHandleMap.put(volume, handle);
                this._handleToVolumeMap.put(handle, volume);
            }
            return volume.setHandle(handle);
        }
    }

    synchronized int handleForTree(TreeDescriptor td, boolean create) throws PersistitException {
        if (td.getVolumeHandle() == -1) {
            return -1;
        }
        Integer handle = this._treeToHandleMap.get(td);
        if (handle == null) {
            if (!create) {
                return -1;
            }
            Debug.$assert0.t(!this._handleToTreeMap.containsKey(handle = Integer.valueOf(++this._handleCounter)));
            if (td.getVolumeHandle() != Integer.MAX_VALUE) {
                this.writeTreeHandleToJournal(td, handle);
            }
            this._treeToHandleMap.put(td, handle);
            this._handleToTreeMap.put(handle, td);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int handleForTree(Tree tree) throws PersistitException {
        if (!this._allowHandlesForTempVolumesAndTrees && tree.getVolume().isTemporary() && !tree.getVolume().isLockVolume()) {
            throw new IllegalStateException("Creating handle for temporary tree " + tree);
        }
        if (tree.getHandle() != 0) {
            return tree.getHandle();
        }
        JournalManager journalManager = this;
        synchronized (journalManager) {
            if (tree.getHandle() != 0) {
                return tree.getHandle();
            }
            TreeDescriptor td = new TreeDescriptor(this.handleForVolume(tree.getVolume()), tree.getName());
            return tree.setHandle(this.handleForTree(td, true));
        }
    }

    Tree treeForHandle(int handle) throws PersistitException {
        TreeDescriptor td = this.lookupTreeHandle(handle);
        if (td == null) {
            return null;
        }
        Volume volume = this.volumeForHandle(td.getVolumeHandle());
        if (volume == null) {
            return null;
        }
        return volume.getStructure().getTreeInternal(td.getTreeName());
    }

    Volume volumeForHandle(int handle) throws PersistitException {
        Volume volume = this.lookupVolumeHandle(handle);
        if (volume == null) {
            if (handle == Integer.MAX_VALUE) {
                return this._persistit.getLockVolume();
            }
            return null;
        }
        if (!volume.isOpened()) {
            volume.open(this._persistit);
        }
        return volume;
    }

    synchronized Volume getVolumeByName(String volumeName) {
        for (Volume v : this._handleToVolumeMap.values()) {
            if (!volumeName.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    @Override
    public synchronized Volume lookupVolumeHandle(int handle) {
        return this._handleToVolumeMap.get(handle);
    }

    public synchronized TreeDescriptor lookupTreeHandle(int handle) {
        return this._handleToTreeMap.get(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFully(ByteBuffer bb, long address) throws PersistitIOException, CorruptJournalException {
        int position = bb.position();
        int length = bb.remaining();
        JournalManager journalManager = this;
        synchronized (journalManager) {
            if (address >= this._writeBufferAddress && address + (long)length <= this._currentAddress) {
                assert (this._writeBufferAddress + (long)this._writeBuffer.position() == this._currentAddress) : String.format("writeBufferAddress=%,d position=%,d currentAddress=%,d", this._writeBufferAddress, this._writeBuffer.position(), this._currentAddress);
                int wbPosition = this._writeBuffer.position();
                int wbLimit = this._writeBuffer.limit();
                this._writeBuffer.position((int)(address - this._writeBufferAddress));
                this._writeBuffer.limit((int)(address - this._writeBufferAddress) + length);
                bb.put(this._writeBuffer);
                this._writeBuffer.limit(wbLimit);
                this._writeBuffer.position(wbPosition);
                bb.position(position);
                return;
            }
        }
        FileChannel fc = this.getFileChannel(address);
        long fileAddr = this.addressToOffset(address);
        while (bb.remaining() > 0) {
            int count;
            try {
                count = fc.read(bb, fileAddr);
            }
            catch (IOException ioe) {
                throw new PersistitIOException(ioe);
            }
            if (count < 0) {
                File file = this.addressToFile(address);
                throw new CorruptJournalException(String.format("End of file at %s:%d(%,d)", file, fileAddr, address));
            }
            fileAddr += (long)count;
        }
        bb.limit(bb.position());
        bb.position(position);
    }

    boolean readPageFromJournal(Buffer buffer) throws PersistitIOException {
        int bufferSize = buffer.getBufferSize();
        long pageAddress = buffer.getPageAddress();
        ByteBuffer bb = buffer.getByteBuffer();
        Volume volume = buffer.getVolume();
        PageNode pn = this.lookupUpPageNode(pageAddress, volume);
        if (pn == null) {
            return false;
        }
        bb.position(0);
        long recordPageAddress = this.readPageBufferFromJournal(pn, bb);
        this._persistit.getIOMeter().chargeReadPageFromJournal(volume, pageAddress, bufferSize, pn.getJournalAddress(), buffer.getIndex());
        if (pageAddress != recordPageAddress) {
            throw new CorruptJournalException("Record at " + pn + " is not volume/page " + buffer.toString());
        }
        if (bb.limit() != bufferSize) {
            throw new CorruptJournalException("Record at " + pn + " is wrong size: expected/actual=" + bufferSize + "/" + bb.limit());
        }
        ++this._readPageCount;
        buffer.getVolume().getStatistics().bumpReadCounter();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PageNode lookupUpPageNode(long pageAddress, Volume volume) {
        PageNode pnLookup = null;
        JournalManager journalManager = this;
        synchronized (journalManager) {
            Integer volumeHandle = this._volumeToHandleMap.get(volume);
            if (volumeHandle != null) {
                pnLookup = this._pageMap.get(new PageNode(volumeHandle, pageAddress, -1L, -1L));
            }
        }
        if (pnLookup == null) {
            return null;
        }
        PageNode pn = new PageNode(pnLookup.getVolumeHandle(), pnLookup.getPageAddress(), pnLookup.getJournalAddress(), pnLookup.getTimestamp());
        ThreadSequencer.sequence(SequencerConstants.PAGE_MAP_READ_INVALIDATE_A);
        if (pnLookup.isInvalid()) {
            return null;
        }
        return pn;
    }

    private long readPageBufferFromJournal(PageNode pn, ByteBuffer bb) throws PersistitIOException, CorruptJournalException {
        int at = bb.position();
        bb.limit(at + 36);
        this.readFully(bb, pn.getJournalAddress());
        if (bb.remaining() < 36) {
            throw new CorruptJournalException("Record at " + pn.toStringJournalAddress(this) + " is incomplete");
        }
        int type = JournalRecord.getType(bb);
        int payloadSize = JournalRecord.getLength(bb) - 36;
        int leftSize = JournalRecord.PA.getLeftSize(bb);
        int bufferSize = JournalRecord.PA.getBufferSize(bb);
        long pageAddress = JournalRecord.PA.getPageAddress(bb);
        if (type != 20545) {
            throw new CorruptJournalException("Record at " + pn.toStringJournalAddress(this) + " is not a PAGE record");
        }
        if (leftSize < 0 || payloadSize < leftSize || payloadSize > bufferSize) {
            throw new CorruptJournalException("Record at " + pn.toStringJournalAddress(this) + " invalid sizes: recordSize= " + payloadSize + " leftSize=" + leftSize + " bufferSize=" + bufferSize);
        }
        if (pageAddress != pn.getPageAddress() && pn.getPageAddress() != -1L) {
            throw new CorruptJournalException("Record at " + pn.toStringJournalAddress(this) + " mismatched page address: expected/actual=" + pn.getPageAddress() + "/" + pageAddress);
        }
        bb.limit(at + payloadSize).position(at);
        this.readFully(bb, pn.getJournalAddress() + 36L);
        int rightSize = payloadSize - leftSize;
        System.arraycopy(bb.array(), leftSize + at, bb.array(), bufferSize - rightSize + at, rightSize);
        Arrays.fill(bb.array(), leftSize + at, bufferSize - rightSize + at, (byte)0);
        bb.limit(bb.capacity()).position(at).limit(at + bufferSize);
        return pageAddress;
    }

    Buffer readPageBuffer(long address) throws PersistitException {
        ByteBuffer bb = ByteBuffer.allocate(36);
        this.readFully(bb, address);
        if (bb.remaining() < 36) {
            return null;
        }
        int type = JournalRecord.getType(bb);
        int payloadSize = JournalRecord.getLength(bb) - 36;
        int leftSize = JournalRecord.PA.getLeftSize(bb);
        int bufferSize = JournalRecord.PA.getBufferSize(bb);
        long pageAddress = JournalRecord.PA.getPageAddress(bb);
        int volumeHandle = JournalRecord.PA.getVolumeHandle(bb);
        if (type != 20545 || leftSize < 0 || payloadSize < leftSize || payloadSize > bufferSize) {
            return null;
        }
        BufferPool pool = this._persistit.getBufferPool(bufferSize);
        Buffer buffer = new Buffer(bufferSize, -1, pool, this._persistit);
        buffer.setPageAddressAndVolume(pageAddress, this.volumeForHandle(volumeHandle));
        bb = buffer.getByteBuffer();
        bb.limit(payloadSize).position(0);
        this.readFully(bb, address + 36L);
        if (leftSize > 0) {
            int rightSize = payloadSize - leftSize;
            System.arraycopy(bb.array(), leftSize, bb.array(), bufferSize - rightSize, rightSize);
            Arrays.fill(bb.array(), leftSize, bufferSize - rightSize, (byte)0);
        }
        bb.limit(bufferSize).position(0);
        boolean acquired = buffer.claim(true, 0L);
        assert (acquired) : "buffer in use";
        buffer.load();
        buffer.release();
        return buffer;
    }

    private void advance(int recordSize) {
        Debug.$assert1.t(recordSize > 0 && recordSize + this._writeBuffer.position() <= this._writeBuffer.capacity());
        this._currentAddress += (long)recordSize;
        this._writeBuffer.position(this._writeBuffer.position() + recordSize);
    }

    synchronized void writeJournalHeader() throws PersistitException {
        JournalRecord.JH.putType(this._writeBuffer);
        JournalRecord.putTimestamp(this._writeBuffer, this.epochalTimestamp());
        JournalRecord.JH.putVersion(this._writeBuffer, 2L);
        JournalRecord.JH.putBlockSize(this._writeBuffer, this._blockSize);
        JournalRecord.JH.putBaseJournalAddress(this._writeBuffer, this._baseAddress);
        JournalRecord.JH.putCurrentJournalAddress(this._writeBuffer, this._currentAddress);
        JournalRecord.JH.putJournalCreatedTime(this._writeBuffer, this._journalCreatedTime);
        JournalRecord.JH.putFileCreatedTime(this._writeBuffer, System.currentTimeMillis());
        JournalRecord.JH.putPath(this._writeBuffer, this.addressToFile(this._currentAddress).getPath());
        int recordSize = JournalRecord.getLength(this._writeBuffer);
        this._persistit.getIOMeter().chargeWriteOtherToJournal(recordSize, this._currentAddress);
        this.advance(recordSize);
    }

    synchronized void writeJournalEnd() throws PersistitException {
        if (this._writeBufferAddress != Long.MAX_VALUE) {
            JournalRecord.JE.putType(this._writeBuffer);
            JournalRecord.putTimestamp(this._writeBuffer, this.epochalTimestamp());
            JournalRecord.putLength(this._writeBuffer, 40);
            JournalRecord.JE.putCurrentJournalAddress(this._writeBuffer, this._currentAddress);
            JournalRecord.JE.putBaseAddress(this._writeBuffer, this._baseAddress);
            JournalRecord.JE.putJournalCreatedTime(this._writeBuffer, this._journalCreatedTime);
            this._persistit.getIOMeter().chargeWriteOtherToJournal(40, this._currentAddress);
            this.advance(40);
        }
    }

    synchronized void writePageMap() throws PersistitException {
        PageNode lastPageNode;
        PageNode pageNode;
        PageNode lastPageNode2;
        PageNode pageNode2;
        int count = 0;
        Iterator<PageNode> iterator = this._pageMap.values().iterator();
        while (iterator.hasNext()) {
            for (pageNode2 = lastPageNode2 = iterator.next(); pageNode2 != null; pageNode2 = pageNode2.getPrevious()) {
                ++count;
            }
        }
        iterator = this._branchMap.values().iterator();
        while (iterator.hasNext()) {
            for (pageNode2 = lastPageNode2 = iterator.next(); pageNode2 != null; pageNode2 = pageNode2.getPrevious()) {
                ++count;
            }
        }
        int recordSize = 16 + 28 * count;
        this.prepareWriteBuffer(recordSize);
        JournalRecord.PM.putType(this._writeBuffer);
        JournalRecord.putLength(this._writeBuffer, recordSize);
        JournalRecord.putTimestamp(this._writeBuffer, this.epochalTimestamp());
        this.advance(16);
        int offset = 0;
        Iterator<PageNode> iterator2 = this._pageMap.values().iterator();
        while (iterator2.hasNext()) {
            for (pageNode = lastPageNode = iterator2.next(); pageNode != null; pageNode = pageNode.getPrevious()) {
                JournalRecord.PM.putEntry(this._writeBuffer, offset / 28, pageNode.getTimestamp(), pageNode.getJournalAddress(), pageNode.getVolumeHandle(), pageNode.getPageAddress());
                if (--count == 0 || (offset += 28) + 28 >= this._writeBuffer.remaining()) {
                    this.advance(offset);
                    offset = 0;
                }
                if (28 < this._writeBuffer.remaining()) continue;
                this.flush();
            }
        }
        iterator2 = this._branchMap.values().iterator();
        while (iterator2.hasNext()) {
            for (pageNode = lastPageNode = iterator2.next(); pageNode != null; pageNode = pageNode.getPrevious()) {
                JournalRecord.PM.putEntry(this._writeBuffer, offset / 28, pageNode.getTimestamp(), pageNode.getJournalAddress(), pageNode.getVolumeHandle(), pageNode.getPageAddress());
                if (--count == 0 || (offset += 28) + 28 >= this._writeBuffer.remaining()) {
                    this.advance(offset);
                    offset = 0;
                }
                if (28 < this._writeBuffer.remaining()) continue;
                this.flush();
            }
        }
        Debug.$assert0.t(count == 0);
        this._persistit.getIOMeter().chargeWriteOtherToJournal(recordSize, this._currentAddress - (long)recordSize);
    }

    synchronized void writeTransactionMap() throws PersistitException {
        int count = this._liveTransactionMap.size();
        int recordSize = 16 + 32 * count;
        this.prepareWriteBuffer(recordSize);
        JournalRecord.TM.putType(this._writeBuffer);
        JournalRecord.putLength(this._writeBuffer, recordSize);
        JournalRecord.putTimestamp(this._writeBuffer, this.epochalTimestamp());
        this.advance(16);
        int offset = 0;
        for (TransactionMapItem ts : this._liveTransactionMap.values()) {
            JournalRecord.TM.putEntry(this._writeBuffer, offset / 32, ts.getStartTimestamp(), ts.getCommitTimestamp(), ts.getStartAddress(), ts.getLastRecordAddress());
            if (--count == 0 || (offset += 32) + 32 >= this._writeBuffer.remaining()) {
                this.advance(offset);
                offset = 0;
            }
            if (32 < this._writeBuffer.remaining()) continue;
            this.flush();
        }
        Debug.$assert0.t(count == 0);
        this._persistit.getIOMeter().chargeWriteOtherToJournal(recordSize, this._currentAddress - (long)recordSize);
    }

    synchronized void writeCheckpointToJournal(CheckpointManager.Checkpoint checkpoint) throws PersistitException {
        this.force();
        if (!this.prepareWriteBuffer(32)) {
            long address = this._currentAddress;
            JournalRecord.putLength(this._writeBuffer, 32);
            JournalRecord.CP.putType(this._writeBuffer);
            JournalRecord.putTimestamp(this._writeBuffer, checkpoint.getTimestamp());
            JournalRecord.CP.putSystemTimeMillis(this._writeBuffer, checkpoint.getSystemTimeMillis());
            JournalRecord.CP.putBaseAddress(this._writeBuffer, this._baseAddress);
            this._persistit.getIOMeter().chargeWriteOtherToJournal(32, this._currentAddress);
            this.advance(32);
            this.force();
            this.checkpointWritten(checkpoint);
            this._persistit.getLogBase().checkpointWritten.log(checkpoint, address);
            this._persistit.getIOMeter().chargeWriteOtherToJournal(32, address);
        }
        this._lastValidCheckpoint = checkpoint;
        this._lastValidCheckpointJournalAddress = this._currentAddress - 32L;
        this._lastValidCheckpointBaseAddress = this._baseAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePageToJournal(Buffer buffer) throws PersistitException {
        int recordSize;
        Volume volume;
        JournalManager journalManager = this;
        synchronized (journalManager) {
            int rightSize;
            int leftSize;
            if (!buffer.isTemporary() && buffer.getTimestamp() < this._lastValidCheckpoint.getTimestamp()) {
                this._persistit.getLogBase().lateWrite.log(this._lastValidCheckpoint, buffer);
            }
            volume = buffer.getVolume();
            int handle = this.handleForVolume(volume);
            if (buffer.isDataPage() || buffer.isIndexPage() || buffer.isGarbagePage()) {
                leftSize = buffer.getKeyBlockEnd();
                rightSize = buffer.getBufferSize() - buffer.getAlloc();
            } else {
                leftSize = 0;
                rightSize = buffer.getBufferSize();
            }
            recordSize = 36 + leftSize + rightSize;
            this.prepareWriteBuffer(recordSize);
            Debug.$assert1.t(this._writeBuffer.remaining() >= recordSize);
            long address = this._currentAddress;
            int position = this._writeBuffer.position();
            JournalRecord.putLength(this._writeBuffer, recordSize);
            JournalRecord.PA.putVolumeHandle(this._writeBuffer, handle);
            JournalRecord.PA.putType(this._writeBuffer);
            JournalRecord.putTimestamp(this._writeBuffer, buffer.isTemporary() ? -1L : buffer.getTimestamp());
            JournalRecord.PA.putLeftSize(this._writeBuffer, leftSize);
            JournalRecord.PA.putBufferSize(this._writeBuffer, buffer.getBufferSize());
            JournalRecord.PA.putPageAddress(this._writeBuffer, buffer.getPageAddress());
            this.advance(36);
            if (leftSize > 0) {
                this._writeBuffer.put(buffer.getBytes(), 0, leftSize);
                this._writeBuffer.put(buffer.getBytes(), buffer.getBufferSize() - rightSize, rightSize);
            } else {
                this._writeBuffer.put(buffer.getBytes());
            }
            Debug.$assert0.t(this._writeBuffer.position() - position == recordSize);
            this._currentAddress += (long)(recordSize - 36);
            PageNode pageNode = new PageNode(handle, buffer.getPageAddress(), address, buffer.getTimestamp());
            this._pageList.add(pageNode);
            PageNode oldPageNode = this._pageMap.put(pageNode, pageNode);
            if (oldPageNode != null) assert (oldPageNode.getTimestamp() <= pageNode.getTimestamp());
            long checkpointTimestamp = this._persistit.getTimestampAllocator().getProposedCheckpointTimestamp();
            if (oldPageNode != null && oldPageNode.getTimestamp() > checkpointTimestamp && buffer.getTimestamp() > checkpointTimestamp) {
                oldPageNode.invalidate();
                oldPageNode = oldPageNode.getPrevious();
            }
            pageNode.setPrevious(oldPageNode);
            ++this._writePageCount;
        }
        this._persistit.getIOMeter().chargeWritePageToJournal(volume, buffer.getPageAddress(), buffer.getBufferSize(), this._currentAddress - (long)recordSize, this.urgency(), buffer.getIndex());
    }

    synchronized void writeVolumeHandleToJournal(Volume volume, int handle) throws PersistitException {
        this.prepareWriteBuffer(2076);
        JournalRecord.IV.putType(this._writeBuffer);
        JournalRecord.IV.putHandle(this._writeBuffer, handle);
        JournalRecord.IV.putVolumeId(this._writeBuffer, volume.getId());
        JournalRecord.putTimestamp(this._writeBuffer, this.epochalTimestamp());
        if (this._persistit.getConfiguration().isUseOldVSpec()) {
            JournalRecord.IV.putVolumeSpecification(this._writeBuffer, volume.getName());
        } else {
            JournalRecord.IV.putVolumeSpecification(this._writeBuffer, volume.getSpecification().toString());
        }
        int recordSize = JournalRecord.getLength(this._writeBuffer);
        this._persistit.getIOMeter().chargeWriteOtherToJournal(recordSize, this._currentAddress);
        this.advance(recordSize);
    }

    synchronized void writeTreeHandleToJournal(TreeDescriptor td, int handle) throws PersistitException {
        this.prepareWriteBuffer(1048);
        JournalRecord.IT.putType(this._writeBuffer);
        JournalRecord.IT.putHandle(this._writeBuffer, handle);
        JournalRecord.IT.putVolumeHandle(this._writeBuffer, td.getVolumeHandle());
        JournalRecord.putTimestamp(this._writeBuffer, this.epochalTimestamp());
        JournalRecord.IT.putTreeName(this._writeBuffer, td.getTreeName());
        int recordSize = JournalRecord.getLength(this._writeBuffer);
        this._persistit.getIOMeter().chargeWriteOtherToJournal(recordSize, this._currentAddress);
        this.advance(recordSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long writeTransactionToJournal(ByteBuffer buffer, long startTimestamp, long commitTimestamp, long backchainAddress) throws PersistitException {
        int recordSize = 32 + buffer.position();
        this.prepareWriteBuffer(recordSize);
        long address = this._currentAddress;
        JournalRecord.TX.putLength(this._writeBuffer, recordSize);
        JournalRecord.TX.putType(this._writeBuffer);
        JournalRecord.TX.putTimestamp(this._writeBuffer, startTimestamp);
        JournalRecord.TX.putCommitTimestamp(this._writeBuffer, commitTimestamp);
        JournalRecord.TX.putBackchainAddress(this._writeBuffer, backchainAddress);
        this._persistit.getIOMeter().chargeWriteTXtoJournal(recordSize, this._currentAddress);
        this.advance(32);
        try {
            buffer.flip();
            this._writeBuffer.put(buffer);
        }
        finally {
            buffer.clear();
        }
        this._currentAddress += (long)(recordSize - 32);
        if (commitTimestamp != Long.MIN_VALUE) {
            long key = startTimestamp;
            TransactionMapItem item = this._liveTransactionMap.get(key);
            if (item == null) {
                if (backchainAddress != 0L) {
                    throw new IllegalStateException("Missing back-chained transaction for start timestamp " + startTimestamp);
                }
                item = new TransactionMapItem(startTimestamp, address);
                this._liveTransactionMap.put(startTimestamp, item);
            } else {
                if (backchainAddress == 0L) {
                    throw new IllegalStateException("Duplicate transaction " + item);
                }
                if (item.isCommitted()) {
                    throw new IllegalStateException("Transaction already committed " + item);
                }
                item.setLastRecordAddress(address);
            }
            item.setCommitTimestamp(commitTimestamp);
        }
        return address;
    }

    static File journalPath(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            return new File(file, "persistit_journal");
        }
        return file;
    }

    static long fileToGeneration(File file) {
        Matcher matcher = PATH_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            return Long.parseLong(matcher.group(2));
        }
        return -1L;
    }

    static String fileToPath(File file) {
        Matcher matcher = PATH_PATTERN.matcher(file.getPath());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    static File generationToFile(String path, long generation) {
        return new File(String.format("%s.%012d", path, generation));
    }

    File addressToFile(long address) {
        return JournalManager.generationToFile(this._journalFilePath, address / this._blockSize);
    }

    long addressToOffset(long address) {
        return address % this._blockSize;
    }

    void setWriteBufferSize(int size) {
        if (size < 65536 || size > 0xA000000) {
            throw new IllegalArgumentException("Invalid write buffer size: " + size);
        }
        this._writeBufferSize = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws PersistitException {
        this._closed.set(true);
        this.rollover();
        JournalCopier copier = this._copier;
        this._copier = null;
        if (copier != null) {
            this._persistit.waitForIOTaskStop(copier);
        }
        JournalFlusher flusher = this._flusher;
        this._flusher = null;
        if (flusher != null) {
            this._persistit.waitForIOTaskStop(flusher);
        }
        JournalManager journalManager = this;
        synchronized (journalManager) {
            try {
                this.closeAllChannels();
            }
            catch (IOException ioe) {
                throw new PersistitIOException(ioe);
            }
            finally {
                this._handleToTreeMap.clear();
                this._handleToVolumeMap.clear();
                this._volumeToHandleMap.clear();
                this._treeToHandleMap.clear();
                this._pageMap.clear();
                this._pageList.clear();
                this._writeBuffer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllChannels() throws IOException {
        JournalManager journalManager = this;
        synchronized (journalManager) {
            try {
                for (FileChannel channel : this._journalFileChannels.values()) {
                    if (channel == null) continue;
                    channel.close();
                }
            }
            finally {
                this._journalFileChannels.clear();
            }
        }
    }

    void crash() throws IOException {
        IOTaskRunnable.crash(this._flusher);
        IOTaskRunnable.crash(this._copier);
        this.closeAllChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long flush() throws PersistitException {
        block14: {
            this._persistit.checkFatal();
            long address = this._writeBufferAddress;
            if (address != Long.MAX_VALUE && this._writeBuffer != null) {
                assert (this._writeBufferAddress + (long)this._writeBuffer.position() == this._currentAddress) : String.format("writeBufferAddress=%,d position=%,d currentAddress=%,d", this._writeBufferAddress, this._writeBuffer.position(), this._currentAddress);
                try {
                    int written;
                    if (this._writeBuffer.position() <= 0) break block14;
                    FileChannel channel = this.getFileChannel(address);
                    long size = channel.size();
                    if (size < this.addressToOffset(address)) {
                        throw new CorruptJournalException(String.format("Journal file %s size %,d does not match current address %,d", this.addressToFile(address), size, address));
                    }
                    this._writeBuffer.flip();
                    boolean writeComplete = false;
                    try {
                        channel.write(this._writeBuffer, this._writeBufferAddress % this._blockSize);
                        writeComplete = this._writeBuffer.remaining() == 0;
                    }
                    finally {
                        written = this._writeBuffer.position();
                        this._writeBufferAddress += (long)written;
                        if (writeComplete) {
                            if (this._writeBuffer.capacity() != this._writeBufferSize) {
                                this._writeBuffer = ByteBuffer.allocate(this._writeBufferSize);
                            } else {
                                this._writeBuffer.clear();
                            }
                        } else {
                            this._writeBuffer.compact();
                        }
                        long remaining = this._blockSize - this._writeBufferAddress % this._blockSize;
                        if (remaining < (long)this._writeBuffer.limit()) {
                            this._writeBuffer.limit((int)remaining);
                        }
                    }
                    assert (this._writeBufferAddress + (long)this._writeBuffer.position() == this._currentAddress) : String.format("writeBufferAddress=%,d position=%,d currentAddress=%,d", this._writeBufferAddress, this._writeBuffer.position(), this._currentAddress);
                    this._persistit.getIOMeter().chargeFlushJournal(written, address);
                    return this._writeBufferAddress;
                }
                catch (IOException e) {
                    throw new PersistitIOException("Writing to file " + this.addressToFile(address), e);
                }
            }
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void force() throws PersistitException {
        long address = Long.MAX_VALUE;
        try {
            address = this.flush();
            if (address != Long.MAX_VALUE) {
                FileChannel channel = this.getFileChannel(address);
                channel.force(false);
            }
        }
        catch (IOException e) {
            throw new PersistitIOException("Writing to file " + this.addressToFile(address), e);
        }
    }

    private boolean prepareWriteBuffer(int size) throws PersistitException {
        long remaining;
        this._persistit.checkFatal();
        boolean newJournalFile = false;
        if (this.getCurrentJournalSize() == 0L) {
            this.flush();
            this._writeBufferAddress = this._currentAddress;
            this.startJournalFile();
            newJournalFile = true;
        }
        assert (this._writeBufferAddress + (long)this._writeBuffer.position() == this._currentAddress) : String.format("writeBufferAddress=%,d position=%,d currentAddress=%,d", this._writeBufferAddress, this._writeBuffer.position(), this._currentAddress);
        if (this._writeBuffer.remaining() > size + 40) {
            return newJournalFile;
        }
        this.flush();
        if (this._writeBuffer.remaining() > size + 40) {
            return newJournalFile;
        }
        if (this._writeBuffer.remaining() == this._writeBuffer.capacity() && (remaining = this._blockSize - this.getCurrentJournalSize()) > (long)(size + 40)) {
            return newJournalFile;
        }
        this.rolloverWithNewFile();
        return true;
    }

    void rollover() throws PersistitException {
        this.rollover(false, false);
    }

    void rolloverWithNewFile() throws PersistitException {
        this.rollover(false, true);
    }

    void rolloverWithNewBaseAndFile() throws PersistitException {
        this.rollover(true, true);
    }

    private synchronized void rollover(boolean setBaseAddress, boolean startNewFile) throws PersistitException {
        if (this._writeBufferAddress != Long.MAX_VALUE) {
            this.writeJournalEnd();
            this.flush();
            try {
                long length = this.getCurrentJournalSize();
                boolean matches = length == ((long)this._writeBuffer.position() + this._writeBufferAddress) % this._blockSize;
                FileChannel channel = this.getFileChannel(this._currentAddress);
                Debug.$assert1.t(matches);
                if (matches) {
                    channel.truncate(length);
                }
                channel.force(true);
            }
            catch (IOException ioe) {
                throw new PersistitIOException(ioe);
            }
            this._currentAddress = (this._currentAddress / this._blockSize + 1L) * this._blockSize;
            this._writeBuffer.clear();
            this._writeBufferAddress = this._currentAddress;
            this._isNewEpoch = false;
            if (setBaseAddress) {
                this._baseAddress = this._currentAddress;
            }
            if (startNewFile) {
                this.prepareWriteBuffer(64);
            }
        }
    }

    private long epochalTimestamp() {
        return this._isNewEpoch ? this.getLastValidCheckpointTimestamp() : this._persistit.getCurrentTimestamp();
    }

    private void startJournalFile() throws PersistitException {
        this.writeJournalHeader();
        for (Map.Entry<Integer, Volume> entry : this._handleToVolumeMap.entrySet()) {
            this.writeVolumeHandleToJournal(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<Integer, Object> entry : this._handleToTreeMap.entrySet()) {
            if (((TreeDescriptor)entry.getValue()).getVolumeHandle() == Integer.MAX_VALUE) continue;
            this.writeTreeHandleToJournal((TreeDescriptor)entry.getValue(), entry.getKey());
        }
        this.writePageMap();
        this.writeTransactionMap();
        this.writeCheckpointToJournal(this._lastValidCheckpoint);
    }

    synchronized FileChannel getFileChannel(long address) throws PersistitIOException {
        if (address < this._deleteBoundaryAddress || address > this._currentAddress + this._blockSize) {
            throw new IllegalArgumentException("Invalid journal address " + address + " outside of range (" + this._deleteBoundaryAddress + ":" + (this._currentAddress + this._blockSize) + ")");
        }
        long generation = address / this._blockSize;
        FileChannel channel = this._journalFileChannels.get(generation);
        if (channel == null) {
            try {
                channel = new MediatedFileChannel(this.addressToFile(address), "rw");
                this._journalFileChannels.put(generation, channel);
            }
            catch (IOException ioe) {
                throw new PersistitIOException(ioe);
            }
        }
        return channel;
    }

    @Override
    public void copyBack() throws Exception {
        if (!this._appendOnly.get()) {
            this._copyFast.set(true);
            int exceptionCount = this._copier.getExceptionCount();
            while (this._copyFast.get()) {
                this._copier.kick();
                Util.sleep(500L);
                if (this._copier.getExceptionCount() == exceptionCount) continue;
                throw this._copier.getLastException();
            }
        }
    }

    private void checkpointWritten(CheckpointManager.Checkpoint checkpoint) {
        PageNode pageNode;
        long recoveryTimestamp = checkpoint.getTimestamp();
        recoveryTimestamp = Math.min(Math.min(recoveryTimestamp, this._earliestCommittedTimestamp), this._earliestAbortedTimestamp);
        Iterator<PageNode> iterator = this._pageMap.values().iterator();
        block0: while (iterator.hasNext()) {
            for (PageNode pn = pageNode = iterator.next(); pn != null; pn = pn.getPrevious()) {
                if (pn.getTimestamp() >= recoveryTimestamp) continue;
                pn.removeHistory();
                continue block0;
            }
        }
        Iterator<PageNode> iterator2 = this._branchMap.values().iterator();
        while (iterator2.hasNext()) {
            pageNode = iterator2.next();
            if (pageNode.getTimestamp() >= recoveryTimestamp) continue;
            iterator2.remove();
        }
        checkpoint.completed();
    }

    void pruneObsoleteTransactions() {
        this.pruneObsoleteTransactions(this.isRollbackPruningEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pruneObsoleteTransactions(boolean rollbackPruningEnabled) {
        Object status;
        long timestamp = this._lastValidCheckpoint.getTimestamp();
        long earliestCommitted = Long.MAX_VALUE;
        long earliestAborted = Long.MAX_VALUE;
        ArrayList<TransactionMapItem> toPrune = new ArrayList<TransactionMapItem>();
        ArrayList<TransactionMapItem> toPruneCommited = new ArrayList<TransactionMapItem>();
        JournalManager journalManager = this;
        synchronized (journalManager) {
            Iterator<TransactionMapItem> iterator = this._liveTransactionMap.values().iterator();
            while (iterator.hasNext()) {
                TransactionMapItem item = iterator.next();
                if (item.isCommitted()) {
                    if (item.getCommitTimestamp() < timestamp) {
                        toPruneCommited.add(item);
                        continue;
                    }
                    if (item.getStartTimestamp() >= earliestCommitted) continue;
                    earliestCommitted = item.getStartTimestamp();
                    continue;
                }
                status = this._persistit.getTransactionIndex().getStatus(item.getStartTimestamp());
                if (status == null || ((TransactionStatus)status).getTs() != item.getStartTimestamp()) {
                    iterator.remove();
                    continue;
                }
                if (((TransactionStatus)status).getTc() != Long.MIN_VALUE || !((TransactionStatus)status).isNotified()) continue;
                if (((TransactionStatus)status).getMvvCount() == 0) {
                    iterator.remove();
                    ThreadSequencer.sequence(SequencerConstants.RECOVERY_PRUNING_B);
                    continue;
                }
                if (item.getStartTimestamp() < earliestAborted) {
                    earliestAborted = item.getStartTimestamp();
                }
                if (!rollbackPruningEnabled) continue;
                toPrune.add(item);
            }
            this._earliestCommittedTimestamp = earliestCommitted;
            this._earliestAbortedTimestamp = earliestAborted;
        }
        Collections.sort(toPruneCommited, TransactionMapItem.TRANSACTION_MAP_ITEM_COMPARATOR);
        ArrayList<Long> startTimestamps = new ArrayList<Long>(toPruneCommited.size());
        for (TransactionMapItem item : toPruneCommited) {
            try {
                status = this._player;
                synchronized (status) {
                    this._player.applyTransaction(item, this._pruneCommited);
                }
                startTimestamps.add(item.getStartTimestamp());
            }
            catch (PersistitException e) {
                this._persistit.getLogBase().pruneException.log(e, item);
            }
        }
        Iterator iterator = this;
        synchronized (iterator) {
            this._liveTransactionMap.keySet().removeAll(startTimestamps);
        }
        Collections.sort(toPrune, TransactionMapItem.TRANSACTION_MAP_ITEM_COMPARATOR);
        for (TransactionMapItem item : toPrune) {
            try {
                TransactionPlayer e = this._player;
                synchronized (e) {
                    TransactionStatus status2 = this._persistit.getTransactionIndex().getStatus(item.getStartTimestamp());
                    if (status2 != null && status2.getTs() == item.getStartTimestamp() && status2.getTc() == Long.MIN_VALUE && status2.isNotified() && status2.getMvvCount() > 0) {
                        this._player.applyTransaction(item, this._listener);
                    }
                }
            }
            catch (PersistitException e) {
                this._persistit.getLogBase().pruneException.log(e, item);
            }
        }
    }

    void waitForDurability(long flushedTimestamp, long leadTime, long stallTime) throws PersistitException {
        JournalFlusher flusher = this._flusher;
        if (flusher == null) {
            throw new IllegalStateException("JOURNAL_FLUSHER is not running");
        }
        flusher.waitForDurability(flushedTimestamp, leadTime, stallTime);
    }

    synchronized void selectForCopy(List<PageNode> list) {
        list.clear();
        if (!this._appendOnly.get()) {
            long timeStampUpperBound = Math.min(this.getLastValidCheckpointTimestamp(), this._copierTimestampLimit);
            Iterator iterator = this._pageList.iterator();
            while (iterator.hasNext()) {
                PageNode pageNode;
                for (PageNode pn = pageNode = (PageNode)iterator.next(); pn != null && !pn.isInvalid(); pn = pn.getPrevious()) {
                    if (pn.getTimestamp() >= timeStampUpperBound) continue;
                    list.add(pn);
                    break;
                }
                if (list.size() < this._copiesPerCycle) continue;
                break;
            }
        }
    }

    void readForCopy(List<PageNode> list, ByteBuffer bb) throws PersistitException {
        Collections.sort(list, PageNode.READ_COMPARATOR);
        bb.clear();
        Volume volume = null;
        int handle = -1;
        Iterator<PageNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            long pageAddress;
            PageNode pageNode = iterator.next();
            if (pageNode.isInvalid()) {
                iterator.remove();
                continue;
            }
            pageNode.setOffset(-1);
            if (pageNode.getVolumeHandle() != handle) {
                handle = -1;
                try {
                    volume = this.volumeForHandle(pageNode.getVolumeHandle());
                    handle = volume.getHandle();
                }
                catch (VolumeNotFoundException vnfe) {
                    continue;
                }
            }
            if (volume == null) continue;
            int at = bb.position();
            try {
                PageNode stablePageNode = new PageNode(pageNode);
                if (pageNode.isInvalid()) {
                    iterator.remove();
                    continue;
                }
                pageAddress = this.readPageBufferFromJournal(stablePageNode, bb);
                this._persistit.getIOMeter().chargeCopyPageFromJournal(volume, pageAddress, volume.getPageSize(), stablePageNode.getJournalAddress(), this.urgency());
            }
            catch (PersistitException ioe) {
                this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.ERROR, this._persistit.getLogBase().copyException, ioe, volume, pageNode.getPageAddress(), pageNode.getJournalAddress()), "Journal");
                throw ioe;
            }
            Debug.$assert0.t(pageAddress == pageNode.getPageAddress());
            pageNode.setOffset(at);
            if (bb.limit() - at != volume.getStructure().getPageSize()) {
                throw new CorruptJournalException(pageNode.toStringPageAddress(this) + " bufferSize " + bb.limit() + " does not match " + volume + " bufferSize " + volume.getPageSize() + " at " + pageNode.toStringJournalAddress(this));
            }
            bb.position(bb.limit());
        }
    }

    void writeForCopy(List<PageNode> list, ByteBuffer bb) throws PersistitException {
        Collections.sort(list, PageNode.WRITE_COMPARATOR);
        Volume volume = null;
        int handle = -1;
        HashSet<Volume> volumes = new HashSet<Volume>();
        Iterator<PageNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            PageNode pageNode;
            block9: {
                pageNode = iterator.next();
                if (pageNode.getVolumeHandle() != handle) {
                    handle = -1;
                    volume = null;
                    Volume candidate = null;
                    try {
                        candidate = this.lookupVolumeHandle(pageNode.getVolumeHandle());
                        if (candidate == null) break block9;
                        if (!candidate.isOpened()) {
                            candidate.open(this._persistit);
                        }
                        handle = pageNode.getVolumeHandle();
                        volume = candidate;
                    }
                    catch (VolumeNotFoundException vnfe) {
                        this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.WARN, this._persistit.getLogBase().missingVolume, candidate, pageNode.getJournalAddress()), "MissingVolume");
                        if (!this._ignoreMissingVolume.get()) break block9;
                        this._persistit.getLogBase().lostPageFromMissingVolume.log(pageNode.getPageAddress(), candidate, pageNode.getJournalAddress());
                        continue;
                    }
                }
            }
            if (volume == null || volume.isClosed()) {
                iterator.remove();
                continue;
            }
            long pageAddress = pageNode.getPageAddress();
            volume.getStorage().extend(pageAddress);
            int pageSize = volume.getPageSize();
            int at = pageNode.getOffset();
            bb.limit(bb.capacity()).position(at).limit(at + pageSize);
            try {
                volume.getStorage().writePage(bb, pageAddress);
                volumes.add(volume);
            }
            catch (PersistitException ioe) {
                this._persistit.getLogBase().copyException.log(ioe, volume, pageNode.getPageAddress(), pageNode.getJournalAddress());
                throw ioe;
            }
            ++this._copiedPageCount;
            this._persistit.getIOMeter().chargeCopyPageToVolume(volume, pageAddress, volume.getPageSize(), pageNode.getJournalAddress(), this.urgency());
        }
        for (Volume vol : volumes) {
            vol.getStorage().force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupForCopy(List<PageNode> list) throws PersistitException {
        ArrayList<FileChannel> obsoleteFileChannels = new ArrayList<FileChannel>();
        ArrayList<File> obsoleteFiles = new ArrayList<File>();
        long deleteBoundary = 0L;
        JournalManager journalManager = this;
        synchronized (journalManager) {
            Object pageNode;
            block5: for (PageNode copiedPageNode : list) {
                pageNode = this._pageMap.get(copiedPageNode);
                if (((PageNode)pageNode).getJournalAddress() == copiedPageNode.getJournalAddress()) {
                    ((PageNode)pageNode).removeHistory();
                    ((PageNode)pageNode).invalidate();
                    PageNode pn = this._pageMap.remove(pageNode);
                    assert (pn == copiedPageNode);
                    continue;
                }
                PageNode previous = ((PageNode)pageNode).getPrevious();
                while (previous != null) {
                    if (previous.getJournalAddress() == copiedPageNode.getJournalAddress()) {
                        ((PageNode)pageNode).removeHistory();
                        continue block5;
                    }
                    pageNode = previous;
                    previous = ((PageNode)pageNode).getPrevious();
                }
            }
            this._droppedPageCount += (long)(this.cleanupPageList() - list.size());
            long recoveryBoundary = this._currentAddress;
            pageNode = this._pageMap.values().iterator();
            while (pageNode.hasNext()) {
                PageNode pageNode2;
                for (PageNode pn = pageNode2 = (PageNode)pageNode.next(); pn != null; pn = pn.getPrevious()) {
                    if (pn.isInvalid() || pn.getJournalAddress() >= recoveryBoundary) continue;
                    recoveryBoundary = pn.getJournalAddress();
                }
            }
            for (TransactionMapItem item : this._liveTransactionMap.values()) {
                if (item.getStartAddress() >= recoveryBoundary) continue;
                recoveryBoundary = item.getStartAddress();
            }
            if (recoveryBoundary < this._baseAddress) {
                throw new IllegalStateException(String.format("Retrograde base address %,d is less than current %,d", recoveryBoundary, this._baseAddress));
            }
            this._baseAddress = recoveryBoundary;
            deleteBoundary = this._deleteBoundaryAddress;
            while (deleteBoundary + this._blockSize <= this._lastValidCheckpointBaseAddress) {
                long generation = deleteBoundary / this._blockSize;
                FileChannel channel = this._journalFileChannels.remove(generation);
                if (channel != null) {
                    obsoleteFileChannels.add(channel);
                }
                obsoleteFiles.add(this.addressToFile(deleteBoundary));
                deleteBoundary += this._blockSize;
            }
            if (this._baseAddress == this._currentAddress && this._lastValidCheckpointBaseAddress >= this._currentAddress - 32L && this.getCurrentJournalSize() > this.rolloverThreshold()) {
                FileChannel channel = this._journalFileChannels.remove(this._currentAddress / this._blockSize);
                if (channel != null) {
                    obsoleteFileChannels.add(channel);
                }
                obsoleteFiles.add(this.addressToFile(this._currentAddress));
                this.rolloverWithNewBaseAndFile();
            }
        }
        for (FileChannel channel : obsoleteFileChannels) {
            if (channel == null) continue;
            try {
                channel.close();
            }
            catch (IOException copiedPageNode) {}
        }
        boolean deleted = true;
        for (File file : obsoleteFiles) {
            if (file.delete()) continue;
            deleted = false;
        }
        if (deleted) {
            this._deleteBoundaryAddress = deleteBoundary;
        }
        this.reportJournalFileCount();
    }

    int cleanupPageList() {
        int from;
        int size = this._pageList.size();
        for (from = 0; from < size && !((PageNode)this._pageList.get(from)).isInvalid(); ++from) {
        }
        int to = from++;
        while (from < size) {
            PageNode pn = (PageNode)this._pageList.get(from);
            if (!pn.isInvalid()) {
                this._pageList.set(to++, pn);
            }
            ++from;
        }
        if (size > to) {
            this._pageList.removeRange(to, size);
        }
        return size - to;
    }

    synchronized void truncate(Volume volume, long timestamp) {
        Iterator<PageNode> iterator = this._pageMap.values().iterator();
        while (iterator.hasNext()) {
            PageNode lastPageNode;
            for (PageNode pageNode = lastPageNode = iterator.next(); pageNode != null; pageNode = pageNode.getPrevious()) {
                if (volume.getHandle() != pageNode.getVolumeHandle() || pageNode.getTimestamp() >= timestamp) continue;
                pageNode.invalidate();
            }
        }
    }

    private void reportJournalFileCount() {
        int journalFileCount = this.getJournalFileCount();
        if (journalFileCount != this._lastReportedJournalFileCount) {
            if (journalFileCount > 10 + this._urgentFileCountThreshold) {
                this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.ERROR, this._persistit.getLogBase().tooManyJournalFilesError, journalFileCount), "JournalFiles");
            } else if (journalFileCount > 5 + this._urgentFileCountThreshold) {
                this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.WARN, this._persistit.getLogBase().tooManyJournalFilesWarning, journalFileCount), "JournalFiles");
            } else {
                this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.NORMAL, this._persistit.getLogBase().normalJournalFileCount, journalFileCount), "JournalFiles");
            }
            this._lastReportedJournalFileCount = journalFileCount;
        }
    }

    private long rolloverThreshold() {
        return this._closed.get() ? 0L : 0x400000L;
    }

    public int getHandleCount() {
        return this._handleCounter;
    }

    long getLastValidCheckpointBaseAddress() {
        return this._lastValidCheckpointBaseAddress;
    }

    synchronized void unitTestInjectVolumes(Map<Integer, Volume> handleToVolumeMap) {
        this._handleToVolumeMap.putAll(handleToVolumeMap);
    }

    void unitTestInjectPageMap(Map<PageNode, PageNode> pageMap) {
        this._pageMap.putAll(pageMap);
    }

    void unitTestInjectTransactionMap(Map<Long, TransactionMapItem> transactionMap) {
        this._liveTransactionMap.putAll(transactionMap);
    }

    void unitTestClearTransactionMap() {
        this._liveTransactionMap.clear();
    }

    long getCurrentJournalSize() {
        return this._currentAddress % this._blockSize;
    }

    long getWriteBufferAddress() {
        return this._writeBufferAddress;
    }

    int getJournalFileCount() {
        return (int)(this._currentAddress / this._blockSize - this._baseAddress / this._blockSize) + 1;
    }

    synchronized boolean unitTestTxnExistsInLiveMap(Long startTimestamp) {
        return this._liveTransactionMap.containsKey(startTimestamp);
    }

    void unitTestInjectPageList(List<PageNode> list) {
        this._pageList.addAll(list);
    }

    boolean unitTestPageListEquals(List<PageNode> list) {
        return list.equals(this._pageList);
    }

    synchronized List<File> unitTestGetAllJournalFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (Long address : this._journalFileChannels.keySet()) {
            files.add(this.addressToFile(address));
        }
        return files;
    }

    void unitTestAllowHandlesForTemporaryVolumesAndTrees() {
        this._allowHandlesForTempVolumesAndTrees = true;
    }

    public PageNode queryPageNode(int volumeHandle, long pageAddress) {
        PageNode pn = this._pageMap.get(new PageNode(volumeHandle, pageAddress, -1L, -1L));
        if (pn != null) {
            return new PageNode(pn);
        }
        return null;
    }

    public PageNode queryBranchNode(int volumeHandle, long pageAddress) {
        PageNode pn = this._branchMap.get(new PageNode(volumeHandle, pageAddress, -1L, -1L));
        if (pn != null) {
            return new PageNode(pn);
        }
        return null;
    }

    public TransactionMapItem queryTransactionMap(long timestamp) {
        TransactionMapItem item = this._liveTransactionMap.get(timestamp);
        if (item != null) {
            return new TransactionMapItem(item);
        }
        return null;
    }

    public SortedMap<Integer, Volume> queryVolumeMap() {
        return new TreeMap<Integer, Volume>(this._handleToVolumeMap);
    }

    public SortedMap<Integer, TreeDescriptor> queryTreeMap() {
        return new TreeMap<Integer, TreeDescriptor>(this._handleToTreeMap);
    }

    static class RangeRemovingArrayList<T>
    extends ArrayList<T> {
        RangeRemovingArrayList() {
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }

    class ProactiveRollbackListener
    implements TransactionPlayer.TransactionPlayerListener {
        TransactionStatus status;

        ProactiveRollbackListener() {
        }

        @Override
        public void store(long address, long timestamp, Exchange exchange) throws PersistitException {
            exchange.prune();
        }

        @Override
        public void removeKeyRange(long address, long timestamp, Exchange exchange, Key from, Key to) throws PersistitException {
            try {
                exchange.prune(from, to);
            }
            catch (RebalanceException rebalanceException) {
                // empty catch block
            }
        }

        @Override
        public void removeTree(long address, long timestamp, Exchange exchange) throws PersistitException {
        }

        @Override
        public void delta(long address, long timestamp, Tree tree, int index, int accumulatorType, long value) throws PersistitException {
        }

        @Override
        public void startRecovery(long address, long timestamp) throws PersistitException {
        }

        @Override
        public void startTransaction(long address, long startTimestamp, long commitTimestamp) throws PersistitException {
            this.status = JournalManager.this._persistit.getTransactionIndex().getStatus(startTimestamp);
        }

        @Override
        public void endTransaction(long address, long timestamp) throws PersistitException {
            TransactionStatus ts = JournalManager.this._persistit.getTransactionIndex().getStatus(timestamp);
            if (ts != null && ts.getMvvCount() > 0 && JournalManager.this._persistit.isInitialized()) {
                ((JournalManager)JournalManager.this)._persistit.getLogBase().pruningIncomplete.log(ts, TransactionPlayer.addressToString(address, timestamp));
            }
        }

        @Override
        public void endRecovery(long address, long timestamp) throws PersistitException {
        }

        @Override
        public boolean requiresLongRecordConversion() {
            return false;
        }

        @Override
        public boolean createTree(long timestamp) throws PersistitException {
            return false;
        }
    }

    class PruneTransactionPlayer
    implements TransactionPlayer.TransactionPlayerListener {
        PruneTransactionPlayer() {
        }

        @Override
        public void startRecovery(long address, long timestamp) throws PersistitException {
        }

        @Override
        public void startTransaction(long address, long timestamp, long commitTimestamp) throws PersistitException {
        }

        @Override
        public void store(long address, long timestamp, Exchange exchange) throws PersistitException {
        }

        @Override
        public void removeKeyRange(long address, long startTimestamp, Exchange exchange, Key from, Key to) throws PersistitException {
            try {
                exchange.prune(from, to);
            }
            catch (RebalanceException rebalanceException) {
                // empty catch block
            }
        }

        @Override
        public void removeTree(long address, long timestamp, Exchange exchange) throws PersistitException {
        }

        @Override
        public void delta(long address, long timestamp, Tree tree, int index, int accumulatorType, long value) throws PersistitException {
        }

        @Override
        public void endTransaction(long address, long timestamp) throws PersistitException {
        }

        @Override
        public void endRecovery(long address, long timestamp) throws PersistitException {
        }

        @Override
        public boolean requiresLongRecordConversion() {
            return false;
        }

        @Override
        public boolean createTree(long timestamp) throws PersistitException {
            return false;
        }
    }

    private class JournalTransactionPlayerSupport
    implements TransactionPlayerSupport {
        final ByteBuffer _readBuffer = ByteBuffer.allocate(65568);

        private JournalTransactionPlayerSupport() {
        }

        @Override
        public void read(long address, int size) throws PersistitIOException {
            this._readBuffer.clear().limit(size);
            JournalManager.this.readFully(this._readBuffer, address);
        }

        @Override
        public ByteBuffer getReadBuffer() {
            return this._readBuffer;
        }

        @Override
        public void convertToLongRecord(Value value, int treeHandle, long address, long commitTimestamp) throws PersistitException {
        }

        @Override
        public Persistit getPersistit() {
            return JournalManager.this._persistit;
        }
    }

    private class JournalFlusher
    extends IOTaskRunnable {
        volatile long _lastExceptionTimestamp;
        volatile Exception _lastException;
        long[] _ioTimes;
        int _ioCycle;
        volatile long _expectedIoTime;
        volatile long _startTime;
        volatile long _endTime;
        volatile long _startTimestamp;
        volatile long _endTimestamp;

        JournalFlusher() {
            super(JournalManager.this._persistit);
            this._lastExceptionTimestamp = 0L;
            this._lastException = null;
            this._ioTimes = new long[8];
        }

        void start() {
            this.start("JOURNAL_FLUSHER", JournalManager.this._flushInterval);
        }

        private void waitForDurability(long flushedTimestamp, long leadTime, long stallTime) throws PersistitException {
            long now = System.nanoTime();
            long remainingStallTime = stallTime;
            while (true) {
                long endTime;
                long endTimestamp;
                long startTimestamp;
                long estimatedRemainingIoNanos = -1L;
                while (true) {
                    startTimestamp = this._startTimestamp;
                    endTimestamp = this._endTimestamp;
                    long startTime = this._startTime;
                    endTime = this._endTime;
                    if (startTimestamp == this._startTimestamp && endTimestamp == this._endTimestamp) {
                        if (flushedTimestamp <= startTimestamp || startTimestamp <= endTimestamp) break;
                        estimatedRemainingIoNanos = Math.max(startTime + this._expectedIoTime - now, 0L);
                        break;
                    }
                    Util.spinSleep();
                }
                if (endTimestamp > flushedTimestamp && startTimestamp > flushedTimestamp) break;
                long remainingSleepNanos = estimatedRemainingIoNanos == -1L ? Math.max(0L, JournalManager.this._flushInterval - (now - endTime)) : JournalManager.this._flushInterval;
                long estimatedNanosToFinish = startTimestamp < flushedTimestamp ? remainingSleepNanos + this._expectedIoTime : estimatedRemainingIoNanos;
                if (leadTime > 0L && leadTime * 1000000L >= estimatedNanosToFinish) break;
                if (estimatedRemainingIoNanos == -1L) {
                    if (remainingStallTime > 0L) {
                        Util.sleep(remainingStallTime);
                        remainingStallTime = 0L;
                        continue;
                    }
                    this.kick();
                    Util.spinSleep();
                    continue;
                }
                Util.spinSleep();
            }
            if (this._lastExceptionTimestamp > flushedTimestamp) {
                Exception e = this._lastException;
                if (e instanceof PersistitException) {
                    throw (PersistitException)e;
                }
                throw new PersistitException(e);
            }
            JournalManager.this._totalCommits.incrementAndGet();
            JournalManager.this._totalCommitWaitTime.addAndGet(System.nanoTime() - now);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runTask() {
            block13: {
                JournalManager.this._flushing.set(true);
                try {
                    try {
                        try {
                            this._startTimestamp = this._persistit.getTimestampAllocator().updateTimestamp();
                            this._startTime = System.nanoTime();
                            JournalManager.this.force();
                        }
                        finally {
                            this._endTime = System.nanoTime();
                            this._endTimestamp = this._persistit.getTimestampAllocator().updateTimestamp();
                        }
                        long elapsed = this._endTime - this._startTime;
                        JournalManager.this._totalFlushCycles.incrementAndGet();
                        JournalManager.this._totalFlushIoTime.addAndGet(elapsed);
                        this._ioTimes[this._ioCycle] = elapsed;
                        this._ioCycle = (this._ioCycle + 1) % 8;
                        long avg = 0L;
                        for (int index = 0; index < 8; ++index) {
                            avg += this._ioTimes[index];
                        }
                        this._expectedIoTime = avg /= 8L;
                        if (elapsed > JournalManager.this._slowIoAlertThreshold * 1000000L) {
                            this._persistit.getLogBase().longJournalIO.log(elapsed / 1000000L, 8, avg / 1000000L);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException || e instanceof Persistit.FatalErrorException) {
                            JournalManager.this._closed.set(true);
                            break block13;
                        }
                        if (e instanceof PersistitException) {
                            this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.ERROR, this._persistit.getLogBase().journalWriteError, e, JournalManager.this.addressToFile(JournalManager.this._writeBufferAddress), JournalManager.this.addressToOffset(JournalManager.this._writeBufferAddress)), "Journal");
                            break block13;
                        }
                        this._persistit.getLogBase().journalWriteError.log(e, JournalManager.this.addressToFile(JournalManager.this._writeBufferAddress), JournalManager.this.addressToOffset(JournalManager.this._writeBufferAddress));
                    }
                }
                finally {
                    JournalManager.this._flushing.set(false);
                }
            }
        }

        @Override
        protected boolean shouldStop() {
            return JournalManager.this._closed.get();
        }
    }

    private class JournalCopier
    extends IOTaskRunnable {
        private volatile boolean _shouldStop;
        private final ByteBuffer _bb;
        private final List<PageNode> _copyList;
        int _lastCyclePagesWritten;

        JournalCopier() {
            super(JournalManager.this._persistit);
            this._shouldStop = false;
            this._bb = ByteBuffer.allocate(0x1000000);
            this._copyList = new ArrayList<PageNode>(JournalManager.this._copiesPerCycle);
        }

        void start() {
            this.start("JOURNAL_COPIER", JournalManager.this._copierInterval);
        }

        @Override
        public void runTask() throws Exception {
            JournalManager.this._copying.set(true);
            try {
                this._copyList.clear();
                if (!JournalManager.this._appendOnly.get()) {
                    JournalManager.this.selectForCopy(this._copyList);
                    if (!this._copyList.isEmpty()) {
                        JournalManager.this.readForCopy(this._copyList, this._bb);
                    }
                    if (!this._copyList.isEmpty()) {
                        JournalManager.this.writeForCopy(this._copyList, this._bb);
                    }
                }
                JournalManager.this.cleanupForCopy(this._copyList);
                this._lastCyclePagesWritten = this._copyList.size();
                if (this._copyList.isEmpty()) {
                    JournalManager.this._copyFast.set(false);
                }
            }
            finally {
                JournalManager.this._copying.set(false);
            }
            long throttleInterval = 0L;
            if (!JournalManager.this._appendOnly.get()) {
                int urgency = JournalManager.this.urgency();
                if (urgency == 10) {
                    throttleInterval = 50L;
                } else if (urgency > 8) {
                    throttleInterval = 12L;
                }
            }
            if (throttleInterval != JournalManager.this._throttleSleepInterval) {
                JournalManager.this._throttleSleepInterval = throttleInterval;
            }
        }

        @Override
        protected boolean shouldStop() {
            return JournalManager.this._closed.get() || this._shouldStop;
        }

        @Override
        public long pollInterval() {
            long pollInterval = super.getPollInterval();
            if (this._lastCyclePagesWritten == 0 || JournalManager.this.getJournalFileCount() < 5) {
                return pollInterval;
            }
            return 0L;
        }
    }

    public static class TransactionMapItem
    implements Comparable<TransactionMapItem> {
        private final long _startAddress;
        private final long _startTimestamp;
        private long _commitTimestamp;
        private long _lastRecordAddress;
        static final Comparator<TransactionMapItem> TRANSACTION_MAP_ITEM_COMPARATOR = new Comparator<TransactionMapItem>(){

            @Override
            public int compare(TransactionMapItem a, TransactionMapItem b) {
                return a.getLastRecordAddress() > b.getLastRecordAddress() ? 1 : (a.getLastRecordAddress() < b.getLastRecordAddress() ? -1 : 0);
            }
        };

        TransactionMapItem(long startTimestamp, long address) {
            this._startTimestamp = startTimestamp;
            this._commitTimestamp = 0L;
            this._startAddress = address;
            this._lastRecordAddress = address;
        }

        TransactionMapItem(TransactionMapItem item) {
            this._startAddress = item._startAddress;
            this._startTimestamp = item._startTimestamp;
            this._commitTimestamp = item._commitTimestamp;
            this._lastRecordAddress = item._lastRecordAddress;
        }

        public long getStartAddress() {
            return this._startAddress;
        }

        public long getStartTimestamp() {
            return this._startTimestamp;
        }

        public long getCommitTimestamp() {
            return this._commitTimestamp;
        }

        public long getLastRecordAddress() {
            return this._lastRecordAddress;
        }

        void setCommitTimestamp(long commitTimestamp) {
            this._commitTimestamp = commitTimestamp;
        }

        void setLastRecordAddress(long address) {
            this._lastRecordAddress = address;
        }

        public boolean isCommitted() {
            return this._commitTimestamp > 0L;
        }

        public boolean isAborted() {
            return this._commitTimestamp == Long.MIN_VALUE;
        }

        public String toString() {
            return String.format("TStatus %,d{%,d}%s", this._startAddress, this._commitTimestamp, this.isCommitted() ? "c" : "u");
        }

        @Override
        public int compareTo(TransactionMapItem ts) {
            if (this.isCommitted()) {
                return ts.getCommitTimestamp() < this._commitTimestamp ? 1 : (ts.getCommitTimestamp() > this._commitTimestamp ? -1 : 0);
            }
            return ts.isCommitted() ? -1 : (ts.getStartTimestamp() < this._startTimestamp ? 1 : (ts.getStartTimestamp() > this._startTimestamp ? -1 : 0));
        }
    }

    public static class PageNode {
        final int _volumeHandle;
        final long _pageAddress;
        final long _timestamp;
        long _journalAddress;
        int _offset;
        PageNode _previous;
        static final Comparator<PageNode> READ_COMPARATOR = new Comparator<PageNode>(){

            @Override
            public int compare(PageNode a, PageNode b) {
                if (!a.isInvalid() && !b.isInvalid()) {
                    return a.getJournalAddress() > b.getJournalAddress() ? 1 : (a.getJournalAddress() < b.getJournalAddress() ? -1 : 0);
                }
                if (a.isInvalid() && !b.isInvalid()) {
                    return -1;
                }
                if (!a.isInvalid() && b.isInvalid()) {
                    return 1;
                }
                if (a._volumeHandle != b._volumeHandle) {
                    return a._volumeHandle - b._volumeHandle;
                }
                return a._pageAddress > b._pageAddress ? 1 : (a._pageAddress < b._pageAddress ? -1 : 0);
            }
        };
        static final Comparator<PageNode> WRITE_COMPARATOR = new Comparator<PageNode>(){

            @Override
            public int compare(PageNode a, PageNode b) {
                if (a.getVolumeHandle() != b.getVolumeHandle()) {
                    return a.getVolumeHandle() < b._volumeHandle ? -1 : 1;
                }
                return a.getPageAddress() < b.getPageAddress() ? -1 : (a.getPageAddress() > b.getPageAddress() ? 1 : 0);
            }
        };

        PageNode(int volumeHandle, long pageAddress) {
            this(volumeHandle, pageAddress, Long.MIN_VALUE, -1L);
        }

        PageNode(int volumeHandle, long pageAddress, long journalAddress, long timestamp) {
            this._volumeHandle = volumeHandle;
            this._pageAddress = pageAddress;
            this._journalAddress = journalAddress;
            this._timestamp = timestamp;
        }

        PageNode(PageNode pageNode) {
            this._volumeHandle = pageNode._volumeHandle;
            this._pageAddress = pageNode._pageAddress;
            this._journalAddress = pageNode._journalAddress;
            this._timestamp = pageNode._timestamp;
            this._offset = pageNode._offset;
            PageNode previous = pageNode._previous;
            if (previous != null) {
                this._previous = new PageNode(previous);
            }
        }

        public PageNode getPrevious() {
            return this._previous;
        }

        public void setPrevious(PageNode previous) {
            if (previous != null) assert (this._timestamp >= previous._timestamp);
            this._previous = previous;
        }

        public int getVolumeHandle() {
            return this._volumeHandle;
        }

        public long getPageAddress() {
            return this._pageAddress;
        }

        public long getJournalAddress() {
            return this._journalAddress;
        }

        public long getTimestamp() {
            return this._timestamp;
        }

        public void setOffset(int offset) {
            this._offset = offset;
        }

        public int getOffset() {
            return this._offset;
        }

        public int hashCode() {
            return this._volumeHandle ^ (int)this._pageAddress ^ (int)(this._pageAddress >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof PageNode)) {
                return false;
            }
            PageNode pn = (PageNode)obj;
            return this._pageAddress == pn._pageAddress && this._volumeHandle == pn._volumeHandle;
        }

        public String toString() {
            return String.format("[%d]%d@%d{%d}%s", this._volumeHandle, this._pageAddress, this._journalAddress, this._timestamp, this._previous == null ? "" : "+");
        }

        public String toString(JournalManager jman) {
            Volume volume = (Volume)jman._handleToVolumeMap.get(this._volumeHandle);
            if (volume == null) {
                return this.toString();
            }
            return String.format("%s:%d@%d{%d}%s", volume, this._pageAddress, this._journalAddress, this._timestamp, this._previous == null ? "" : "+");
        }

        public String toStringPageAddress(VolumeHandleLookup lvh) {
            Volume volume = lvh.lookupVolumeHandle(this._volumeHandle);
            return String.format("%s:%d", volume == null ? String.valueOf(this._volumeHandle) : volume.toString(), this._pageAddress);
        }

        public String toStringJournalAddress(VolumeHandleLookup lvn) {
            return String.format("%d{%d}%s", this._journalAddress, this._timestamp, this._previous == null ? "" : "+");
        }

        boolean isInvalid() {
            return this._journalAddress == Long.MIN_VALUE;
        }

        void invalidate() {
            this._journalAddress = Long.MIN_VALUE;
        }

        void removeHistory() {
            PageNode pn = this.getPrevious();
            this.setPrevious(null);
            while (pn != null) {
                PageNode previous = pn.getPrevious();
                pn.invalidate();
                pn.setPrevious(null);
                pn = previous;
            }
        }
    }

    public static class TreeDescriptor {
        final int _volumeHandle;
        final String _treeName;

        TreeDescriptor(int volumeHandle, String treeName) {
            this._volumeHandle = volumeHandle;
            this._treeName = treeName;
        }

        public int getVolumeHandle() {
            return this._volumeHandle;
        }

        public String getTreeName() {
            return this._treeName;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TreeDescriptor)) {
                return false;
            }
            TreeDescriptor td = (TreeDescriptor)obj;
            return td._treeName.equals(this._treeName) && td._volumeHandle == this._volumeHandle;
        }

        public int hashCode() {
            return this._treeName.hashCode() ^ this._volumeHandle;
        }

        public String toString() {
            return "{" + this._volumeHandle + "}" + this._treeName;
        }
    }
}

