/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.Value;
import com.persistit.exception.InvalidKeyException;
import java.util.Arrays;

class AntiValue {
    private final int _elisionCount;
    private final byte[] _bytes;

    AntiValue(int ec, byte[] bytes) {
        this._elisionCount = ec;
        this._bytes = bytes;
    }

    static void putAntiValue(Value value, Key key1, Key key2) {
        int elisionCount = key1.firstUniqueByteIndex(key2);
        int size = key2.getEncodedSize() - elisionCount;
        byte[] bytes = new byte[size];
        System.arraycopy(key2.getEncodedBytes(), elisionCount, bytes, 0, size);
        value.putAntiValue((short)elisionCount, bytes);
    }

    static void fixUpKeys(Exchange exchange, int elisionCount, byte[] bytes, int offset, int length) throws InvalidKeyException {
        Key spareKey1 = exchange.getAuxiliaryKey1();
        Key spareKey2 = exchange.getAuxiliaryKey2();
        spareKey1.copyTo(spareKey2);
        byte[] baseBytes = spareKey2.getEncodedBytes();
        int baseSize = spareKey2.getEncodedSize();
        if (baseSize < elisionCount || elisionCount + length > 2047) {
            throw new InvalidKeyException("Key encoding in transaction is invalid");
        }
        System.arraycopy(bytes, offset, baseBytes, elisionCount, length);
        spareKey2.setEncodedSize(elisionCount + length);
    }

    int getElisionCount() {
        return this._elisionCount;
    }

    byte[] getBytes() {
        return this._bytes;
    }

    public String toString() {
        return '{' + (this._elisionCount > 0 ? "elision=" + this._elisionCount + " " + Arrays.toString(this._bytes) : "") + '}';
    }
}

