/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TableSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;

public final class TableBuilder {
    private int column;
    private List<Integer> columnWidths = new ArrayList<Integer>();
    private List<LocalizableMessage> header = new ArrayList<LocalizableMessage>();
    private int height;
    private List<List<String>> rows = new ArrayList<List<String>>();
    private List<Comparator<String>> sortComparators = new ArrayList<Comparator<String>>();
    private List<Integer> sortKeys = new ArrayList<Integer>();
    private int width;

    public void addSortKey(int column) {
        this.addSortKey(column, String.CASE_INSENSITIVE_ORDER);
    }

    public void addSortKey(int column, Comparator<String> comparator) {
        this.sortKeys.add(column);
        this.sortComparators.add(comparator);
    }

    public void appendCell() {
        this.appendCell("");
    }

    public void appendCell(boolean value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(byte value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(char value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(double value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(float value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(int value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(long value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(Object value) {
        if (this.height == 0) {
            this.startRow();
        }
        String s = String.valueOf(value);
        this.rows.get(this.height - 1).add(s);
        ++this.column;
        if (this.column > this.width) {
            this.width = this.column;
            this.columnWidths.add(s.length());
        } else if (this.columnWidths.get(this.column - 1) < s.length()) {
            this.columnWidths.set(this.column - 1, s.length());
        }
    }

    public void appendHeading() {
        this.appendHeading(LocalizableMessage.EMPTY);
    }

    public void appendHeading(LocalizableMessage value) {
        this.header.add(value);
        if (this.header.size() > this.width) {
            this.width = this.header.size();
            this.columnWidths.add(value.length());
        } else if (this.columnWidths.get(this.header.size() - 1) < value.length()) {
            this.columnWidths.set(this.header.size() - 1, value.length());
        }
    }

    public int getRowWidth() {
        return this.column;
    }

    public int getTableHeight() {
        return this.height;
    }

    public int getTableWidth() {
        return this.width;
    }

    public void print(TablePrinter printer) {
        TableSerializer serializer = printer.getSerializer();
        ArrayList<List<String>> sortedRows = new ArrayList<List<String>>(this.rows);
        Comparator<List<String>> comparator = new Comparator<List<String>>(){

            @Override
            public int compare(List<String> row1, List<String> row2) {
                for (int i = 0; i < TableBuilder.this.sortKeys.size(); ++i) {
                    String cell1 = row1.get((Integer)TableBuilder.this.sortKeys.get(i));
                    String cell2 = row2.get((Integer)TableBuilder.this.sortKeys.get(i));
                    int rc = ((Comparator)TableBuilder.this.sortComparators.get(i)).compare(cell1, cell2);
                    if (rc == 0) continue;
                    return rc;
                }
                return 0;
            }
        };
        Collections.sort(sortedRows, comparator);
        serializer.startTable(this.height, this.width);
        for (int i = 0; i < this.width; ++i) {
            serializer.addColumn(this.columnWidths.get(i));
        }
        serializer.startHeader();
        for (LocalizableMessage localizableMessage : this.header) {
            serializer.addHeading(localizableMessage.toString());
        }
        serializer.endHeader();
        serializer.startContent();
        for (List list : sortedRows) {
            serializer.startRow();
            for (int i = 0; i < this.width; ++i) {
                if (i < list.size()) {
                    serializer.addCell((String)list.get(i));
                    continue;
                }
                serializer.addCell("");
            }
            serializer.endRow();
        }
        serializer.endContent();
        serializer.endTable();
    }

    public void startRow() {
        this.rows.add(new ArrayList());
        ++this.height;
        this.column = 0;
    }
}

