/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwt;

import java.util.Map;
import org.forgerock.json.jose.jwt.Algorithm;
import org.forgerock.json.jose.jwt.JWObject;
import org.forgerock.json.jose.jwt.JwtHeaderKey;
import org.forgerock.json.jose.jwt.JwtType;

public abstract class JwtHeader
extends JWObject {
    public JwtHeader() {
        this.put(JwtHeaderKey.TYP.value(), JwtType.JWT.toString());
    }

    public JwtHeader(Map<String, Object> headers) {
        this();
        this.setParameters(headers);
    }

    public void setType(JwtType jwtType) {
        this.put(JwtHeaderKey.TYP.value(), jwtType.toString());
    }

    public JwtType getType() {
        return JwtType.valueOf(this.get(JwtHeaderKey.TYP.value()).asString().toUpperCase());
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.put(JwtHeaderKey.ALG.value(), algorithm.toString());
    }

    public abstract Algorithm getAlgorithm();

    protected String getAlgorithmString() {
        return this.get(JwtHeaderKey.ALG.value()).asString();
    }

    public void setParameter(String key, Object value) {
        JwtHeaderKey headerKey = JwtHeaderKey.getHeaderKey(key.toUpperCase());
        switch (headerKey) {
            case TYP: {
                if (this.isValueOfType(value, JwtType.class)) {
                    this.setType((JwtType)((Object)value));
                    break;
                }
                this.checkValueIsOfType(value, String.class);
                this.setType(JwtType.jwtType((String)value));
                break;
            }
            case ALG: {
                if (this.isValueOfType(value, Algorithm.class)) {
                    this.setAlgorithm((Algorithm)value);
                    break;
                }
                this.checkValueIsOfType(value, String.class);
                this.put(JwtHeaderKey.ALG.value(), value);
                break;
            }
            default: {
                this.put(key, value);
            }
        }
    }

    public void setParameters(Map<String, Object> headers) {
        for (String key : headers.keySet()) {
            this.setParameter(key, headers.get(key));
        }
    }

    public Object getParameter(String key) {
        Object value;
        JwtHeaderKey headerKey = JwtHeaderKey.getHeaderKey(key.toUpperCase());
        switch (headerKey) {
            case TYP: {
                value = this.getType();
                break;
            }
            case ALG: {
                value = this.getAlgorithm();
                break;
            }
            default: {
                value = this.get(key).getObject();
            }
        }
        return value;
    }

    public <T> T getParameter(String key, Class<T> clazz) {
        return clazz.cast(this.getParameter(key));
    }

    public Map<String, Object> getParameters() {
        return this.getAll();
    }

    public String build() {
        return this.toString();
    }
}

