/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.builders;

import org.forgerock.json.jose.builders.EncryptedJwtBuilder;
import org.forgerock.json.jose.builders.JwtSecureHeaderBuilder;
import org.forgerock.json.jose.jwe.CompressionAlgorithm;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweHeader;
import org.forgerock.json.jose.jwt.JwtHeader;

public class JweHeaderBuilder<B extends EncryptedJwtBuilder>
extends JwtSecureHeaderBuilder<B, JweHeaderBuilder<B>> {
    public JweHeaderBuilder(B jwtBuilder) {
        super(jwtBuilder);
    }

    public JweHeaderBuilder<B> enc(EncryptionMethod enc) {
        this.header("enc", enc.toString());
        return this;
    }

    public JweHeaderBuilder<B> epk(String epk) {
        this.header("epk", epk);
        return this;
    }

    @Override
    public JweHeaderBuilder<B> zip(CompressionAlgorithm zip) {
        return (JweHeaderBuilder)super.zip(zip);
    }

    public JweHeaderBuilder<B> apu(String apu) {
        this.header("apu", apu);
        return this;
    }

    @Override
    protected JwtHeader build() {
        return new JweHeader(this.getHeaders());
    }
}

