/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.handlers.jdbc.BaseDatabaseStatementProvider;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEvent;
import org.forgerock.audit.handlers.jdbc.Parameter;
import org.forgerock.audit.handlers.jdbc.SqlStatementParser;
import org.forgerock.audit.handlers.jdbc.StringSqlQueryFilterVisitor;
import org.forgerock.audit.handlers.jdbc.StringSqlRenderer;
import org.forgerock.audit.handlers.jdbc.TableMapping;
import org.forgerock.audit.handlers.jdbc.TableMappingParametersPair;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.SortKey;
import org.forgerock.util.Utils;
import org.forgerock.util.query.QueryFilterVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenericDatabaseStatementProvider
extends BaseDatabaseStatementProvider {
    private static final Logger logger = LoggerFactory.getLogger(GenericDatabaseStatementProvider.class);
    private final StringSqlQueryFilterVisitor queryFilterVisitor = new StringSqlQueryFilterVisitor();

    GenericDatabaseStatementProvider() {
    }

    @Override
    public JdbcAuditEvent buildQueryEvent(TableMapping mapping, QueryRequest queryRequest, JsonValue eventTopicMetaData) throws AuditException {
        TableMappingParametersPair tableMappingParametersPair = new TableMappingParametersPair(mapping);
        String querySelectStatement = this.buildQuerySql(queryRequest, tableMappingParametersPair);
        logger.info("Built query select statement: {}", (Object)querySelectStatement);
        SqlStatementParser sqlStatementParser = new SqlStatementParser(querySelectStatement);
        LinkedList<Parameter> params = new LinkedList<Parameter>();
        for (String field : sqlStatementParser.getNamedParameters()) {
            JsonPointer fieldPointer = new JsonPointer(field);
            params.add(new Parameter(this.getParameterType(eventTopicMetaData, fieldPointer), tableMappingParametersPair.getParameters().get(field)));
        }
        return new JdbcAuditEvent(sqlStatementParser.getSqlStatement(), params);
    }

    private String buildQuerySql(QueryRequest queryRequest, TableMappingParametersPair tableMappingParametersPair) {
        TableMapping tableMapping = tableMappingParametersPair.getTableMapping();
        int offsetParam = queryRequest.getPagedResultsOffset();
        int pageSizeParam = queryRequest.getPageSize();
        if (pageSizeParam == 0) {
            pageSizeParam = Integer.MAX_VALUE;
        }
        String pageClause = "LIMIT " + pageSizeParam + " OFFSET " + offsetParam;
        List sortKeys = queryRequest.getSortKeys();
        if (sortKeys != null && sortKeys.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>();
            for (SortKey sortKey : sortKeys) {
                keys.add(tableMappingParametersPair.getColumnName(sortKey.getField()) + (sortKey.isAscendingOrder() ? " ASC" : " DESC"));
            }
            pageClause = "ORDER BY " + Utils.joinAsString((String)", ", keys) + pageClause;
        }
        return String.format("SELECT * FROM %s WHERE %s %s", tableMapping.getTable(), ((StringSqlRenderer)queryRequest.getQueryFilter().accept((QueryFilterVisitor)this.queryFilterVisitor, (Object)tableMappingParametersPair)).toSql(), pageClause);
    }
}

