/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.TableBuilder;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TextTablePrinter;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbsoluteInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefaultBehaviorProviderVisitor;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.RelativeInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.dsconfig.ArgumentExceptionFactory;
import org.forgerock.opendj.config.dsconfig.LDAPManagementContextFactory;
import org.forgerock.opendj.config.dsconfig.PropertyValuePrinter;
import org.forgerock.opendj.config.dsconfig.SubCommandHandler;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.LdapException;

final class GetPropSubCommandHandler
extends SubCommandHandler {
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final SubCommand subCommand;

    public static GetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(parser, path.child(r, "DUMMY"), r);
    }

    public static GetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(parser, path.child(r), r);
    }

    public static GetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, SetRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(parser, path.child(r), r);
    }

    public static GetPropSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, SingletonRelationDefinition<?, ?> r) throws ArgumentException {
        return new GetPropSubCommandHandler(parser, path.child(r), r);
    }

    private GetPropSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> r) throws ArgumentException {
        this.path = path;
        String name = "get-" + r.getName() + "-prop";
        LocalizableMessage message = DsconfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_GETPROP.get((Object)r.getChildDefinition().getUserFriendlyName());
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, message);
        this.namingArgs = this.createNamingArgs(this.subCommand, path, false);
        this.registerPropertyNameArgument(this.subCommand);
        this.registerRecordModeArgument(this.subCommand);
        this.registerUnitSizeArgument(this.subCommand);
        this.registerUnitTimeArgument(this.subCommand);
        this.addTags(path.getManagedObjectDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.path.getRelationDefinition();
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, LDAPManagementContextFactory factory) throws ArgumentException, ClientException {
        Collection<PropertyDefinition<?>> pdList;
        MenuResult<ManagedObject<?>> result;
        Set<String> propertyNames = this.getPropertyNames();
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(this.getSizeUnit(), this.getTimeUnit(), app.isScriptFriendly());
        List<String> names = this.getNamingArgValues(app, this.namingArgs);
        this.getCommandBuilder().clearArguments();
        this.setCommandBuilderUseful(false);
        this.updateCommandBuilderWithSubCommand();
        LocalizableMessage ufn = this.path.getRelationDefinition().getUserFriendlyName();
        ManagementContext context = factory.getManagementContext();
        try {
            result = this.getManagedObject(app, context, this.path, names);
        }
        catch (AuthorizationException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_AUTHZ.get((Object)ufn);
            throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
        }
        catch (DefinitionDecodingException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_DDE.get((Object)ufn, (Object)ufn, (Object)ufn);
            throw new ClientException(ReturnCode.OTHER, msg);
        }
        catch (ManagedObjectDecodingException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MODE.get((Object)ufn);
            throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
        }
        catch (ConcurrentModificationException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_CME.get((Object)ufn);
            throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_CHILD_MONFE.get((Object)ufn);
            throw new ClientException(ReturnCode.NO_SUCH_OBJECT, msg);
        }
        catch (LdapException e) {
            throw new ClientException(ReturnCode.OTHER, LocalizableMessage.raw((CharSequence)e.getLocalizedMessage(), (Object[])new Object[0]));
        }
        if (result.isQuit()) {
            return MenuResult.quit();
        }
        if (result.isCancel()) {
            return MenuResult.cancel();
        }
        ManagedObject child = (ManagedObject)result.getValue();
        ManagedObjectDefinition d = child.getManagedObjectDefinition();
        if (propertyNames.isEmpty()) {
            pdList = d.getAllPropertyDefinitions();
        } else {
            pdList = new LinkedList();
            for (String string : propertyNames) {
                try {
                    pdList.add(d.getPropertyDefinition(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ArgumentExceptionFactory.unknownProperty(d, string);
                }
            }
        }
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
        builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_VALUE.get());
        builder.addSortKey(0);
        for (PropertyDefinition<?> propertyDefinition : pdList) {
            if (GetPropSubCommandHandler.cannotDisplay(app, propertyDefinition, propertyNames)) continue;
            this.displayProperty(app, builder, child, propertyDefinition, valuePrinter);
            this.setCommandBuilderUseful(true);
        }
        PrintStream printStream = app.getOutputStream();
        if (app.isScriptFriendly()) {
            TablePrinter tablePrinter = this.createScriptFriendlyTablePrinter(printStream);
            builder.print(tablePrinter);
        } else {
            TextTablePrinter textTablePrinter = new TextTablePrinter((OutputStream)printStream);
            textTablePrinter.setColumnSeparator(":");
            textTablePrinter.setColumnWidth(1, 0);
            builder.print((TablePrinter)textTablePrinter);
        }
        return MenuResult.success((Object)0);
    }

    private <T> void displayProperty(final ConsoleApplication app, TableBuilder builder, ManagedObject<?> mo, PropertyDefinition<T> pd, PropertyValuePrinter valuePrinter) {
        Collection values = mo.getPropertyValues((PropertyDefinition)pd);
        if (values.isEmpty()) {
            DefaultBehaviorProviderVisitor visitor = new DefaultBehaviorProviderVisitor<T, LocalizableMessage, Void>(){

                @Override
                public LocalizableMessage visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public LocalizableMessage visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
                    if (app.isVerbose()) {
                        return d.getSynopsis();
                    }
                    return null;
                }

                @Override
                public LocalizableMessage visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public LocalizableMessage visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public LocalizableMessage visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
                    return null;
                }
            };
            builder.startRow();
            builder.appendCell((Object)pd.getName());
            LocalizableMessage content = (LocalizableMessage)pd.getDefaultBehaviorProvider().accept(visitor, null);
            if (content == null) {
                if (app.isScriptFriendly()) {
                    builder.appendCell();
                } else {
                    builder.appendCell((Object)"-");
                }
            } else {
                builder.appendCell((Object)content);
            }
        } else if (this.isRecordMode()) {
            for (Object value : values) {
                builder.startRow();
                builder.appendCell((Object)pd.getName());
                builder.appendCell((Object)valuePrinter.print(pd, value));
            }
        } else {
            builder.startRow();
            builder.appendCell((Object)pd.getName());
            if (app.isScriptFriendly()) {
                for (Object value : values) {
                    builder.appendCell((Object)valuePrinter.print(pd, value));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                boolean isFirst = true;
                for (Object value : values) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    sb.append((CharSequence)valuePrinter.print(pd, value));
                    isFirst = false;
                }
                builder.appendCell((Object)sb.toString());
            }
        }
    }
}

