/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbsoluteInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.Constraint;
import org.forgerock.opendj.config.DefaultBehaviorProviderVisitor;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyNotFoundException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.RelativeInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ClientConstraintHandler;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.RootCfgClient;

public abstract class Driver {
    protected Driver() {
    }

    public void close() {
    }

    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd, String name) throws ManagedObjectNotFoundException, OperationRejectedException, LdapException {
        this.validateRelationDefinition(parent, rd);
        ManagedObjectPath<C, S> child = parent.child(rd, name);
        return this.doDeleteManagedObject(child);
    }

    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, OptionalRelationDefinition<C, S> rd) throws ManagedObjectNotFoundException, OperationRejectedException, LdapException {
        this.validateRelationDefinition(parent, rd);
        ManagedObjectPath<C, S> child = parent.child(rd);
        return this.doDeleteManagedObject(child);
    }

    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, SetRelationDefinition<C, S> rd, String name) throws ManagedObjectNotFoundException, OperationRejectedException, LdapException {
        this.validateRelationDefinition(parent, rd);
        ManagedObjectPath<C, S> child = parent.child(rd, name);
        return this.doDeleteManagedObject(child);
    }

    public abstract <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getManagedObject(ManagedObjectPath<C, S> var1) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, LdapException;

    public abstract <C extends ConfigurationClient, S extends Configuration, P> SortedSet<P> getPropertyValues(ManagedObjectPath<C, S> var1, PropertyDefinition<P> var2) throws DefinitionDecodingException, ManagedObjectNotFoundException, LdapException;

    public abstract ManagedObject<RootCfgClient> getRootConfigurationManagedObject();

    public abstract <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> var1, InstantiableRelationDefinition<C, S> var2, AbstractManagedObjectDefinition<? extends C, ? extends S> var3) throws ManagedObjectNotFoundException, LdapException;

    public abstract <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> var1, SetRelationDefinition<C, S> var2, AbstractManagedObjectDefinition<? extends C, ? extends S> var3) throws ManagedObjectNotFoundException, LdapException;

    public abstract boolean managedObjectExists(ManagedObjectPath<?, ?> var1) throws ManagedObjectNotFoundException, LdapException;

    protected abstract <C extends ConfigurationClient, S extends Configuration> void deleteManagedObject(ManagedObjectPath<C, S> var1) throws OperationRejectedException, LdapException;

    protected final <P> Collection<P> findDefaultValues(ManagedObjectPath<?, ?> p, PropertyDefinition<P> pd, boolean isCreate) {
        DefaultValueFinder v = new DefaultValueFinder(p, isCreate);
        return v.find(p, pd);
    }

    protected abstract ManagementContext getManagementContext();

    protected final void validateRelationDefinition(ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> rd) {
        AbstractManagedObjectDefinition<?, ?> d = path.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + d.getName());
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> boolean doDeleteManagedObject(ManagedObjectPath<C, S> path) throws ManagedObjectNotFoundException, OperationRejectedException, LdapException {
        LinkedList<LocalizableMessage> messages;
        if (!this.managedObjectExists(path.parent())) {
            throw new ManagedObjectNotFoundException();
        }
        if (!this.managedObjectExists(path)) {
            return false;
        }
        AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
        if (!this.isAcceptable(path, d, messages = new LinkedList<LocalizableMessage>())) {
            throw new OperationRejectedException(OperationRejectedException.OperationType.DELETE, d.getUserFriendlyName(), messages);
        }
        this.deleteManagedObject(path);
        return true;
    }

    private <C extends ConfigurationClient, S extends Configuration> boolean isAcceptable(ManagedObjectPath<C, S> path, AbstractManagedObjectDefinition<?, ?> d, List<LocalizableMessage> messages) throws LdapException {
        for (Constraint constraint : d.getAllConstraints()) {
            for (ClientConstraintHandler handler : constraint.getClientConstraintHandlers()) {
                ManagementContext context;
                if (handler.isDeleteAcceptable(context = this.getManagementContext(), path, messages)) continue;
                return false;
            }
        }
        return true;
    }

    private final class DefaultValueFinder<T>
    implements DefaultBehaviorProviderVisitor<T, Collection<T>, Void> {
        private PropertyException exception;
        private final ManagedObjectPath<?, ?> firstPath;
        private final boolean isCreate;
        private ManagedObjectPath<?, ?> nextPath;
        private PropertyDefinition<T> nextProperty;

        private DefaultValueFinder(ManagedObjectPath<?, ?> p, boolean isCreate) {
            this.firstPath = p;
            this.isCreate = isCreate;
        }

        @Override
        public Collection<T> visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (PropertyException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        @Override
        public Collection<T> visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
            Collection<String> stringValues = d.getDefaultValues();
            ArrayList<T> values = new ArrayList<T>(stringValues.size());
            for (String stringValue : stringValues) {
                try {
                    values.add(this.nextProperty.decodeValue(stringValue));
                }
                catch (PropertyException e) {
                    this.exception = PropertyException.defaultBehaviorException(this.nextProperty, e);
                    break;
                }
            }
            return values;
        }

        @Override
        public Collection<T> visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(this.nextPath), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (PropertyException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        private Collection<T> find(ManagedObjectPath<?, ?> p, PropertyDefinition<T> pd) {
            this.nextPath = p;
            this.nextProperty = pd;
            Collection values = (Collection)this.nextProperty.getDefaultBehaviorProvider().accept(this, null);
            if (this.exception != null) {
                throw this.exception;
            }
            if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
                throw PropertyException.defaultBehaviorException(pd, PropertyException.propertyIsSingleValuedException(pd));
            }
            return values;
        }

        private Collection<T> getInheritedProperty(ManagedObjectPath<?, ?> target, AbstractManagedObjectDefinition<?, ?> definition, String propertyName) {
            AbstractManagedObjectDefinition<?, ?> actual = target.getManagedObjectDefinition();
            if (!definition.isParentOf(actual)) {
                throw PropertyException.defaultBehaviorException(this.nextProperty, new DefinitionDecodingException(actual, DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION));
            }
            PropertyDefinition<T> pd1 = this.nextProperty;
            try {
                PropertyDefinition pd2;
                try {
                    PropertyDefinition<?> pdTmp = definition.getPropertyDefinition(propertyName);
                    pd2 = (PropertyDefinition)pd1.getClass().cast(pdTmp);
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                if (this.isCreate && this.firstPath.equals(target)) {
                    Collection<T> tmp = this.find(target, pd2);
                    ArrayList<T> values = new ArrayList<T>(tmp.size());
                    for (T value : tmp) {
                        pd1.validateValue(value);
                        values.add(value);
                    }
                    return values;
                }
                return Driver.this.getPropertyValues(target, pd2);
            }
            catch (DefinitionDecodingException | ManagedObjectNotFoundException | PropertyException | PropertyNotFoundException | LdapException e) {
                throw PropertyException.defaultBehaviorException(pd1, e);
            }
        }
    }
}

