/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;
import org.forgerock.opendj.config.RelationDefinitionVisitor;
import org.forgerock.opendj.config.RelationOption;
import org.forgerock.util.Reject;

public abstract class RelationDefinition<C extends ConfigurationClient, S extends Configuration> {
    private final Common<C, S> common;

    protected RelationDefinition(Common<C, S> common) {
        this.common = common;
    }

    public abstract <R, P> R accept(RelationDefinitionVisitor<R, P> var1, P var2);

    public final AbstractManagedObjectDefinition<C, S> getChildDefinition() {
        return ((Common)this.common).cd;
    }

    public final LocalizableMessage getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public final LocalizableMessage getDescription(Locale locale) {
        try {
            String property = "relation." + ((Common)this.common).name + ".description";
            return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this.getParentDefinition(), property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final String getName() {
        return ((Common)this.common).name;
    }

    public final AbstractManagedObjectDefinition<?, ?> getParentDefinition() {
        return ((Common)this.common).pd;
    }

    public final LocalizableMessage getSynopsis() {
        return this.getSynopsis(Locale.getDefault());
    }

    public final LocalizableMessage getSynopsis(Locale locale) {
        String property = "relation." + ((Common)this.common).name + ".synopsis";
        return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this.getParentDefinition(), property, locale);
    }

    public final LocalizableMessage getUserFriendlyName() {
        return this.getUserFriendlyName(Locale.getDefault());
    }

    public final LocalizableMessage getUserFriendlyName(Locale locale) {
        String property = "relation." + ((Common)this.common).name + ".user-friendly-name";
        return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this.getParentDefinition(), property, locale);
    }

    public final boolean hasOption(RelationOption option) {
        return ((Common)this.common).options.contains((Object)option);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public abstract void toString(StringBuilder var1);

    protected void initialize() throws Exception {
    }

    protected static final class Common<C extends ConfigurationClient, S extends Configuration> {
        private final AbstractManagedObjectDefinition<C, S> cd;
        private final String name;
        private final Set<RelationOption> options;
        private final AbstractManagedObjectDefinition<?, ?> pd;

        private Common(AbstractManagedObjectDefinition<?, ?> pd, String name, AbstractManagedObjectDefinition<C, S> cd) {
            this.name = name;
            this.pd = pd;
            this.cd = cd;
            this.options = EnumSet.noneOf(RelationOption.class);
        }
    }

    protected static abstract class AbstractBuilder<C extends ConfigurationClient, S extends Configuration, D extends RelationDefinition<C, S>> {
        private final Common<C, S> common;

        protected AbstractBuilder(AbstractManagedObjectDefinition<?, ?> pd, String name, AbstractManagedObjectDefinition<C, S> cd) {
            this.common = new Common(pd, name, cd);
        }

        public final D getInstance() {
            return this.buildInstance(this.common);
        }

        public final void setOption(RelationOption option) {
            Reject.ifNull((Object)((Object)option));
            ((Common)this.common).options.add(option);
        }

        protected abstract D buildInstance(Common<C, S> var1);
    }
}

