/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DefaultManagedObject;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.RelationDefinitionVisitor;

public final class OptionalRelationDefinition<C extends ConfigurationClient, S extends Configuration>
extends RelationDefinition<C, S> {
    private final DefaultManagedObject<? extends C, ? extends S> defaultManagedObject;

    private OptionalRelationDefinition(RelationDefinition.Common<C, S> common, DefaultManagedObject<? extends C, ? extends S> defaultManagedObject) {
        super(common);
        this.defaultManagedObject = defaultManagedObject;
    }

    @Override
    public <R, P> R accept(RelationDefinitionVisitor<R, P> v, P p) {
        return v.visitOptional(this, p);
    }

    public DefaultManagedObject<? extends C, ? extends S> getDefaultManagedObject() {
        return this.defaultManagedObject;
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("name=");
        builder.append(this.getName());
        builder.append(" type=optional parent=");
        builder.append(this.getParentDefinition().getName());
        builder.append(" child=");
        builder.append(this.getChildDefinition().getName());
    }

    @Override
    protected void initialize() throws Exception {
        if (this.defaultManagedObject != null) {
            this.defaultManagedObject.initialize();
        }
    }

    public static final class Builder<C extends ConfigurationClient, S extends Configuration>
    extends RelationDefinition.AbstractBuilder<C, S, OptionalRelationDefinition<C, S>> {
        private DefaultManagedObject<? extends C, ? extends S> defaultManagedObject;

        public Builder(AbstractManagedObjectDefinition<?, ?> pd, String name, AbstractManagedObjectDefinition<C, S> cd) {
            super(pd, name, cd);
        }

        public void setDefaultManagedObject(DefaultManagedObject<? extends C, ? extends S> defaultManagedObject) {
            this.defaultManagedObject = defaultManagedObject;
        }

        @Override
        protected OptionalRelationDefinition<C, S> buildInstance(RelationDefinition.Common<C, S> common) {
            return new OptionalRelationDefinition(common, this.defaultManagedObject);
        }
    }
}

