/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationUnit;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.util.Reject;

public final class DurationPropertyDefinition
extends PropertyDefinition<Long> {
    private static final String UNLIMITED = "unlimited";
    private final DurationUnit baseUnit;
    private final DurationUnit maximumUnit;
    private final long lowerLimit;
    private final Long upperLimit;
    private final boolean allowUnlimited;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private DurationPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Long> defaultBehavior, DurationUnit baseUnit, DurationUnit maximumUnit, Long lowerLimit, Long upperLimit, boolean allowUnlimited) {
        super(d, Long.class, propertyName, options, adminAction, defaultBehavior);
        this.baseUnit = baseUnit;
        this.maximumUnit = maximumUnit;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.allowUnlimited = allowUnlimited;
    }

    public DurationUnit getBaseUnit() {
        return this.baseUnit;
    }

    public DurationUnit getMaximumUnit() {
        return this.maximumUnit;
    }

    public long getLowerLimit() {
        return this.lowerLimit;
    }

    public Long getUpperLimit() {
        return this.upperLimit;
    }

    public boolean isAllowUnlimited() {
        return this.allowUnlimited;
    }

    @Override
    public void validateValue(Long value) {
        Reject.ifNull((Object)value);
        long nvalue = this.baseUnit.toMilliSeconds(value.longValue());
        if (!this.allowUnlimited && nvalue < this.lowerLimit) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        if (nvalue >= 0L && nvalue < this.lowerLimit) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        if (this.upperLimit != null && nvalue > this.upperLimit) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public String encodeValue(Long value) {
        Reject.ifNull((Object)value);
        if (this.allowUnlimited && value < 0L) {
            return UNLIMITED;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(value);
        builder.append(' ');
        builder.append((Object)this.baseUnit);
        return builder.toString();
    }

    @Override
    public Long decodeValue(String value) {
        long ms;
        Reject.ifNull((Object)value);
        if (this.allowUnlimited && UNLIMITED.equalsIgnoreCase(value.trim())) {
            return -1L;
        }
        try {
            ms = DurationUnit.parseValue(value);
        }
        catch (NumberFormatException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        if (ms % this.baseUnit.getDuration() != 0L) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        Long i = (long)this.baseUnit.fromMilliSeconds(ms);
        try {
            this.validateValue(i);
            return i;
        }
        catch (PropertyException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitDuration(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, Long value, P p) {
        return v.visitDuration(this, value, p);
    }

    @Override
    public void toString(StringBuilder builder) {
        super.toString(builder);
        builder.append(" baseUnit=");
        builder.append((Object)this.baseUnit);
        if (this.maximumUnit != null) {
            builder.append(" maximumUnit=");
            builder.append((Object)this.maximumUnit);
        }
        builder.append(" lowerLimit=");
        builder.append(this.lowerLimit);
        builder.append("ms");
        if (this.upperLimit != null) {
            builder.append(" upperLimit=");
            builder.append(this.upperLimit);
            builder.append("ms");
        }
        builder.append(" allowUnlimited=");
        builder.append(this.allowUnlimited);
    }

    @Override
    public int compare(Long o1, Long o2) {
        return o1.compareTo(o2);
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<Long, DurationPropertyDefinition> {
        private DurationUnit baseUnit = DurationUnit.SECONDS;
        private DurationUnit maximumUnit;
        private long lowerLimit;
        private Long upperLimit;
        private boolean allowUnlimited;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setBaseUnit(String unit) {
            Reject.ifNull((Object)unit);
            this.setBaseUnit(DurationUnit.getUnit(unit));
        }

        public final void setBaseUnit(DurationUnit unit) {
            Reject.ifNull((Object)((Object)unit));
            if (this.maximumUnit != null && unit.getDuration() > this.maximumUnit.getDuration()) {
                throw new IllegalArgumentException("Base unit greater than maximum unit");
            }
            this.baseUnit = unit;
        }

        public final void setMaximumUnit(String unit) {
            this.setMaximumUnit(unit != null ? DurationUnit.getUnit(unit) : null);
        }

        public final void setMaximumUnit(DurationUnit unit) {
            if (unit != null && unit.getDuration() < this.baseUnit.getDuration()) {
                throw new IllegalArgumentException("Maximum unit smaller than base unit");
            }
            this.maximumUnit = unit;
        }

        public final void setLowerLimit(long lowerLimit) {
            if (lowerLimit < 0L) {
                throw new IllegalArgumentException("Negative lower limit");
            }
            if (this.upperLimit != null && lowerLimit > this.upperLimit) {
                throw new IllegalArgumentException("Lower limit greater than upper limit");
            }
            this.lowerLimit = lowerLimit;
        }

        public final void setLowerLimit(String lowerLimit) {
            this.setLowerLimit(DurationUnit.parseValue(lowerLimit, this.baseUnit));
        }

        public final void setUpperLimit(Long upperLimit) {
            if (upperLimit != null) {
                if (upperLimit < 0L) {
                    throw new IllegalArgumentException("Negative upper limit");
                }
                if (this.lowerLimit > upperLimit) {
                    throw new IllegalArgumentException("Lower limit greater than upper limit");
                }
                if (this.allowUnlimited) {
                    throw new IllegalArgumentException("Upper limit specified when unlimited durations are permitted");
                }
            }
            this.upperLimit = upperLimit;
        }

        public final void setUpperLimit(String upperLimit) {
            this.setUpperLimit(upperLimit != null ? Long.valueOf(DurationUnit.parseValue(upperLimit, this.baseUnit)) : null);
        }

        public final void setAllowUnlimited(boolean allowUnlimited) {
            if (allowUnlimited && this.upperLimit != null) {
                throw new IllegalArgumentException("Upper limit specified when unlimited durations are permitted");
            }
            this.allowUnlimited = allowUnlimited;
        }

        @Override
        protected DurationPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Long> defaultBehavior) {
            return new DurationPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.baseUnit, this.maximumUnit, this.lowerLimit, this.upperLimit, this.allowUnlimited);
        }
    }
}

