/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyProvider;

public final class DefaultManagedObject<C extends ConfigurationClient, S extends Configuration>
implements PropertyProvider {
    private final ManagedObjectDefinition<C, S> definition;
    private final Map<String, List<String>> propertyStringValues;

    private DefaultManagedObject(ManagedObjectDefinition<C, S> definition, Map<String, List<String>> propertyStringValues) {
        this.definition = definition;
        this.propertyStringValues = propertyStringValues;
    }

    public ManagedObjectDefinition<C, S> getManagedObjectDefinition() {
        return this.definition;
    }

    public <T> SortedSet<T> getPropertyValues(PropertyDefinition<T> pd) {
        this.definition.getPropertyDefinition(pd.getName());
        TreeSet<T> values = new TreeSet<T>(pd);
        List<String> stringValues = this.propertyStringValues.get(pd.getName());
        if (stringValues != null) {
            for (String stringValue : stringValues) {
                values.add(pd.decodeValue(stringValue));
            }
        }
        return values;
    }

    void initialize() throws Exception {
        for (String name : this.propertyStringValues.keySet()) {
            this.definition.getPropertyDefinition(name);
        }
    }

    public static final class Builder<C extends ConfigurationClient, S extends Configuration> {
        private final ManagedObjectDefinition<C, S> definition;
        private final Map<String, List<String>> propertyStringValues = new HashMap<String, List<String>>();

        public Builder(ManagedObjectDefinition<C, S> definition) {
            this.definition = definition;
        }

        public DefaultManagedObject<C, S> getInstance() {
            return new DefaultManagedObject(this.definition, this.propertyStringValues);
        }

        public void setPropertyValues(String name, String ... values) {
            if (values == null || values.length == 0) {
                throw new IllegalArgumentException("null or empty values specified for property " + name);
            }
            this.propertyStringValues.put(name, Arrays.asList(values));
        }
    }
}

