/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import java.util.regex.Pattern;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.util.Reject;

public final class ACIPropertyDefinition
extends PropertyDefinition<String> {
    private static final Pattern ACI_REGEX = Pattern.compile("^\\s*(\\(\\s*(\\w+)\\s*(!?=)\\s*\"([^\"]+)\"\\s*\\)\\s*)*\\s*\\(\\s*(?i)version(?-i)\\s*(\\d\\.\\d)\\s*;\\s*(?i)acl(?-i)\\s*\"([^\"]*)\"\\s*;\\s*\\s*(\\w+)\\s*\\(([^()]+)\\)\\s*(.+?\"[)]*)\\s*;\\s*\\s*\\)\\s*$");

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private ACIPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior) {
        super(d, String.class, propertyName, options, adminAction, defaultBehavior);
    }

    @Override
    public void validateValue(String value) {
        Reject.ifNull((Object)value);
    }

    @Override
    public String decodeValue(String value) {
        Reject.ifNull((Object)value);
        if (ACI_REGEX.matcher(value).matches()) {
            return value;
        }
        throw PropertyException.illegalPropertyValueException(this, value);
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitACI(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, String value, P p) {
        return v.visitACI(this, value, p);
    }

    @Override
    public int compare(String o1, String o2) {
        return o1.compareTo(o2);
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<String, ACIPropertyDefinition> {
        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        @Override
        protected ACIPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior) {
            return new ACIPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior);
        }
    }
}

