/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n;

import java.util.Locale;
import java.util.ResourceBundle;
import org.forgerock.i18n.LocalizableMessage;

public final class LocalizableMessageDescriptor {
    static final Raw RAW0 = new Raw("%s");

    private LocalizableMessageDescriptor() {
    }

    static final class Raw
    extends AbstractLocalizableMessageDescriptor {
        private final String formatString;
        private final boolean requiresFormatter;

        Raw(CharSequence formatString) {
            super(Void.class, null, null, -1);
            this.formatString = formatString.toString();
            this.requiresFormatter = this.formatString.matches(".*%.*");
        }

        LocalizableMessage get(Object ... args) {
            return new LocalizableMessage(this, args);
        }

        @Override
        String getFormatString(Locale locale) {
            return this.formatString;
        }

        @Override
        boolean requiresFormatter() {
            return this.requiresFormatter;
        }
    }

    static abstract class AbstractLocalizableMessageDescriptor {
        private final String key;
        private final Class<?> sourceClass;
        private final String resourceName;
        private final int ordinal;
        private CachedFormatString cachedFormatString = null;

        private AbstractLocalizableMessageDescriptor(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            this.sourceClass = sourceClass;
            this.resourceName = resourceName;
            this.key = key;
            this.ordinal = ordinal;
        }

        final String getFormatString() {
            return this.getFormatString(Locale.getDefault());
        }

        String getFormatString(Locale locale) {
            if (locale == null) {
                throw new NullPointerException("locale was null");
            }
            CachedFormatString cfs = this.cachedFormatString;
            if (cfs != null && cfs.locale == locale) {
                return cfs.formatString;
            }
            ResourceBundle bundle = this.getBundle(locale);
            String formatString = bundle.getString(this.key);
            this.cachedFormatString = new CachedFormatString(locale, formatString);
            return formatString;
        }

        public final int ordinal() {
            return this.ordinal;
        }

        abstract boolean requiresFormatter();

        public final String resourceName() {
            return this.resourceName;
        }

        private ResourceBundle getBundle(Locale locale) {
            return ResourceBundle.getBundle(this.resourceName, locale == null ? Locale.getDefault() : locale, this.sourceClass.getClassLoader());
        }

        private static final class CachedFormatString {
            private final Locale locale;
            private final String formatString;

            private CachedFormatString(Locale locale, String formatString) {
                this.locale = locale;
                this.formatString = formatString;
            }
        }
    }

    public static final class ArgN
    extends AbstractLocalizableMessageDescriptor {
        public ArgN(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(Object ... args) {
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg9<T1, T2, T3, T4, T5, T6, T7, T8, T9>
    extends AbstractLocalizableMessageDescriptor {
        public Arg9(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8, T9 a9) {
            Object[] args = new Object[]{a1, a2, a3, a4, a5, a6, a7, a8, a9};
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg8<T1, T2, T3, T4, T5, T6, T7, T8>
    extends AbstractLocalizableMessageDescriptor {
        public Arg8(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7, T8 a8) {
            Object[] args = new Object[]{a1, a2, a3, a4, a5, a6, a7, a8};
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg7<T1, T2, T3, T4, T5, T6, T7>
    extends AbstractLocalizableMessageDescriptor {
        public Arg7(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6, T7 a7) {
            Object[] args = new Object[]{a1, a2, a3, a4, a5, a6, a7};
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg6<T1, T2, T3, T4, T5, T6>
    extends AbstractLocalizableMessageDescriptor {
        public Arg6(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5, T6 a6) {
            Object[] args = new Object[]{a1, a2, a3, a4, a5, a6};
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg5<T1, T2, T3, T4, T5>
    extends AbstractLocalizableMessageDescriptor {
        public Arg5(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(T1 a1, T2 a2, T3 a3, T4 a4, T5 a5) {
            Object[] args = new Object[]{a1, a2, a3, a4, a5};
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg4<T1, T2, T3, T4>
    extends AbstractLocalizableMessageDescriptor {
        public Arg4(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(T1 a1, T2 a2, T3 a3, T4 a4) {
            Object[] args = new Object[]{a1, a2, a3, a4};
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg3<T1, T2, T3>
    extends AbstractLocalizableMessageDescriptor {
        public Arg3(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(T1 a1, T2 a2, T3 a3) {
            Object[] args = new Object[]{a1, a2, a3};
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg2<T1, T2>
    extends AbstractLocalizableMessageDescriptor {
        public Arg2(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(T1 a1, T2 a2) {
            Object[] args = new Object[]{a1, a2};
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg1<T1>
    extends AbstractLocalizableMessageDescriptor {
        public Arg1(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
        }

        public LocalizableMessage get(T1 a1) {
            Object[] args = new Object[]{a1};
            return new LocalizableMessage(this, args);
        }

        @Override
        boolean requiresFormatter() {
            return true;
        }
    }

    public static final class Arg0
    extends AbstractLocalizableMessageDescriptor {
        private final LocalizableMessage message;
        private final boolean requiresFormat;

        public Arg0(Class<?> sourceClass, String resourceName, String key, int ordinal) {
            super(sourceClass, resourceName, key, ordinal);
            Object[] args = new Object[]{};
            this.message = new LocalizableMessage(this, args);
            this.requiresFormat = this.containsArgumentLiterals(this.getFormatString());
        }

        public LocalizableMessage get() {
            return this.message;
        }

        @Override
        boolean requiresFormatter() {
            return this.requiresFormat;
        }

        private boolean containsArgumentLiterals(String s) {
            return s.contains("%%") || s.contains("%n");
        }
    }
}

