/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.forgerock.util.MapDecorator;

public class MultiValueMap<K, V>
extends MapDecorator<K, List<V>> {
    public MultiValueMap(Map<K, List<V>> map) {
        super(map);
    }

    public void add(K key, V value) {
        ArrayList<V> list = (ArrayList<V>)this.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.put(key, list);
        }
        list.add(value);
    }

    public void addAll(K key, Collection<? extends V> values) {
        ArrayList<? extends V> list = (ArrayList<? extends V>)this.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            this.put(key, list);
        }
        list.addAll(values);
    }

    public void addAll(MultiValueMap<K, V> map) {
        for (Object key : map.keySet()) {
            this.addAll(key, (Collection)map.get(key));
        }
    }

    public void addAll(Map<? extends K, Collection<? extends V>> map) {
        for (K key : map.keySet()) {
            this.addAll(key, map.get(key));
        }
    }

    public V getFirst(K key) {
        List list = (List)this.get(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (V)list.get(0);
    }

    public void putSingle(K key, V value) {
        this.remove(key);
        this.add(key, value);
    }
}

