/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import java.util.List;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.Filter;
import org.forgerock.http.header.AcceptApiVersionHeader;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.routing.DefaultVersionBehaviour;
import org.forgerock.http.routing.ResourceApiVersionBehaviourManager;
import org.forgerock.http.routing.ResourceApiVersionRouteMatcher;
import org.forgerock.http.routing.ResourceApiVersionRoutingFilter;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.UriRouteMatcher;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.routing.Version;
import org.forgerock.http.util.Paths;
import org.forgerock.services.context.Context;
import org.forgerock.services.routing.RouteMatch;
import org.forgerock.services.routing.RouteMatcher;

public final class RouteMatchers {
    private RouteMatchers() {
    }

    public static RouteMatcher<List<String>> uriMatcher(RoutingMode mode, String template) {
        return new UriRouteMatcher(mode, template);
    }

    public static RouteMatcher<Request> requestUriMatcher(RoutingMode mode, String template) {
        RouteMatcher<List<String>> delegate = RouteMatchers.uriMatcher(mode, template);
        return new RequestUriRouteMatcher(delegate);
    }

    public static ResourceApiVersionBehaviourManager newResourceApiVersionBehaviourManager() {
        return new ResourceApiVersionBehaviourManagerImpl();
    }

    public static Filter resourceApiVersionContextFilter(ResourceApiVersionBehaviourManager behaviourManager) {
        return new ResourceApiVersionRoutingFilter(behaviourManager);
    }

    public static RouteMatcher<Version> resourceApiVersionMatcher(Version version) {
        return new ResourceApiVersionRouteMatcher(version);
    }

    public static RouteMatcher<Request> requestResourceApiVersionMatcher(Version version) {
        return new RequestApiVersionRouteMatcher(RouteMatchers.resourceApiVersionMatcher(version));
    }

    static List<String> getRemainingRequestUri(Context context, Request request) {
        List<String> path = request.getUri().getPathElements();
        if (context.containsContext(UriRouterContext.class)) {
            List<String> matchedUri = Paths.getPathElements(context.asContext(UriRouterContext.class).getBaseUri());
            path = path.subList(matchedUri.size(), path.size());
        }
        return path;
    }

    private static final class RequestApiVersionRouteMatcher
    extends RouteMatcher<Request> {
        private final RouteMatcher<Version> delegate;

        private RequestApiVersionRouteMatcher(RouteMatcher<Version> delegate) {
            this.delegate = delegate;
        }

        @Override
        public RouteMatch evaluate(Context context, Request request) {
            AcceptApiVersionHeader apiVersionHeader;
            try {
                apiVersionHeader = AcceptApiVersionHeader.valueOf(request);
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
            return this.delegate.evaluate(context, apiVersionHeader.getResourceVersion());
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String idFragment() {
            return this.delegate.idFragment();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequestApiVersionRouteMatcher)) {
                return false;
            }
            RequestApiVersionRouteMatcher that = (RequestApiVersionRouteMatcher)o;
            return this.delegate.equals(that.delegate);
        }

        @Override
        public <T> T transformApi(T descriptor, ApiProducer<T> producer) {
            return this.delegate.transformApi(descriptor, producer);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    private static final class ResourceApiVersionBehaviourManagerImpl
    implements ResourceApiVersionBehaviourManager {
        private boolean warningEnabled = true;
        private DefaultVersionBehaviour defaultVersionBehaviour = DefaultVersionBehaviour.LATEST;

        private ResourceApiVersionBehaviourManagerImpl() {
        }

        @Override
        public void setWarningEnabled(boolean warningEnabled) {
            this.warningEnabled = warningEnabled;
        }

        @Override
        public boolean isWarningEnabled() {
            return this.warningEnabled;
        }

        @Override
        public void setDefaultVersionBehaviour(DefaultVersionBehaviour behaviour) {
            this.defaultVersionBehaviour = behaviour;
        }

        @Override
        public DefaultVersionBehaviour getDefaultVersionBehaviour() {
            return this.defaultVersionBehaviour;
        }
    }

    private static final class RequestUriRouteMatcher
    extends RouteMatcher<Request> {
        private final RouteMatcher<List<String>> delegate;

        private RequestUriRouteMatcher(RouteMatcher<List<String>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public RouteMatch evaluate(Context context, Request request) {
            return this.delegate.evaluate(context, RouteMatchers.getRemainingRequestUri(context, request));
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String idFragment() {
            return this.delegate.idFragment();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequestUriRouteMatcher)) {
                return false;
            }
            RequestUriRouteMatcher that = (RequestUriRouteMatcher)o;
            return this.delegate.equals(that.delegate);
        }

        @Override
        public <T> T transformApi(T descriptor, ApiProducer<T> producer) {
            return this.delegate.transformApi(descriptor, producer);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

