/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.forgerock.http.MutableUri;
import org.forgerock.http.protocol.Form;
import org.forgerock.http.protocol.MessageImpl;
import org.forgerock.http.protocol.RequestCookies;

public final class Request
extends MessageImpl<Request> {
    private final RequestCookies cookies = new RequestCookies(this);
    private String method;
    private MutableUri uri;

    public Request() {
    }

    public Request(Request request) throws IOException {
        super(request);
        this.method = request.method;
        this.uri = new MutableUri(request.uri.asURI());
    }

    public RequestCookies getCookies() {
        return this.cookies;
    }

    public Form getForm() {
        Form form = new Form();
        form.fromRequestQuery(this);
        try {
            form.fromRequestEntity(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return form;
    }

    public String getMethod() {
        return this.method;
    }

    public MutableUri getUri() {
        return this.uri;
    }

    @Override
    public Request setEntity(Object o) {
        this.setEntity0(o);
        return this;
    }

    public Request setMethod(String method) {
        this.method = method;
        return this;
    }

    private Request setUri(MutableUri uri) {
        this.uri = uri;
        return this;
    }

    public Request setUri(String uri) throws URISyntaxException {
        return this.setUri(new MutableUri(uri));
    }

    public Request setUri(URI uri) {
        return this.setUri(new MutableUri(uri));
    }

    @Override
    public Request setVersion(String version) {
        this.setVersion0(version);
        return this;
    }
}

