/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.forgerock.http.decoder.Decoder;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;

public class ContentEncodingHeader
extends Header {
    public static final String NAME = "Content-Encoding";
    private final List<String> codings;

    public ContentEncodingHeader() {
        this(new ArrayList<String>(1));
    }

    public ContentEncodingHeader(List<String> codings) {
        this.codings = codings;
    }

    public static ContentEncodingHeader valueOf(Message message) {
        return new ContentEncodingHeader(HeaderUtil.parseMultiValuedHeader(message, NAME));
    }

    public static ContentEncodingHeader valueOf(String string) {
        return new ContentEncodingHeader(HeaderUtil.parseMultiValuedHeader(string));
    }

    public InputStream decode(InputStream in) throws IOException {
        ListIterator<String> i = this.codings.listIterator(this.codings.size());
        while (i.hasPrevious()) {
            String name = i.previous();
            Decoder decoder = Decoder.SERVICES.get(name);
            if (decoder == null) {
                throw new UnsupportedEncodingException(name);
            }
            in = decoder.decode(in);
        }
        return in;
    }

    public List<String> getCodings() {
        return this.codings;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getValues() {
        String joined = HeaderUtil.join(this.codings, ',');
        return joined == null ? Collections.emptyList() : Collections.singletonList(joined);
    }

    static class Factory
    extends HeaderFactory<ContentEncodingHeader> {
        Factory() {
        }

        @Override
        public ContentEncodingHeader parse(String value) {
            return ContentEncodingHeader.valueOf(value);
        }

        @Override
        public ContentEncodingHeader parse(List<String> values) {
            return ContentEncodingHeader.valueOf(HeaderUtil.join(values, ','));
        }
    }
}

