/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.handler;

import io.swagger.models.Swagger;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.handler.DescribableHandler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

public final class Handlers {
    private Handlers() {
    }

    public static DescribableHandler filtered(final Handler handler, final Filter filter) {
        final DescribableHandler describable = Handlers.asDescribableHandler(handler);
        return new DescribableHandler(){

            @Override
            public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
                return filter.filter(context, request, handler);
            }

            @Override
            public Swagger api(ApiProducer<Swagger> producer) {
                return describable.api(producer);
            }

            @Override
            public Swagger handleApiRequest(Context context, Request request) {
                return (Swagger)describable.handleApiRequest(context, request);
            }

            @Override
            public void addDescriptorListener(Describable.Listener listener) {
                describable.addDescriptorListener(listener);
            }

            @Override
            public void removeDescriptorListener(Describable.Listener listener) {
                describable.removeDescriptorListener(listener);
            }
        };
    }

    public static DescribableHandler chainOf(Handler handler, Filter ... filters) {
        return Handlers.chainOf(handler, Arrays.asList(filters));
    }

    public static DescribableHandler chainOf(Handler handler, List<Filter> filters) {
        DescribableHandler result = Handlers.asDescribableHandler(handler);
        if (filters != null) {
            ListIterator<Filter> i = filters.listIterator(filters.size());
            while (i.hasPrevious()) {
                result = Handlers.filtered(result, i.previous());
            }
        }
        return result;
    }

    public static DescribableHandler asDescribableHandler(Handler handler) {
        if (handler instanceof DescribableHandler) {
            return (DescribableHandler)handler;
        }
        if (handler instanceof Describable) {
            return new HandlerDescribableAsDescribableHandler(handler, (Describable)((Object)handler));
        }
        return new UndescribedAsDescribableHandler(handler);
    }

    public static Handler internalServerErrorHandler(final Exception cause) {
        return new Handler(){

            @Override
            public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
                return Response.newResponsePromise(Responses.newInternalServerError(cause));
            }
        };
    }

    private static class UndescribedAsDescribableHandler
    implements DescribableHandler {
        private final Handler handler;

        public UndescribedAsDescribableHandler(Handler handler) {
            this.handler = handler;
        }

        @Override
        public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
            return this.handler.handle(context, request);
        }

        @Override
        public Swagger api(ApiProducer<Swagger> producer) {
            return null;
        }

        @Override
        public Swagger handleApiRequest(Context context, Request request) {
            return null;
        }

        @Override
        public void addDescriptorListener(Describable.Listener listener) {
        }

        @Override
        public void removeDescriptorListener(Describable.Listener listener) {
        }
    }

    private static class HandlerDescribableAsDescribableHandler
    implements DescribableHandler {
        private final Handler handler;
        private final Describable<Swagger, Request> describable;

        public HandlerDescribableAsDescribableHandler(Handler handler, Describable<Swagger, Request> describable) {
            this.handler = handler;
            this.describable = describable;
        }

        @Override
        public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
            return this.handler.handle(context, request);
        }

        @Override
        public Swagger api(ApiProducer<Swagger> producer) {
            return this.describable.api(producer);
        }

        @Override
        public Swagger handleApiRequest(Context context, Request request) {
            return this.describable.handleApiRequest(context, request);
        }

        @Override
        public void addDescriptorListener(Describable.Listener listener) {
            this.describable.addDescriptorListener(listener);
        }

        @Override
        public void removeDescriptorListener(Describable.Listener listener) {
            this.describable.removeDescriptorListener(listener);
        }
    }
}

