/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.forgerock.audit.events.AuditEventHelper;
import org.forgerock.audit.util.ElasticsearchUtil;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElasticsearchQueryFilterVisitor
implements QueryFilterVisitor<JsonValue, Void, JsonPointer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchQueryFilterVisitor.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    ElasticsearchQueryFilterVisitor() {
    }

    public JsonValue visitBooleanLiteralFilter(Void aVoid, boolean value) {
        if (!value) {
            throw new UnsupportedOperationException("Boolean literal filter (false) not supported on this endpoint");
        }
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"match_all", (Object)JsonValue.object((Map.Entry[])new Map.Entry[0]))}));
    }

    public JsonValue visitContainsFilter(Void aVoid, JsonPointer field, Object valueAssertion) {
        try {
            return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"wildcard", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)AuditEventHelper.jsonPointerToDotNotation((String)ElasticsearchUtil.normalizeJsonPointer((JsonPointer)field).toString()), (Object)("*" + MAPPER.writeValueAsString(valueAssertion) + "*"))}))}));
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));
        }
    }

    public JsonValue visitEqualsFilter(Void aVoid, JsonPointer field, Object valueAssertion) {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"term", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)AuditEventHelper.jsonPointerToDotNotation((String)ElasticsearchUtil.normalizeJsonPointer((JsonPointer)field).toString()), (Object)valueAssertion)}))}));
    }

    public JsonValue visitExtendedMatchFilter(Void aVoid, JsonPointer field, String operator, Object valueAssertion) {
        throw new UnsupportedOperationException("Extended match filter not supported on this endpoint");
    }

    public JsonValue visitGreaterThanFilter(Void aVoid, JsonPointer field, Object valueAssertion) {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"range", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)AuditEventHelper.jsonPointerToDotNotation((String)ElasticsearchUtil.normalizeJsonPointer((JsonPointer)field).toString()), (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"gt", (Object)valueAssertion)}))}))}));
    }

    public JsonValue visitGreaterThanOrEqualToFilter(Void aVoid, JsonPointer field, Object valueAssertion) {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"range", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)AuditEventHelper.jsonPointerToDotNotation((String)ElasticsearchUtil.normalizeJsonPointer((JsonPointer)field).toString()), (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"gte", (Object)valueAssertion)}))}))}));
    }

    public JsonValue visitLessThanFilter(Void aVoid, JsonPointer field, Object valueAssertion) {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"range", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)AuditEventHelper.jsonPointerToDotNotation((String)ElasticsearchUtil.normalizeJsonPointer((JsonPointer)field).toString()), (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"lt", (Object)valueAssertion)}))}))}));
    }

    public JsonValue visitLessThanOrEqualToFilter(Void aVoid, JsonPointer field, Object valueAssertion) {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"range", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)AuditEventHelper.jsonPointerToDotNotation((String)ElasticsearchUtil.normalizeJsonPointer((JsonPointer)field).toString()), (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"lte", (Object)valueAssertion)}))}))}));
    }

    public JsonValue visitNotFilter(Void aVoid, QueryFilter<JsonPointer> subFilter) {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"bool", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"must_not", (Object)((JsonValue)subFilter.accept((QueryFilterVisitor)this, (Object)aVoid)).getObject())}))}));
    }

    public JsonValue visitOrFilter(Void aVoid, List<QueryFilter<JsonPointer>> subFilters) {
        ArrayList<Map> filterResults = new ArrayList<Map>();
        for (QueryFilter<JsonPointer> filter : subFilters) {
            filterResults.add(((JsonValue)filter.accept((QueryFilterVisitor)this, (Object)aVoid)).asMap());
        }
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"bool", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"should", filterResults)}))}));
    }

    public JsonValue visitAndFilter(Void aVoid, List<QueryFilter<JsonPointer>> subFilters) {
        ArrayList<Map> filterResults = new ArrayList<Map>();
        for (QueryFilter<JsonPointer> filter : subFilters) {
            filterResults.add(((JsonValue)filter.accept((QueryFilterVisitor)this, (Object)aVoid)).asMap());
        }
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"bool", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"must", filterResults)}))}));
    }

    public JsonValue visitPresentFilter(Void aVoid, JsonPointer field) {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"exists", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"field", (Object)AuditEventHelper.jsonPointerToDotNotation((String)ElasticsearchUtil.normalizeJsonPointer((JsonPointer)field).toString()))}))}));
    }

    public JsonValue visitStartsWithFilter(Void aVoid, JsonPointer field, Object valueAssertion) {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"prefix", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)AuditEventHelper.jsonPointerToDotNotation((String)ElasticsearchUtil.normalizeJsonPointer((JsonPointer)field).toString()), (Object)valueAssertion)}))}));
    }
}

