/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.security.keystore;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.forgerock.security.keystore.KeystoreManagerException;

public class KeyStoreManager {
    private final KeyStore keyStore;

    public KeyStoreManager(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public Certificate getCertificate(String certAlias) {
        if (certAlias == null || certAlias.length() == 0) {
            return null;
        }
        try {
            return this.keyStore.getCertificate(certAlias);
        }
        catch (KeyStoreException e) {
            throw new KeystoreManagerException("Unable to get certificate: " + certAlias, e);
        }
    }

    public X509Certificate getX509Certificate(String certAlias) {
        Certificate certificate = this.getCertificate(certAlias);
        if (certificate instanceof X509Certificate) {
            return (X509Certificate)certificate;
        }
        throw new KeystoreManagerException("Certificate not a X509 Certificate for alias: " + certAlias);
    }

    public PublicKey getPublicKey(String keyAlias) {
        if (keyAlias == null || keyAlias.isEmpty()) {
            return null;
        }
        X509Certificate cert = this.getX509Certificate(keyAlias);
        if (cert == null) {
            throw new KeystoreManagerException("Unable to retrieve certificate for alias: " + keyAlias);
        }
        return cert.getPublicKey();
    }

    public PrivateKey getPrivateKey(String keyAlias, String privateKeyPassword) {
        if (keyAlias == null || keyAlias.length() == 0) {
            return null;
        }
        try {
            return (PrivateKey)this.keyStore.getKey(keyAlias, privateKeyPassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new KeystoreManagerException("unable to get private key:" + keyAlias, e);
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }
}

