/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SyntaxImpl;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.schema.JsonSchema;

final class JsonSyntaxImpl
implements SyntaxImpl {
    JsonSyntaxImpl() {
    }

    public String getName() {
        return "Json";
    }

    public String getApproximateMatchingRule() {
        return null;
    }

    public String getEqualityMatchingRule() {
        return "1.3.6.1.4.1.36733.2.1.4.1";
    }

    public String getOrderingMatchingRule() {
        return null;
    }

    public String getSubstringMatchingRule() {
        return null;
    }

    public boolean isBEREncodingRequired() {
        return false;
    }

    public boolean isHumanReadable() {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        JsonSchema.ValidationPolicy validationPolicy = (JsonSchema.ValidationPolicy)((Object)schema.getOption(JsonSchema.VALIDATION_POLICY));
        if (validationPolicy == JsonSchema.ValidationPolicy.DISABLED) {
            return true;
        }
        try (InputStream inputStream = value.asReader().asInputStream();){
            boolean bl;
            block28: {
                JsonParser parser;
                block26: {
                    boolean bl2;
                    block27: {
                        JsonToken jsonToken;
                        block24: {
                            boolean bl3;
                            block25: {
                                parser = validationPolicy.getJsonFactory().createParser(inputStream);
                                jsonToken = parser.nextToken();
                                if (jsonToken != null) break block24;
                                invalidReason.append(Rest2ldapMessages.ERR_JSON_EMPTY_CONTENT.get());
                                bl3 = false;
                                if (parser == null) break block25;
                                parser.close();
                            }
                            return bl3;
                        }
                        try {
                            int depth = 0;
                            do {
                                switch (jsonToken) {
                                    case START_OBJECT: 
                                    case START_ARRAY: {
                                        ++depth;
                                        break;
                                    }
                                    case END_OBJECT: 
                                    case END_ARRAY: {
                                        --depth;
                                        break;
                                    }
                                }
                                jsonToken = parser.nextToken();
                            } while (depth > 0);
                            if (jsonToken == null) break block26;
                            invalidReason.append(Rest2ldapMessages.ERR_JSON_TRAILING_CONTENT.get());
                            bl2 = false;
                            if (parser == null) break block27;
                        }
                        catch (Throwable throwable) {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        parser.close();
                    }
                    return bl2;
                }
                bl = true;
                if (parser == null) break block28;
                parser.close();
            }
            return bl;
        }
        catch (IOException e) {
            invalidReason.append(JsonSchema.jsonParsingException(e));
            return false;
        }
    }
}

