/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.SimpleBindStrategy;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

final class SearchThenBindStrategy
implements AuthenticationStrategy {
    private final ConnectionFactory searchConnectionFactory;
    private final ConnectionFactory bindConnectionFactory;
    private final DN baseDN;
    private final SearchScope searchScope;
    private final String filterTemplate;

    public SearchThenBindStrategy(ConnectionFactory searchConnectionFactory, ConnectionFactory bindConnectionFactory, DN baseDN, SearchScope searchScope, String filterTemplate) {
        this.searchConnectionFactory = (ConnectionFactory)Reject.checkNotNull((Object)searchConnectionFactory, (String)"searchConnectionFactory cannot be null");
        this.bindConnectionFactory = (ConnectionFactory)Reject.checkNotNull((Object)bindConnectionFactory, (String)"bindConnectionFactory cannot be null");
        this.baseDN = (DN)Reject.checkNotNull((Object)baseDN, (String)"baseDN cannot be null");
        this.searchScope = (SearchScope)Reject.checkNotNull((Object)searchScope, (String)"searchScope cannot be null");
        this.filterTemplate = (String)Reject.checkNotNull((Object)filterTemplate, (String)"filterTemplate cannot be null");
    }

    @Override
    public Promise<SecurityContext, LdapException> authenticate(final String username, final String password, final Context parentContext) {
        final AtomicReference searchConnectionHolder = new AtomicReference();
        return this.searchConnectionFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, SearchResultEntry, LdapException>(){

            public Promise<SearchResultEntry, LdapException> apply(Connection connection) throws LdapException {
                searchConnectionHolder.set(connection);
                return connection.searchSingleEntryAsync(Requests.newSearchRequest((DN)SearchThenBindStrategy.this.baseDN, (SearchScope)SearchThenBindStrategy.this.searchScope, (Filter)Filter.format((String)SearchThenBindStrategy.this.filterTemplate, (Object[])new Object[]{username}), (String[])new String[]{"1.1"}));
            }
        }).thenFinally(Utils.close(searchConnectionHolder)).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, SecurityContext, LdapException>(){

            public Promise<SecurityContext, LdapException> apply(SearchResultEntry searchResult) throws LdapException {
                AtomicReference<Connection> bindConnectionHolder = new AtomicReference<Connection>();
                return SearchThenBindStrategy.this.bindConnectionFactory.getConnectionAsync().thenAsync(SimpleBindStrategy.doSimpleBind(bindConnectionHolder, parentContext, username, searchResult.getName(), password)).thenFinally(Utils.close(bindConnectionHolder));
            }
        });
    }
}

