/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.opendj.rest2ldap.authz.ConditionalFilters;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

final class AuthorizationFilter
implements Filter {
    private static final Filter FORBIDDEN = new Filter(){

        public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
            return Response.newResponsePromise((Response)new Response(Status.FORBIDDEN));
        }
    };
    private final Iterable<? extends ConditionalFilters.ConditionalFilter> filters;

    AuthorizationFilter(Iterable<? extends ConditionalFilters.ConditionalFilter> filters) {
        this.filters = (Iterable)Reject.checkNotNull(filters, (String)"filters cannot be null");
    }

    public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
        Filter lastFilter = FORBIDDEN;
        for (ConditionalFilters.ConditionalFilter conditionalFilter : this.filters) {
            if (conditionalFilter.getCondition().canApplyFilter(context, request)) {
                return conditionalFilter.getFilter().filter(context, request, next);
            }
            lastFilter = conditionalFilter.getFilter();
        }
        return lastFilter.filter(context, request, next);
    }
}

