/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.SimplePropertyMapper;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.Function;
import org.forgerock.util.Pair;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class ObjectPropertyMapper
extends PropertyMapper {
    private final Map<String, Mapping> mappings = new LinkedHashMap<String, Mapping>();
    private boolean includeAllUserAttributesByDefault = false;
    private final Set<String> excludedDefaultUserAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    ObjectPropertyMapper() {
    }

    @Override
    boolean isRequired() {
        return false;
    }

    @Override
    boolean isMultiValued() {
        return false;
    }

    public ObjectPropertyMapper property(String name, PropertyMapper mapper) {
        this.mappings.put(Utils.toLowerCase(name), new Mapping(name, mapper));
        return this;
    }

    public ObjectPropertyMapper includeAllUserAttributesByDefault(boolean include) {
        this.includeAllUserAttributesByDefault = include;
        return this;
    }

    public ObjectPropertyMapper excludedDefaultUserAttributes(String ... attributeNames) {
        return this.excludedDefaultUserAttributes(Arrays.asList(attributeNames));
    }

    public ObjectPropertyMapper excludedDefaultUserAttributes(Collection<String> attributeNames) {
        this.excludedDefaultUserAttributes.addAll(attributeNames);
        return this;
    }

    public String toString() {
        return "object(" + org.forgerock.util.Utils.joinAsString((String)", ", this.mappings.values()) + ")";
    }

    @Override
    Promise<List<Attribute>, ResourceException> create(Context context, Resource resource, JsonPointer path, JsonValue v) {
        try {
            Map<String, Mapping> missingMappings = this.validateJsonValue(path, v);
            ArrayList<Promise<List<Attribute>, ResourceException>> promises = new ArrayList<Promise<List<Attribute>, ResourceException>>();
            if (v != null && !v.isNull()) {
                for (Map.Entry entry : v.asMap().entrySet()) {
                    Mapping mapping = this.getMapping((String)entry.getKey());
                    JsonValue subValue = new JsonValue(entry.getValue());
                    promises.add(mapping.mapper.create(context, resource, path.child((String)entry.getKey()), subValue));
                }
            }
            for (Mapping mapping : missingMappings.values()) {
                promises.add(mapping.mapper.create(context, resource, path.child(mapping.name), null));
            }
            return Promises.when(promises).then(this.accumulateResults());
        }
        catch (Exception e) {
            return Rest2Ldap.asResourceException(e).asPromise();
        }
    }

    @Override
    void getLdapAttributes(JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
        if (subPath.isEmpty()) {
            if (this.includeAllUserAttributesByDefault) {
                ldapAttributes.add("*");
            }
            for (Mapping mapping : this.mappings.values()) {
                mapping.mapper.getLdapAttributes(path.child(mapping.name), subPath, ldapAttributes);
            }
        } else {
            Mapping mapping = this.getMappingOrNull(subPath);
            if (mapping != null) {
                mapping.mapper.getLdapAttributes(path.child(subPath.get(0)), subPath.relativePointer(), ldapAttributes);
            }
        }
    }

    @Override
    Promise<Filter, ResourceException> getLdapFilter(Context context, Resource resource, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        Mapping mapping = this.getMappingOrNull(subPath);
        if (mapping != null) {
            return mapping.mapper.getLdapFilter(context, resource, path.child(subPath.get(0)), subPath.relativePointer(), type, operator, valueAssertion);
        }
        return Promises.newResultPromise((Object)Filter.alwaysFalse());
    }

    @Override
    Promise<List<Modification>, ResourceException> patch(Context context, Resource resource, JsonPointer path, PatchOperation operation) {
        try {
            JsonPointer field = operation.getField();
            JsonValue v = operation.getValue();
            if (field.isEmpty()) {
                this.validateJsonValue(path, v);
                ArrayList<Promise<List<Modification>, ResourceException>> promises = new ArrayList<Promise<List<Modification>, ResourceException>>();
                if (!v.isNull()) {
                    for (Map.Entry me : v.asMap().entrySet()) {
                        Mapping mapping = this.getMapping((String)me.getKey());
                        JsonValue subValue = new JsonValue(me.getValue());
                        PatchOperation subOperation = PatchOperation.operation((String)operation.getOperation(), (JsonPointer)field, (Object)subValue);
                        promises.add(mapping.mapper.patch(context, resource, path.child((String)me.getKey()), subOperation));
                    }
                }
                return Promises.when(promises).then(this.accumulateResults());
            }
            String fieldName = field.get(0);
            Mapping mapping = this.getMappingOrNull(fieldName);
            if (mapping == null) {
                throw Utils.newBadRequestException(Rest2ldapMessages.ERR_UNRECOGNIZED_FIELD.get((Object)path.child(fieldName)));
            }
            PatchOperation subOperation = PatchOperation.operation((String)operation.getOperation(), (JsonPointer)field.relativePointer(), (Object)v);
            return mapping.mapper.patch(context, resource, path.child(fieldName), subOperation);
        }
        catch (Exception e) {
            return Rest2Ldap.asResourceException(e).asPromise();
        }
    }

    @Override
    Promise<JsonValue, ResourceException> read(Context context, Resource resource, JsonPointer path, Entry e) {
        ArrayList<Promise> promises = new ArrayList<Promise>(this.mappings.size());
        for (Mapping mapping : this.mappings.values()) {
            promises.add(mapping.mapper.read(context, resource, path.child(mapping.name), e).then(this.toProperty(mapping.name)));
        }
        if (this.includeAllUserAttributesByDefault) {
            for (Attribute attribute : e.getAllAttributes()) {
                if (attribute.getAttributeDescription().getAttributeType().isOperational()) continue;
                String attributeName = attribute.getAttributeDescriptionAsString();
                if (!this.excludedDefaultUserAttributes.isEmpty() && this.excludedDefaultUserAttributes.contains(attributeName)) continue;
                SimplePropertyMapper mapper = Rest2Ldap.simple(attribute.getAttributeDescription());
                promises.add(mapper.read(context, resource, path.child(attributeName), e).then(this.toProperty(attributeName)));
            }
        }
        return Promises.when(promises).then((Function)new Function<List<Pair<String, JsonValue>>, JsonValue, ResourceException>(){

            public JsonValue apply(List<Pair<String, JsonValue>> value) {
                if (value.isEmpty()) {
                    return null;
                }
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(value.size());
                for (Pair<String, JsonValue> e : value) {
                    if (e == null) continue;
                    result.put((String)e.getFirst(), ((JsonValue)e.getSecond()).getObject());
                }
                return new JsonValue(result);
            }
        });
    }

    private Function<JsonValue, Pair<String, JsonValue>, ResourceException> toProperty(final String name) {
        return new Function<JsonValue, Pair<String, JsonValue>, ResourceException>(){

            public Pair<String, JsonValue> apply(JsonValue value) {
                return value != null ? Pair.of((Object)name, (Object)value) : null;
            }
        };
    }

    @Override
    Promise<List<Modification>, ResourceException> update(Context context, Resource resource, JsonPointer path, Entry e, JsonValue v) {
        try {
            Map<String, Mapping> missingMappings = this.validateJsonValue(path, v);
            ArrayList<Promise<List<Modification>, ResourceException>> promises = new ArrayList<Promise<List<Modification>, ResourceException>>();
            if (v != null && !v.isNull()) {
                for (Map.Entry entry : v.asMap().entrySet()) {
                    Mapping mapping = this.getMapping((String)entry.getKey());
                    JsonValue subValue = new JsonValue(entry.getValue());
                    promises.add(mapping.mapper.update(context, resource, path.child((String)entry.getKey()), e, subValue));
                }
            }
            for (Mapping mapping : missingMappings.values()) {
                promises.add(mapping.mapper.update(context, resource, path.child(mapping.name), e, null));
            }
            return Promises.when(promises).then(this.accumulateResults());
        }
        catch (Exception ex) {
            return Rest2Ldap.asResourceException(ex).asPromise();
        }
    }

    private <T> Function<List<List<T>>, List<T>, ResourceException> accumulateResults() {
        return new Function<List<List<T>>, List<T>, ResourceException>(){

            public List<T> apply(List<List<T>> value) {
                switch (value.size()) {
                    case 0: {
                        return Collections.emptyList();
                    }
                    case 1: {
                        return value.get(0);
                    }
                }
                ArrayList attributes = new ArrayList(value.size());
                for (List a : value) {
                    attributes.addAll(a);
                }
                return attributes;
            }
        };
    }

    private Map<String, Mapping> validateJsonValue(JsonPointer path, JsonValue v) throws ResourceException {
        LinkedHashMap<String, Mapping> missingMappings = new LinkedHashMap<String, Mapping>(this.mappings);
        if (v != null && !v.isNull()) {
            if (v.isMap()) {
                for (String attribute : v.asMap().keySet()) {
                    if (missingMappings.remove(Utils.toLowerCase(attribute)) != null || this.isIncludedDefaultUserAttribute(attribute)) continue;
                    throw Utils.newBadRequestException(Rest2ldapMessages.ERR_UNRECOGNIZED_FIELD.get((Object)path.child(attribute)));
                }
            } else {
                throw Utils.newBadRequestException(Rest2ldapMessages.ERR_FIELD_WRONG_TYPE.get((Object)path));
            }
        }
        return missingMappings;
    }

    private Mapping getMappingOrNull(JsonPointer jsonAttribute) {
        return jsonAttribute.isEmpty() ? null : this.getMappingOrNull(jsonAttribute.get(0));
    }

    private Mapping getMappingOrNull(String jsonAttribute) {
        Mapping mapping = this.mappings.get(Utils.toLowerCase(jsonAttribute));
        if (mapping != null) {
            return mapping;
        }
        if (this.isIncludedDefaultUserAttribute(jsonAttribute)) {
            return new Mapping(jsonAttribute, Rest2Ldap.simple(jsonAttribute));
        }
        return null;
    }

    private Mapping getMapping(String jsonAttribute) {
        Mapping mappingOrNull = this.getMappingOrNull(jsonAttribute);
        if (mappingOrNull != null) {
            return mappingOrNull;
        }
        throw new IllegalStateException("Unexpected null mapping for jsonAttribute: " + jsonAttribute);
    }

    private boolean isIncludedDefaultUserAttribute(String attributeName) {
        return this.includeAllUserAttributesByDefault && (this.excludedDefaultUserAttributes.isEmpty() || !this.excludedDefaultUserAttributes.contains(attributeName));
    }

    @Override
    JsonValue toJsonSchema() {
        ArrayList<String> requiredFields = new ArrayList<String>();
        JsonValue jsonProps = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));
        for (Mapping mapping : this.mappings.values()) {
            String attribute = mapping.name;
            PropertyMapper mapper = mapping.mapper;
            jsonProps.put(attribute, mapper.toJsonSchema().getObject());
            if (!mapper.isRequired()) continue;
            requiredFields.add(attribute);
        }
        JsonValue jsonSchema = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"object")}));
        if (!requiredFields.isEmpty()) {
            jsonSchema.put("required", requiredFields);
        }
        if (jsonProps.size() > 0) {
            jsonSchema.put("properties", jsonProps.getObject());
        }
        return jsonSchema;
    }

    private static final class Mapping {
        private final PropertyMapper mapper;
        private final String name;

        private Mapping(String name, PropertyMapper mapper) {
            this.name = name;
            this.mapper = mapper;
        }

        public String toString() {
            return this.name + " -> " + this.mapper;
        }
    }
}

