/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.transform;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.models.Operation;
import java.util.ArrayList;
import java.util.List;
import org.forgerock.api.transform.LocalizableDescription;
import org.forgerock.util.i18n.LocalizableString;

public class LocalizableOperation
extends Operation
implements LocalizableDescription<Operation> {
    private LocalizableString description;
    private List<LocalizableString> tags;

    @Override
    public LocalizableOperation description(LocalizableString desc) {
        this.description = desc;
        return this;
    }

    @Override
    public LocalizableOperation description(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDescription(String description) {
        super.setDescription(description);
        this.description = new LocalizableString(description);
    }

    @Override
    public LocalizableString getLocalizableDescription() {
        return this.description;
    }

    public void addTag(String tag) {
        super.addTag(tag);
        this.addTag(new LocalizableString(tag));
    }

    public void addTag(LocalizableString tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<LocalizableString>();
        }
        this.tags.add(tag);
    }

    public void setTags(List<String> tags) {
        super.setTags(tags);
        tags = new ArrayList<String>();
        for (String tag : tags) {
            this.addTag(tag);
        }
    }

    @JsonProperty(value="tags")
    public List<LocalizableString> getLocalizableTags() {
        return this.tags;
    }

    @JsonIgnore
    public List<String> getTags() {
        return super.getTags();
    }
}

