/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.util.Objects;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Operation;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.Schema;
import org.forgerock.api.util.ValidationUtil;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Action
extends Operation
implements Comparable<Action> {
    private final String name;
    private final Schema request;
    private final Schema response;

    private Action(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.request = builder.request;
        this.response = builder.response;
        if (ValidationUtil.isEmpty(this.name)) {
            throw new ApiValidationException("name is required");
        }
        if (ValidationUtil.containsWhitespace(this.name)) {
            throw new ApiValidationException("name contains whitespace");
        }
    }

    public String getName() {
        return this.name;
    }

    public Schema getRequest() {
        return this.request;
    }

    public Schema getResponse() {
        return this.response;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Action action = (Action)o;
        return super.equals(o) && Objects.equals(this.name, action.name) && Objects.equals(this.request, action.request) && Objects.equals(this.response, action.response);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.request, this.response);
    }

    public static final Builder action() {
        return new Builder();
    }

    @Override
    protected void allocateToResource(Resource.Builder resourceBuilder) {
        resourceBuilder.action(this);
    }

    public static Action fromAnnotation(org.forgerock.api.annotations.Action action, Method annotated, ApiDescription descriptor, Class<?> relativeType) {
        Builder builder = Action.action();
        String specifiedName = action.name();
        if (Strings.isNullOrEmpty((String)specifiedName)) {
            if (annotated == null) {
                throw new IllegalArgumentException("Action does not have a name: " + action);
            }
            specifiedName = annotated.getName();
        }
        return ((Builder)builder.name(specifiedName).request(Schema.fromAnnotation(action.request(), descriptor, relativeType)).response(Schema.fromAnnotation(action.response(), descriptor, relativeType)).detailsFromAnnotation(action.operationDescription(), descriptor, relativeType)).build();
    }

    @Override
    public int compareTo(Action action) {
        return this.name.compareTo(action.getName());
    }

    public static final class Builder
    extends Operation.Builder<Builder> {
        private String name;
        private Schema request;
        private Schema response;

        @Override
        protected Builder self() {
            return this;
        }

        @JsonProperty(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="request")
        public Builder request(Schema request) {
            this.request = request;
            return this;
        }

        @JsonProperty(value="response")
        public Builder response(Schema response) {
            this.response = response;
            return this;
        }

        public Action build() {
            return new Action(this);
        }
    }
}

