/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.jackson;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.io.IOException;
import java.util.Set;
import javax.validation.ValidationException;
import org.forgerock.api.jackson.CrestPropertyDetailsSchemaFactoryWrapper;
import org.forgerock.api.jackson.ValidatableSchema;
import org.forgerock.json.JsonValue;

public final class JacksonUtils {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);

    public static boolean validateJsonToSchema(String json, JsonSchema schema) throws ValidationException {
        if (schema instanceof ValidatableSchema) {
            try {
                ((ValidatableSchema)schema).validate(JsonValue.json((Object)OBJECT_MAPPER.readValue(json, Object.class)));
                return true;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot parse JSON", e);
            }
        }
        return false;
    }

    public static JsonSchema schemaFor(Class<?> type) throws JsonMappingException {
        CrestPropertyDetailsSchemaFactoryWrapper visitor = new CrestPropertyDetailsSchemaFactoryWrapper();
        OBJECT_MAPPER.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)visitor);
        return visitor.finalSchema();
    }

    static void validateEnum(Set<String> enums, String value) throws ValidationException {
        if (enums != null && !enums.isEmpty() && !enums.contains(value)) {
            throw new ValidationException("Value " + value + " is not in enums " + enums);
        }
    }

    static void validateFormatForNumber(JsonValueFormat format) throws ValidationException {
        if (format != null && format != JsonValueFormat.UTC_MILLISEC) {
            throw new ValidationException("Expected format " + format + " but got a number");
        }
    }

    static void validateMaximumAndMinimum(Number number, Double maximum, Boolean exclusiveMaximum, Double minimum, Boolean exclusiveMinimum) throws ValidationException {
        double value = number.doubleValue();
        if (maximum != null) {
            if (exclusiveMaximum != null && exclusiveMaximum.booleanValue() && value >= maximum) {
                throw new ValidationException("Number value is too large - exclusive maximum is " + maximum + ", but got " + value);
            }
            if ((exclusiveMaximum == null || !exclusiveMaximum.booleanValue()) && value > maximum) {
                throw new ValidationException("Number value is too large - maximum is " + maximum + ", but got " + value);
            }
        }
        if (minimum != null) {
            if (exclusiveMinimum != null && exclusiveMinimum.booleanValue() && value >= minimum) {
                throw new ValidationException("Number value is too small - exclusive minimum is " + minimum + ", but got " + value);
            }
            if ((exclusiveMinimum == null || !exclusiveMinimum.booleanValue()) && value > minimum) {
                throw new ValidationException("Number value is too small - minimum is " + minimum + ", but got " + value);
            }
        }
    }

    private JacksonUtils() {
    }
}

