/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.apache.async;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.forgerock.http.apache.AbstractHttpClient;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.util.Factory;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AsyncHttpClient
extends AbstractHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClient.class);
    private final CloseableHttpAsyncClient client;

    AsyncHttpClient(CloseableHttpAsyncClient client, Factory<Buffer> storage) {
        super(storage);
        this.client = client;
    }

    public Promise<Response, NeverThrowsException> sendAsync(final Request request) {
        HttpUriRequest clientRequest = this.createHttpUriRequest(request);
        final PromiseImpl promise = PromiseImpl.create();
        Object callback = new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                Response response = AsyncHttpClient.this.createResponse(result);
                promise.handleResult((Object)response);
            }

            public void failed(Exception ex) {
                logger.error("Failed to obtain response for {}", (Object)request.getUri());
                Response response = new Response(Status.BAD_GATEWAY);
                response.setCause(ex);
                promise.handleResult((Object)response);
            }

            public void cancelled() {
                this.failed(new InterruptedException("Request processing has been cancelled"));
            }
        };
        Map mdc = MDC.getCopyOfContextMap();
        if (mdc != null) {
            callback = new MdcFutureCallback((FutureCallback)callback, mdc);
        }
        this.client.execute(clientRequest, (FutureCallback)callback);
        return promise;
    }

    public void close() throws IOException {
        this.client.close();
    }

    private static final class MdcFutureCallback
    implements FutureCallback<HttpResponse> {
        private final FutureCallback<HttpResponse> delegate;
        private final Map<String, String> mdc;

        private MdcFutureCallback(FutureCallback<HttpResponse> delegate, Map<String, String> mdc) {
            this.delegate = delegate;
            this.mdc = mdc;
        }

        public void completed(HttpResponse result) {
            Map previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.completed((Object)result);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        public void failed(Exception ex) {
            Map previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.failed(ex);
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        public void cancelled() {
            Map previous = MDC.getCopyOfContextMap();
            try {
                MDC.setContextMap(this.mdc);
                this.delegate.cancelled();
            }
            finally {
                this.restoreMdc(previous);
            }
        }

        private void restoreMdc(Map<String, String> previous) {
            if (previous != null) {
                MDC.setContextMap(previous);
            } else {
                MDC.clear();
            }
        }
    }
}

