/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers.slf4j;

import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedMarker;
import org.opends.messages.ExternalMessages;
import org.opends.messages.Severity;
import org.opends.server.loggers.DebugLogger;
import org.opends.server.loggers.DebugTracer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.LoggingCategoryNames;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

final class OpenDJLoggerAdapter
implements Logger {
    private final String name;
    private final DebugTracer tracer;

    public OpenDJLoggerAdapter(String name) {
        this.tracer = DebugLogger.getTracer((String)name);
        this.name = LoggingCategoryNames.getCategoryName((String)name);
    }

    public String getName() {
        return this.name;
    }

    private String formatMessage(String message, Object ... args) {
        if (args == null || args.length == 0) {
            return message;
        }
        return MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
    }

    private void publishInDebugLogger(String msg) {
        this.tracer.trace(msg);
    }

    private void publishInDebugLogger(String message, Throwable t) {
        this.tracer.traceException(message, t);
    }

    private void publish(Marker marker, String message, Severity severity, Throwable throwable) {
        if (marker instanceof LocalizedMarker) {
            this.publishInErrorLogger(((LocalizedMarker)marker).getMessage(), severity, throwable);
        } else if (severity == Severity.DEBUG) {
            this.publishInDebugLogger(message, throwable);
        } else {
            this.publishInErrorLogger(message, severity, throwable);
        }
    }

    private void publishInErrorLogger(String message, Severity severity, Throwable throwable) {
        this.publishInErrorLogger(ExternalMessages.INFO_EXTERNAL_LIB_MESSAGE.get((Object)message), severity, throwable);
    }

    private void publishInErrorLogger(LocalizableMessage localizableMessage, Severity severity, Throwable throwable) {
        ErrorLogger.log((String)this.name, (Severity)severity, (LocalizableMessage)localizableMessage, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return DebugLogger.debugEnabled() && this.tracer.enabled();
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(msg);
        }
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(msg);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(msg, t);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(msg, t);
        }
    }

    public boolean isDebugEnabled() {
        return ErrorLogger.isEnabledFor((String)this.name, (Severity)Severity.INFORMATION);
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled()) {
            this.publish(marker, msg, Severity.INFORMATION, null);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.publish(marker, msg, Severity.INFORMATION, t);
        }
    }

    public boolean isInfoEnabled() {
        return ErrorLogger.isEnabledFor((String)this.name, (Severity)Severity.NOTICE);
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled()) {
            this.publish(marker, msg, Severity.NOTICE, null);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.publish(marker, msg, Severity.NOTICE, t);
        }
    }

    public boolean isWarnEnabled() {
        return ErrorLogger.isEnabledFor((String)this.name, (Severity)Severity.WARNING);
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled()) {
            this.publish(marker, msg, Severity.WARNING, null);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.publish(marker, msg, Severity.WARNING, t);
        }
    }

    public boolean isErrorEnabled() {
        return ErrorLogger.isEnabledFor((String)this.name, (Severity)Severity.ERROR);
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled()) {
            this.publish(marker, msg, Severity.ERROR, null);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.publish(marker, msg, Severity.ERROR, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void trace(String message, Object arg) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, arg));
        }
    }

    public void trace(String message, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, arg1, arg2));
        }
    }

    public void trace(String message, Object ... argArray) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, argArray));
        }
    }

    public void trace(Marker marker, String message, Object arg) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, arg));
        }
    }

    public void trace(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, arg1, arg2));
        }
    }

    public void trace(Marker marker, String message, Object ... argArray) {
        if (this.isTraceEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, argArray));
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.publishInDebugLogger(this.formatMessage(msg, null), t);
        }
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.publishInDebugLogger(this.formatMessage(msg, null), null);
        }
    }

    public void debug(String message, Object arg) {
        if (this.isDebugEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, arg), null);
        }
    }

    public void debug(String message, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, arg1, arg2), null);
        }
    }

    public void debug(String message, Object ... argArray) {
        if (this.isDebugEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, argArray), null);
        }
    }

    public void debug(Marker marker, String message, Object arg) {
        if (this.isDebugEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, arg), null);
        }
    }

    public void debug(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, arg1, arg2), null);
        }
    }

    public void debug(Marker marker, String message, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.publishInDebugLogger(this.formatMessage(message, arguments), null);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.publishInErrorLogger(this.formatMessage(msg, null), Severity.INFORMATION, t);
        }
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.publishInErrorLogger(this.formatMessage(msg, null), Severity.INFORMATION, null);
        }
    }

    public void info(String message, Object arg) {
        if (this.isInfoEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg), Severity.INFORMATION, null);
        }
    }

    public void info(String message, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg1, arg2), Severity.INFORMATION, null);
        }
    }

    public void info(String message, Object ... argArray) {
        if (this.isInfoEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, argArray), Severity.INFORMATION, null);
        }
    }

    public void info(Marker marker, String message, Object arg) {
        if (this.isInfoEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg), Severity.INFORMATION, null);
        }
    }

    public void info(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg1, arg2), Severity.INFORMATION, null);
        }
    }

    public void info(Marker marker, String message, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arguments), Severity.INFORMATION, null);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.publishInErrorLogger(this.formatMessage(msg, null), Severity.WARNING, t);
        }
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.publishInErrorLogger(this.formatMessage(msg, null), Severity.WARNING, null);
        }
    }

    public void warn(String message, Object arg) {
        if (this.isWarnEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg), Severity.WARNING, null);
        }
    }

    public void warn(String message, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg1, arg2), Severity.WARNING, null);
        }
    }

    public void warn(String message, Object ... argArray) {
        if (this.isWarnEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, argArray), Severity.WARNING, null);
        }
    }

    public void warn(Marker marker, String message, Object arg) {
        if (this.isWarnEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg), Severity.WARNING, null);
        }
    }

    public void warn(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg1, arg2), Severity.WARNING, null);
        }
    }

    public void warn(Marker marker, String message, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arguments), Severity.WARNING, null);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.publishInErrorLogger(this.formatMessage(msg, null), Severity.ERROR, t);
        }
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.publishInErrorLogger(this.formatMessage(msg, Severity.ERROR, null), Severity.ERROR, null);
        }
    }

    public void error(String message, Object arg) {
        if (this.isErrorEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg), Severity.ERROR, null);
        }
    }

    public void error(String message, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg1, arg2), Severity.ERROR, null);
        }
    }

    public void error(String message, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arguments), Severity.ERROR, null);
        }
    }

    public void error(Marker marker, String message, Object arg) {
        if (this.isErrorEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg), Severity.ERROR, null);
        }
    }

    public void error(Marker marker, String message, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arg1, arg2), Severity.ERROR, null);
        }
    }

    public void error(Marker marker, String message, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.publishInErrorLogger(this.formatMessage(message, arguments), Severity.ERROR, null);
        }
    }
}

