/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.MultiColumnPrinter;
import com.forgerock.opendj.ldap.tools.PerformanceRunner;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mpierce.metrics.reservoir.hdrhistogram.HdrHistogramReservoir;

class StatsThread
extends Thread {
    static final String STAT_ID_PREFIX = "org.forgerock.opendj.";
    private static final String TIME_NOW = "org.forgerock.opendj.current_time";
    private static final String RECENT_THROUGHPUT = "org.forgerock.opendj.recent_throughput";
    private static final String AVERAGE_THROUGHPUT = "org.forgerock.opendj.average_throughput";
    private static final String RECENT_RESPONSE_TIME_MS = "org.forgerock.opendj.recent_response_time";
    private static final String AVERAGE_RESPONSE_TIME_MS = "org.forgerock.opendj.average_response_time";
    private static final String PERCENTILES = "org.forgerock.opendj.percentiles";
    private static final String ERROR_PER_SECOND = "org.forgerock.opendj.error_per_second";
    public static final double MS_IN_S = TimeUnit.SECONDS.toMillis(1L);
    public static final double NS_IN_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    final MetricRegistry registry = new MetricRegistry();
    private final Histogram responseTimes = new Histogram((Reservoir)new HdrHistogramReservoir());
    private final StatsTimer gcTimerMs = new StatsTimer(){
        private final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();

        @Override
        long getInstantTime() {
            long gcDurationMs = 0L;
            for (GarbageCollectorMXBean bean : this.gcBeans) {
                gcDurationMs += bean.getCollectionTime();
            }
            return gcDurationMs;
        }
    };
    private final StatsTimer timerMs = new StatsTimer(){

        @Override
        long getInstantTime() {
            return System.currentTimeMillis();
        }
    };
    IntervalCounter waitDurationNsCount;
    IntervalCounter successCount;
    private IntervalCounter operationCount;
    private IntervalCounter errorCount;
    private IntervalCounter durationMsCount;
    private final ConsoleApplication app;
    private final double[] percentiles;
    private final PerformanceRunner performanceRunner;
    private final RateReporter reporter;
    private long startTimeMs;
    private volatile boolean warmingUp;
    private final ScheduledExecutorService statThreadScheduler = Executors.newSingleThreadScheduledExecutor();

    static final IntervalCounter newIntervalCounter() {
        return new IntervalCounter();
    }

    StatsThread(PerformanceRunner performanceRunner, ConsoleApplication application) {
        super("Stats Thread");
        this.resetStats();
        this.performanceRunner = performanceRunner;
        this.app = application;
        this.percentiles = performanceRunner.getPercentiles();
        this.reporter = this.app.isScriptFriendly() ? new CsvRateReporter() : new ConsoleRateReporter();
        this.registerStats();
    }

    final void resetStats() {
        this.errorCount = StatsThread.newIntervalCounter();
        this.operationCount = StatsThread.newIntervalCounter();
        this.successCount = StatsThread.newIntervalCounter();
        this.waitDurationNsCount = StatsThread.newIntervalCounter();
        this.durationMsCount = StatsThread.newIntervalCounter();
        this.resetAdditionalStats();
    }

    private void registerStats() {
        if (this.app.isScriptFriendly()) {
            this.registry.register(TIME_NOW, (Metric)new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)(System.currentTimeMillis() - StatsThread.this.startTimeMs), (double)MS_IN_S);
                }
            });
        }
        this.registry.register(RECENT_THROUGHPUT, (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)(StatsThread.this.successCount.getLastIntervalCount() + StatsThread.this.errorCount.getLastIntervalCount()), (double)((double)StatsThread.this.durationMsCount.getLastIntervalCount() / MS_IN_S));
            }
        });
        this.registry.register(AVERAGE_THROUGHPUT, (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)(StatsThread.this.successCount.getLastTotalCount() + StatsThread.this.errorCount.getLastTotalCount()), (double)((double)StatsThread.this.durationMsCount.getLastTotalCount() / MS_IN_S));
            }
        });
        this.registry.register(RECENT_RESPONSE_TIME_MS, (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((double)StatsThread.this.waitDurationNsCount.getLastIntervalCount() / NS_IN_MS - (double)StatsThread.this.gcTimerMs.elapsed()), (double)(StatsThread.this.successCount.getLastIntervalCount() + StatsThread.this.errorCount.getLastIntervalCount()));
            }
        });
        this.registry.register(AVERAGE_RESPONSE_TIME_MS, (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((double)StatsThread.this.waitDurationNsCount.getLastTotalCount() / NS_IN_MS - (double)StatsThread.this.gcTimerMs.getInstantTime()), (double)(StatsThread.this.successCount.getLastTotalCount() + StatsThread.this.errorCount.getLastTotalCount()));
            }
        });
        this.registry.register(ERROR_PER_SECOND, (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)StatsThread.this.errorCount.getLastIntervalCount(), (double)((double)StatsThread.this.durationMsCount.getLastIntervalCount() / MS_IN_S));
            }
        });
        this.registry.register(PERCENTILES, (Metric)this.responseTimes);
    }

    void startReporting() throws InterruptedException {
        this.warmUp();
        this.init();
        long statsIntervalMs = this.performanceRunner.getStatsInterval();
        this.statThreadScheduler.scheduleAtFixedRate(this, statsIntervalMs, statsIntervalMs, TimeUnit.MILLISECONDS);
    }

    private void warmUp() throws InterruptedException {
        long warmUpDurationMs = this.performanceRunner.getWarmUpDurationMs();
        if (warmUpDurationMs > 0L) {
            if (!this.app.isScriptFriendly()) {
                this.app.println(ToolsMessages.INFO_TOOL_WARMING_UP.get((Object)(warmUpDurationMs / TimeUnit.SECONDS.toMillis(1L))));
            }
            Thread.sleep(warmUpDurationMs);
            this.resetStats();
        }
        this.warmingUp = false;
    }

    private void init() {
        this.reporter.printTitle();
        this.timerMs.start();
        this.gcTimerMs.start();
        this.startTimeMs = System.currentTimeMillis();
    }

    public void stopRecording(boolean stoppedByError) {
        this.statThreadScheduler.shutdown();
        if (!stoppedByError) {
            try {
                this.statThreadScheduler.awaitTermination(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.run();
        }
    }

    @Override
    public void run() {
        this.durationMsCount.inc(this.timerMs.reset() - this.gcTimerMs.reset());
        this.durationMsCount.refreshIntervalCount();
        this.operationCount.refreshIntervalCount();
        this.successCount.refreshIntervalCount();
        this.errorCount.refreshIntervalCount();
        this.waitDurationNsCount.refreshIntervalCount();
        this.reporter.report();
    }

    void addResponseTime(long responseTimeNs) {
        if (!this.warmingUp && responseTimeNs >= 0L) {
            this.responseTimes.update(responseTimeNs);
            this.waitDurationNsCount.inc(responseTimeNs);
        }
    }

    void incrementFailedCount() {
        this.errorCount.inc();
    }

    void incrementSuccessCount() {
        this.successCount.inc();
    }

    void incrementOperationCount() {
        this.operationCount.inc();
    }

    List<MultiColumnPrinter.Column> registerAdditionalColumns() {
        return Collections.emptyList();
    }

    void resetAdditionalStats() {
    }

    static final class IntervalCounter
    extends Counter {
        private long lastIntervalCount;
        private long lastTotalCount;

        IntervalCounter() {
        }

        long refreshIntervalCount() {
            long totalCount = this.getCount();
            this.lastIntervalCount = totalCount - this.lastTotalCount;
            this.lastTotalCount = totalCount;
            return this.lastIntervalCount;
        }

        long getLastIntervalCount() {
            return this.lastIntervalCount;
        }

        long getLastTotalCount() {
            return this.lastTotalCount;
        }
    }

    private static abstract class StatsTimer {
        private long startTimeMeasure;
        private long elapsed;

        private StatsTimer() {
        }

        abstract long getInstantTime();

        private void start() {
            this.startTimeMeasure = this.getInstantTime();
        }

        private long reset() {
            long time = this.getInstantTime();
            this.elapsed = time - this.startTimeMeasure;
            this.startTimeMeasure = time;
            return this.elapsed;
        }

        private long elapsed() {
            return this.elapsed;
        }
    }

    private final class CsvRateReporter
    extends RateReporter {
        private CsvRateReporter() {
        }

        @Override
        void printTitle() {
            this.printer.printTitleLine();
        }

        @Override
        MultiColumnPrinter createPrinter() {
            ArrayList<MultiColumnPrinter.Column> columns = new ArrayList<MultiColumnPrinter.Column>();
            columns.add(MultiColumnPrinter.column((String)StatsThread.TIME_NOW, (String)"Time (seconds)", (int)3));
            columns.add(MultiColumnPrinter.column((String)StatsThread.RECENT_THROUGHPUT, (String)"Recent throughput (ops/second)", (int)1));
            columns.add(MultiColumnPrinter.column((String)StatsThread.AVERAGE_THROUGHPUT, (String)"Average throughput (ops/second)", (int)1));
            columns.add(MultiColumnPrinter.column((String)StatsThread.RECENT_RESPONSE_TIME_MS, (String)"Recent response time (milliseconds)", (int)3));
            columns.add(MultiColumnPrinter.column((String)StatsThread.AVERAGE_RESPONSE_TIME_MS, (String)"Average response time (milliseconds)", (int)3));
            for (double percentile : StatsThread.this.percentiles) {
                columns.add(MultiColumnPrinter.column((String)(StatsThread.PERCENTILES + percentile), (String)(percentile + "% response time (milliseconds)"), (int)2));
            }
            columns.add(MultiColumnPrinter.column((String)StatsThread.ERROR_PER_SECOND, (String)"Errors/second", (int)1));
            columns.addAll(StatsThread.this.registerAdditionalColumns());
            return MultiColumnPrinter.builder((PrintStream)StatsThread.this.app.getOutputStream(), columns).columnSeparator(",").build();
        }
    }

    private final class ConsoleRateReporter
    extends RateReporter {
        private static final int STANDARD_WIDTH = 8;
        private List<MultiColumnPrinter.Column> additionalColumns;

        private ConsoleRateReporter() {
        }

        @Override
        void printTitle() {
            int throughputRawSpan = 2;
            int responseTimeRawSpan = 2 + StatsThread.this.percentiles.length;
            int additionalStatsRawSpan = 1 + this.additionalColumns.size();
            this.printer.printDashedLine();
            this.printer.printTitleSection("Throughput", 2);
            this.printer.printTitleSection("Response Time", responseTimeRawSpan);
            this.printer.printTitleSection(additionalStatsRawSpan > 1 ? "Additional" : "", additionalStatsRawSpan);
            this.printer.printTitleSection("(ops/second)", 2);
            this.printer.printTitleSection("(milliseconds)", responseTimeRawSpan);
            this.printer.printTitleSection(additionalStatsRawSpan > 1 ? "Statistics" : "", additionalStatsRawSpan);
            this.printer.printTitleLine();
            this.printer.printDashedLine();
        }

        @Override
        MultiColumnPrinter createPrinter() {
            ArrayList<MultiColumnPrinter.Column> columns = new ArrayList<MultiColumnPrinter.Column>();
            columns.add(MultiColumnPrinter.separatorColumn());
            columns.add(MultiColumnPrinter.column((String)StatsThread.RECENT_THROUGHPUT, (String)"recent", (int)8, (int)1));
            columns.add(MultiColumnPrinter.column((String)StatsThread.AVERAGE_THROUGHPUT, (String)"average", (int)8, (int)1));
            columns.add(MultiColumnPrinter.separatorColumn());
            columns.add(MultiColumnPrinter.column((String)StatsThread.RECENT_RESPONSE_TIME_MS, (String)"recent", (int)8, (int)3));
            columns.add(MultiColumnPrinter.column((String)StatsThread.AVERAGE_RESPONSE_TIME_MS, (String)"average", (int)8, (int)3));
            for (double percentile : StatsThread.this.percentiles) {
                columns.add(MultiColumnPrinter.column((String)(StatsThread.PERCENTILES + percentile), (String)(percentile + "%"), (int)8, (int)2));
            }
            columns.add(MultiColumnPrinter.separatorColumn());
            columns.add(MultiColumnPrinter.column((String)StatsThread.ERROR_PER_SECOND, (String)"err/sec", (int)8, (int)1));
            this.additionalColumns = StatsThread.this.registerAdditionalColumns();
            if (!this.additionalColumns.isEmpty()) {
                columns.addAll(this.additionalColumns);
            }
            columns.add(MultiColumnPrinter.separatorColumn());
            return MultiColumnPrinter.builder((PrintStream)StatsThread.this.app.getOutputStream(), columns).format(true).titleAlignment(MultiColumnPrinter.Alignment.CENTER).build();
        }
    }

    private abstract class RateReporter
    extends ScheduledReporter {
        final MultiColumnPrinter printer;

        private RateReporter() {
            super(StatsThread.this.registry, "", MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
            this.printer = this.createPrinter();
        }

        abstract MultiColumnPrinter createPrinter();

        abstract void printTitle();

        public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
            int percentileIndex = 0;
            for (MultiColumnPrinter.Column column : this.printer.getColumns()) {
                String statKey = column.getId();
                if (gauges.containsKey(statKey)) {
                    this.printer.printData((Double)((Gauge)gauges.get(statKey)).getValue());
                    continue;
                }
                if (statKey.startsWith(StatsThread.PERCENTILES)) {
                    double quantile = StatsThread.this.percentiles[percentileIndex++] / 100.0;
                    this.printer.printData(Double.valueOf(((Histogram)histograms.get(StatsThread.PERCENTILES)).getSnapshot().getValue(quantile) / (double)TimeUnit.MILLISECONDS.toNanos(1L)));
                    continue;
                }
                this.printer.printData("-");
            }
        }
    }
}

