/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadResponseControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordReader;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIFChangeRecordReader;
import org.forgerock.util.annotations.VisibleForTesting;

public final class LDAPModify
extends ToolConsoleApplication {
    private EntryWriter writer;
    private Collection<Control> controls;
    private BooleanArgument verbose;

    public static void main(String[] args) {
        Utils.runToolAndExit(new LDAPModify(System.out, System.err), args);
    }

    public static int run(PrintStream out, PrintStream err, String ... args) {
        return Utils.runTool(new LDAPModify(out, err), args);
    }

    @VisibleForTesting
    LDAPModify(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    /*
     * Exception decompiling
     */
    @Override
    int run(String ... args) throws LDAPToolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int processModify(Connection connection, ChangeRecordReader reader, boolean continueOnError) {
        VisitorImpl visitor = new VisitorImpl(connection);
        while (true) {
            try {
                ChangeRecord cr;
                int result;
                do {
                    if (reader.hasNext()) continue;
                    return ResultCode.SUCCESS.intValue();
                } while ((result = ((Integer)(cr = reader.readChangeRecord()).accept((ChangeRecordVisitor)visitor, null)).intValue()) == 0 || continueOnError);
                return result;
            }
            catch (IOException ioe) {
                this.errPrintln(ToolsMessages.ERR_LDIF_FILE_READ_ERROR.get((Object)ioe.getLocalizedMessage()));
                if (continueOnError) continue;
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            break;
        }
    }

    private ChangeRecordReader createLDIFChangeRecordReader(StringArgument fileNameArg, List<String> trailingArgs) throws LDAPToolException {
        boolean readChangesFromStdin;
        boolean fileNameArgUsed = fileNameArg.isPresent();
        boolean readFromStdinTokenUsed = trailingArgs.size() == 1 && "-".equals(trailingArgs.get(0));
        boolean bl = readChangesFromStdin = readFromStdinTokenUsed || !fileNameArgUsed && trailingArgs.isEmpty();
        if (readChangesFromStdin) {
            return new LDIFChangeRecordReader(this.getInputStream());
        }
        ArrayList<String> filesToRead = new ArrayList<String>();
        if (fileNameArgUsed) {
            filesToRead.add(fileNameArg.getValue());
        }
        filesToRead.addAll(trailingArgs);
        return new LDIFChangeRecordReader(Utils.getLinesFromFiles(filesToRead));
    }

    private void addReadAttributesToControl(Collection<Control> controls, StringArgument attributesArg, boolean preRead) {
        if (attributesArg.isPresent()) {
            StringTokenizer tokenizer = new StringTokenizer(attributesArg.getValue(), ", ");
            LinkedList<String> attributes = new LinkedList<String>();
            while (tokenizer.hasMoreTokens()) {
                attributes.add(tokenizer.nextToken());
            }
            controls.add((Control)(preRead ? PreReadRequestControl.newControl((boolean)true, attributes) : PostReadRequestControl.newControl((boolean)true, attributes)));
        }
    }

    private final class VisitorImpl
    implements ChangeRecordVisitor<Integer, Void> {
        private final Connection connection;

        private VisitorImpl(Connection connection) {
            this.connection = connection;
        }

        public Integer visitChangeRecord(Void aVoid, AddRequest change) {
            for (Control control : LDAPModify.this.controls) {
                change.addControl(control);
            }
            String opType = "ADD";
            LDAPModify.this.println(ToolsMessages.INFO_PROCESSING_OPERATION.get((Object)"ADD", (Object)change.getName().toString()));
            if (this.dryRun()) {
                return ResultCode.SUCCESS.intValue();
            }
            try {
                Result r = this.connection.add(change);
                this.printResult("ADD", change.getName().toString(), r);
                return r.getResultCode().intValue();
            }
            catch (LdapException ere) {
                return Utils.printErrorMessage((ConsoleApplication)LDAPModify.this, ere, ToolsMessages.ERR_LDAP_MODIFY_FAILED);
            }
        }

        public Integer visitChangeRecord(Void aVoid, DeleteRequest change) {
            for (Control control : LDAPModify.this.controls) {
                change.addControl(control);
            }
            String opType = "DELETE";
            LDAPModify.this.println(ToolsMessages.INFO_PROCESSING_OPERATION.get((Object)"DELETE", (Object)change.getName().toString()));
            if (this.dryRun()) {
                return ResultCode.SUCCESS.intValue();
            }
            try {
                Result r = this.connection.delete(change);
                this.printResult("DELETE", change.getName().toString(), r);
                return r.getResultCode().intValue();
            }
            catch (LdapException ere) {
                return Utils.printErrorMessage((ConsoleApplication)LDAPModify.this, ere, ToolsMessages.ERR_LDAP_MODIFY_FAILED);
            }
        }

        public Integer visitChangeRecord(Void aVoid, ModifyDNRequest change) {
            for (Control control : LDAPModify.this.controls) {
                change.addControl(control);
            }
            String opType = "MODIFY DN";
            LDAPModify.this.println(ToolsMessages.INFO_PROCESSING_OPERATION.get((Object)"MODIFY DN", (Object)change.getName().toString()));
            if (this.dryRun()) {
                return ResultCode.SUCCESS.intValue();
            }
            try {
                Result r = this.connection.modifyDN(change);
                this.printResult("MODIFY DN", change.getName().toString(), r);
                return r.getResultCode().intValue();
            }
            catch (LdapException ere) {
                return Utils.printErrorMessage((ConsoleApplication)LDAPModify.this, ere, ToolsMessages.ERR_LDAP_MODIFY_FAILED);
            }
        }

        public Integer visitChangeRecord(Void aVoid, ModifyRequest change) {
            for (Control control : LDAPModify.this.controls) {
                change.addControl(control);
            }
            String opType = "MODIFY";
            LDAPModify.this.println(ToolsMessages.INFO_PROCESSING_OPERATION.get((Object)"MODIFY", (Object)change.getName().toString()));
            if (this.dryRun()) {
                return ResultCode.SUCCESS.intValue();
            }
            try {
                Result r = this.connection.modify(change);
                this.printResult("MODIFY", change.getName().toString(), r);
                return r.getResultCode().intValue();
            }
            catch (LdapException ere) {
                return Utils.printErrorMessage((ConsoleApplication)LDAPModify.this, ere, ToolsMessages.ERR_LDAP_MODIFY_FAILED);
            }
        }

        private void printResult(String operationType, String name, Result r) {
            PreReadResponseControl control;
            ResultCode rc = r.getResultCode();
            if (ResultCode.SUCCESS != rc && ResultCode.REFERRAL != rc) {
                Utils.printErrorMessage((ConsoleApplication)LDAPModify.this, r, ToolsMessages.ERR_LDAP_MODIFY_FAILED);
            } else {
                Utils.printSuccessMessage(LDAPModify.this, r, operationType, name);
            }
            try {
                control = (PreReadResponseControl)r.getControl(PreReadResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPModify.this.println(ToolsMessages.INFO_LDAPMODIFY_PREREAD_ENTRY.get());
                    LDAPModify.this.writer.writeEntry(control.getEntry());
                }
            }
            catch (DecodeException de) {
                LDAPModify.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            try {
                control = (PostReadResponseControl)r.getControl(PostReadResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPModify.this.println(ToolsMessages.INFO_LDAPMODIFY_POSTREAD_ENTRY.get());
                    LDAPModify.this.writer.writeEntry(control.getEntry());
                }
            }
            catch (DecodeException de) {
                LDAPModify.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        private boolean dryRun() {
            return this.connection == null;
        }
    }
}

