/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.util.Reject;

final class DataSource {
    private final IDataSource impl;

    public static Object[] generateData(DataSource[] dataSources, Object[] data) {
        if (data == null || data.length < dataSources.length) {
            data = new Object[dataSources.length];
        }
        for (int i = 0; i < dataSources.length; ++i) {
            data[i] = dataSources[i].getData();
        }
        return data;
    }

    public static DataSource[] parse(List<String> sources) throws ArgumentException {
        Reject.ifNull(sources);
        DataSource[] dataSources = new DataSource[sources.size()];
        for (int i = 0; i < sources.size(); ++i) {
            int high;
            int low;
            int rparenPos;
            int commaPos;
            String dataSourceDef = sources.get(i);
            if (dataSourceDef.startsWith("rand(") && dataSourceDef.endsWith(")")) {
                int lparenPos = dataSourceDef.indexOf("(");
                commaPos = dataSourceDef.indexOf(",");
                rparenPos = dataSourceDef.indexOf(")");
                if (commaPos < 0) {
                    try {
                        dataSources[i] = new DataSource(new RandomLineFileDataSource(0L, dataSourceDef.substring(lparenPos + 1, rparenPos)));
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new ArgumentException(LocalizableMessage.raw((CharSequence)"Error opening file %s: %s", (Object[])new Object[]{dataSourceDef.substring(lparenPos + 1, rparenPos), ioe.getMessage()}), (Throwable)ioe);
                    }
                    catch (Exception e) {
                        throw new ArgumentException(LocalizableMessage.raw((CharSequence)"Error parsing value generator: %s", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                    }
                }
                try {
                    low = Integer.parseInt(dataSourceDef.substring(lparenPos + 1, commaPos));
                    high = Integer.parseInt(dataSourceDef.substring(commaPos + 1, rparenPos));
                    dataSources[i] = new DataSource(new RandomNumberDataSource(Thread.currentThread().getId(), low, high));
                    continue;
                }
                catch (Exception e) {
                    throw new ArgumentException(LocalizableMessage.raw((CharSequence)"Error parsing value generator: %s", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
            if (dataSourceDef.startsWith("randstr(") && dataSourceDef.endsWith(")")) {
                int lparenPos = dataSourceDef.indexOf("(");
                commaPos = dataSourceDef.indexOf(",");
                rparenPos = dataSourceDef.indexOf(")");
                try {
                    String charSet;
                    int length;
                    if (commaPos < 0) {
                        length = Integer.parseInt(dataSourceDef.substring(lparenPos + 1, rparenPos));
                        charSet = "[A-Z][a-z][0-9]";
                    } else {
                        length = Integer.parseInt(dataSourceDef.substring(lparenPos + 1, commaPos));
                        charSet = dataSourceDef.substring(commaPos + 1, rparenPos);
                    }
                    dataSources[i] = new DataSource(new RandomStringDataSource(0, length, charSet));
                    continue;
                }
                catch (Exception e) {
                    throw new ArgumentException(LocalizableMessage.raw((CharSequence)"Error parsing value generator: %s", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
            if (dataSourceDef.startsWith("inc(") && dataSourceDef.endsWith(")")) {
                int lparenPos = dataSourceDef.indexOf("(");
                commaPos = dataSourceDef.indexOf(",");
                rparenPos = dataSourceDef.indexOf(")");
                if (commaPos < 0) {
                    try {
                        dataSources[i] = new DataSource(new IncrementLineFileDataSource(dataSourceDef.substring(lparenPos + 1, rparenPos)));
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new ArgumentException(LocalizableMessage.raw((CharSequence)"Error opening file %s: %s", (Object[])new Object[]{dataSourceDef.substring(lparenPos + 1, rparenPos), ioe.getMessage()}), (Throwable)ioe);
                    }
                    catch (Exception e) {
                        throw new ArgumentException(LocalizableMessage.raw((CharSequence)"Error parsing value generator: %s", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                    }
                }
                try {
                    low = Integer.parseInt(dataSourceDef.substring(lparenPos + 1, commaPos));
                    high = Integer.parseInt(dataSourceDef.substring(commaPos + 1, rparenPos));
                    dataSources[i] = new DataSource(new IncrementNumberDataSource(low, high));
                    continue;
                }
                catch (Exception e) {
                    throw new ArgumentException(LocalizableMessage.raw((CharSequence)"Error parsing value generator: %s", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
            try {
                dataSources[i] = new DataSource(new StaticDataSource(Integer.parseInt(dataSourceDef)));
                continue;
            }
            catch (NumberFormatException nfe) {
                dataSources[i] = new DataSource(new StaticDataSource(dataSourceDef));
            }
        }
        return dataSources;
    }

    public static LocalizableMessage getUsage() {
        StringBuilder builder = new StringBuilder();
        builder.append((CharSequence)IncrementLineFileDataSource.getUsage());
        builder.append(StaticUtils.EOL);
        builder.append((CharSequence)IncrementNumberDataSource.getUsage());
        builder.append(StaticUtils.EOL);
        builder.append((CharSequence)RandomLineFileDataSource.getUsage());
        builder.append(StaticUtils.EOL);
        builder.append((CharSequence)RandomNumberDataSource.getUsage());
        builder.append(StaticUtils.EOL);
        builder.append((CharSequence)RandomStringDataSource.getUsage());
        return LocalizableMessage.raw((CharSequence)builder.toString(), (Object[])new Object[0]);
    }

    private DataSource(IDataSource impl) {
        this.impl = impl;
    }

    public DataSource duplicate() {
        IDataSource dup = this.impl.duplicate();
        if (dup == this.impl) {
            return this;
        }
        return new DataSource(dup);
    }

    public Object getData() {
        return this.impl.getData();
    }

    private static final class StaticDataSource
    implements IDataSource {
        private final Object data;

        private StaticDataSource(Object data) {
            this.data = data;
        }

        @Override
        public IDataSource duplicate() {
            return this;
        }

        @Override
        public Object getData() {
            return this.data;
        }
    }

    private static final class RandomStringDataSource
    implements IDataSource {
        private final Random random;
        private final int length;
        private final Character[] charSet;

        private RandomStringDataSource(int seed, int length, String charSet) {
            this.length = length;
            HashSet<Character> chars = new HashSet<Character>();
            for (int i = 0; i < charSet.length(); ++i) {
                char c = charSet.charAt(i);
                if (c == '[') {
                    int start = charSet.charAt(++i);
                    char end = charSet.charAt(i += 2);
                    ++i;
                    for (int j = start; j <= end; ++j) {
                        chars.add(Character.valueOf((char)j));
                    }
                    continue;
                }
                chars.add(Character.valueOf(c));
            }
            this.charSet = chars.toArray(new Character[chars.size()]);
            this.random = new Random(seed);
        }

        @Override
        public IDataSource duplicate() {
            return this;
        }

        @Override
        public Object getData() {
            char[] str = new char[this.length];
            for (int i = 0; i < this.length; ++i) {
                str[i] = this.charSet[this.random.nextInt(this.charSet.length)].charValue();
            }
            return new String(str);
        }

        public static LocalizableMessage getUsage() {
            return LocalizableMessage.raw((CharSequence)"\"randstr({length},_charSet_)\" Random string of specified length and optionally from characters in the charSet string. A range of character can be specified with [start-end] charSet notation. If no charSet is specified, the default charSet of [A-Z][a-z][0-9] will be used", (Object[])new Object[0]);
        }
    }

    private static class RandomNumberDataSource
    implements IDataSource {
        private final Random random;
        private final int offset;
        private final int range;

        public RandomNumberDataSource(long seed, int low, int high) {
            this.random = new Random(seed);
            this.offset = low;
            this.range = high - low;
        }

        @Override
        public IDataSource duplicate() {
            return this;
        }

        @Override
        public Object getData() {
            return this.random.nextInt(this.range) + this.offset;
        }

        public static LocalizableMessage getUsage() {
            return LocalizableMessage.raw((CharSequence)"\"rand({min},{max})\" Random number", (Object[])new Object[0]);
        }
    }

    private static class RandomLineFileDataSource
    implements IDataSource {
        private final List<String> lines = new ArrayList<String>();
        private final Random random;

        public RandomLineFileDataSource(long seed, String file) throws IOException {
            this.random = new Random(seed);
            try (BufferedReader in = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = in.readLine()) != null) {
                    this.lines.add(line);
                }
            }
        }

        @Override
        public IDataSource duplicate() {
            return this;
        }

        @Override
        public Object getData() {
            return this.lines.get(this.random.nextInt(this.lines.size()));
        }

        public static LocalizableMessage getUsage() {
            return LocalizableMessage.raw((CharSequence)"\"rand({filename})\" Random line from file", (Object[])new Object[0]);
        }
    }

    private static class IncrementNumberDataSource
    implements IDataSource {
        private final int low;
        private int next;
        private final int high;

        public IncrementNumberDataSource(int low, int high) {
            this.low = this.next = low;
            this.high = high;
        }

        @Override
        public IDataSource duplicate() {
            return new IncrementNumberDataSource(this.low, this.high);
        }

        @Override
        public Object getData() {
            if (this.next == this.high) {
                this.next = this.low;
                return this.high;
            }
            return this.next++;
        }

        public static LocalizableMessage getUsage() {
            return LocalizableMessage.raw((CharSequence)"\"inc({min},{max})\" Consecutive, incremental number", (Object[])new Object[0]);
        }
    }

    private static class IncrementLineFileDataSource
    implements IDataSource {
        private final List<String> lines;
        private int next;

        public IncrementLineFileDataSource(String file) throws IOException {
            this.lines = new ArrayList<String>();
            try (BufferedReader in = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = in.readLine()) != null) {
                    this.lines.add(line);
                }
            }
        }

        private IncrementLineFileDataSource(List<String> lines) {
            this.lines = lines;
        }

        @Override
        public IDataSource duplicate() {
            return new IncrementLineFileDataSource(this.lines);
        }

        @Override
        public Object getData() {
            if (this.next == this.lines.size()) {
                this.next = 0;
            }
            return this.lines.get(this.next++);
        }

        public static LocalizableMessage getUsage() {
            return LocalizableMessage.raw((CharSequence)"\"inc({filename})\" Consecutive, incremental line from file", (Object[])new Object[0]);
        }
    }

    private static interface IDataSource {
        public IDataSource duplicate();

        public Object getData();
    }
}

