/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.RatioGauge;
import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.MultiColumnPrinter;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.DataSource;
import com.forgerock.opendj.ldap.tools.LDAPToolArgumentParser;
import com.forgerock.opendj.ldap.tools.MakeLDIF;
import com.forgerock.opendj.ldap.tools.PerformanceRunner;
import com.forgerock.opendj.ldap.tools.PerformanceRunnerOptions;
import com.forgerock.opendj.ldap.tools.StatsThread;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldif.EntryGenerator;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

public class AddRate
extends ConsoleApplication {
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int DEFAULT_SIZE_THRESHOLD = 10000;
    private static final int AGE_THRESHOLD_LOWERBOUND = 1;
    private static final int SIZE_THRESHOLD_LOWERBOUND = 1;
    private BooleanArgument verbose;
    private BooleanArgument scriptFriendly;

    public static void main(String[] args) {
        int retCode = new AddRate().run(args);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private AddRate() {
    }

    AddRate(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendly.isPresent();
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    int run(String[] args) {
        ConnectionFactory connectionFactory;
        BooleanArgument noPurgeArgument;
        IntegerArgument deleteAgeThreshold;
        IntegerArgument deleteSizeThreshold;
        MultiChoiceArgument deleteMode;
        StringArgument constantsArg;
        IntegerArgument randomSeedArg;
        StringArgument resourcePathArg;
        AddPerformanceRunner runner;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_ADDRATE_TOOL_DESCRIPTION.get();
        LDAPToolArgumentParser argParser = LDAPToolArgumentParser.builder(AddRate.class.getName()).toolDescription(toolDescription).trailingArguments(1, "template-file-path").build();
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_ADDRATE.get());
        argParser.setDocToolDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_RATE_TOOLS.get());
        try {
            Utils.setDefaultPerfToolProperties();
            PerformanceRunnerOptions options = new PerformanceRunnerOptions(argParser, this);
            options.setSupportsGeneratorArgument(false);
            connectionFactoryProvider = new ConnectionFactoryProvider((ArgumentParser)argParser, (ConsoleApplication)this);
            runner = new AddPerformanceRunner(options);
            this.addCommonArguments(argParser);
            resourcePathArg = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"resourcePath").shortIdentifier(Character.valueOf('r'))).description(ToolsMessages.INFO_ADDRATE_DESCRIPTION_RESOURCE_PATH.get())).docDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_RESOURCE_PATH.get())).valuePlaceholder(ToolsMessages.INFO_PATH_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            randomSeedArg = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"randomSeed").shortIdentifier(Character.valueOf('R'))).description(ToolsMessages.INFO_ADDRATE_DESCRIPTION_SEED.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_SEED_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            constantsArg = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"constant").shortIdentifier(Character.valueOf('g'))).description(ToolsMessages.INFO_ADDRATE_DESCRIPTION_CONSTANT.get())).multiValued()).valuePlaceholder(ToolsMessages.INFO_CONSTANT_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            deleteMode = (MultiChoiceArgument)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)MultiChoiceArgument.builder((String)"deleteMode").shortIdentifier(Character.valueOf('C'))).description(ToolsMessages.INFO_ADDRATE_DESCRIPTION_DELETEMODE.get())).allowedValues((Object[])DeleteStrategy.values()).defaultValue((Object)DeleteStrategy.FIFO)).valuePlaceholder(ToolsMessages.INFO_DELETEMODE_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            deleteSizeThreshold = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"deleteSizeThreshold").shortIdentifier(Character.valueOf('s'))).description(ToolsMessages.INFO_ADDRATE_DESCRIPTION_DELETESIZETHRESHOLD.get())).lowerBound(1).defaultValue((Object)10000)).valuePlaceholder(ToolsMessages.INFO_DELETESIZETHRESHOLD_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            deleteAgeThreshold = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"deleteAgeThreshold").shortIdentifier(Character.valueOf('a'))).description(ToolsMessages.INFO_ADDRATE_DESCRIPTION_DELETEAGETHRESHOLD.get())).lowerBound(1).valuePlaceholder(ToolsMessages.INFO_DELETEAGETHRESHOLD_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            noPurgeArgument = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"noPurge").shortIdentifier(Character.valueOf('n'))).description(ToolsMessages.INFO_ADDRATE_DESCRIPTION_NOPURGE.get())).buildAndAddToParser((ArgumentParser)argParser);
        }
        catch (ArgumentException ae) {
            this.errPrintln(ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            argParser.parseArguments(args);
            if (argParser.usageOrVersionDisplayed()) {
                return 0;
            }
            connectionFactory = connectionFactoryProvider.getAuthenticatedConnectionFactory();
            runner.setBindRequest(connectionFactoryProvider.getBindRequest());
            runner.validate((MultiChoiceArgument<DeleteStrategy>)deleteMode, deleteSizeThreshold, deleteAgeThreshold, noPurgeArgument);
        }
        catch (ArgumentException ae) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        String templatePath = (String)argParser.getTrailingArguments().get(0);
        runner.generator = MakeLDIF.createGenerator(templatePath, resourcePathArg, randomSeedArg, constantsArg, false, this);
        if (runner.generator == null) {
            return ResultCode.OPERATIONS_ERROR.intValue();
        }
        Runtime.getRuntime().addShutdownHook(runner.newPurgerThread());
        return runner.run(connectionFactory);
    }

    private void addCommonArguments(ArgumentParser argParser) throws ArgumentException {
        StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
        argParser.addArgument((Argument)propertiesFileArgument);
        argParser.setFilePropertiesArgument(propertiesFileArgument);
        BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
        argParser.addArgument((Argument)noPropertiesFileArgument);
        argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
        BooleanArgument showUsage = CommonArguments.showUsageArgument();
        argParser.addArgument((Argument)showUsage);
        argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
        this.verbose = CommonArguments.verboseArgument();
        argParser.addArgument((Argument)this.verbose);
        this.scriptFriendly = CommonArguments.scriptFriendlySdkArgument();
        argParser.addArgument((Argument)this.scriptFriendly);
    }

    private static enum DeleteThreshold {
        SIZE_THRESHOLD,
        AGE_THRESHOLD,
        OFF;

    }

    private static enum DeleteStrategy {
        OFF,
        RANDOM,
        FIFO;

    }

    private final class AddPerformanceRunner
    extends PerformanceRunner {
        private final ConcurrentSkipListMap<Long, String> dnEntriesAdded;
        private final ThreadLocal<Random> randomSeq;
        private EntryGenerator generator;
        private DeleteStrategy delStrategy;
        private DeleteThreshold delThreshold;
        private long sizeThreshold;
        private volatile boolean toggleDelete;
        private long timeToWait;
        private int maxNbAddIterations;
        private boolean purgeEnabled;
        private StatsThread.IntervalCounter addCounter;
        private StatsThread.IntervalCounter deleteCounter;
        private final Counter entryCount;
        private final AtomicBoolean isPurgeBranchRunning;

        private AddPerformanceRunner(PerformanceRunnerOptions options) throws ArgumentException {
            super(options);
            this.dnEntriesAdded = new ConcurrentSkipListMap();
            this.randomSeq = new ThreadLocal<Random>(){

                @Override
                protected Random initialValue() {
                    return new Random();
                }
            };
            this.addCounter = StatsThread.newIntervalCounter();
            this.deleteCounter = StatsThread.newIntervalCounter();
            this.entryCount = new Counter();
            this.isPurgeBranchRunning = new AtomicBoolean();
        }

        @Override
        PerformanceRunner.WorkerThread newWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
            return new AddDeleteWorkerThread(connection, connectionFactory);
        }

        @Override
        StatsThread newStatsThread(PerformanceRunner performanceRunner, ConsoleApplication app) {
            return new AddRateStatsThread(performanceRunner, app);
        }

        @Override
        PerformanceRunner.TimerThread newEndTimerThread(long timeToWait) {
            return new AddRateTimerThread(timeToWait);
        }

        PerformanceRunner.TimerThread newPurgerThread() {
            return this.newEndTimerThread(0L);
        }

        public void validate(MultiChoiceArgument<DeleteStrategy> delModeArg, IntegerArgument delSizeThresholdArg, IntegerArgument delAgeThresholdArg, BooleanArgument noPurgeArgument) throws ArgumentException {
            super.validate();
            this.delStrategy = (DeleteStrategy)((Object)delModeArg.getTypedValue());
            this.maxNbAddIterations = this.maxIterationsArgument.getIntValue();
            boolean bl = this.purgeEnabled = !noPurgeArgument.isPresent();
            if (delSizeThresholdArg.isPresent() && delAgeThresholdArg.isPresent()) {
                throw new ArgumentException(ToolsMessages.ERR_ADDRATE_THRESHOLD_SIZE_AND_AGE.get());
            }
            if (this.delStrategy == DeleteStrategy.OFF && (delSizeThresholdArg.isPresent() || delAgeThresholdArg.isPresent())) {
                throw new ArgumentException(ToolsMessages.ERR_ADDRATE_DELMODE_OFF_THRESHOLD_ON.get());
            }
            if (this.delStrategy == DeleteStrategy.RANDOM && delAgeThresholdArg.isPresent()) {
                throw new ArgumentException(ToolsMessages.ERR_ADDRATE_DELMODE_RAND_THRESHOLD_AGE.get());
            }
            if (this.delStrategy != DeleteStrategy.OFF) {
                DeleteThreshold deleteThreshold = this.delThreshold = delAgeThresholdArg.isPresent() ? DeleteThreshold.AGE_THRESHOLD : DeleteThreshold.SIZE_THRESHOLD;
                if (this.delThreshold == DeleteThreshold.SIZE_THRESHOLD) {
                    this.setSizeThreshold(delSizeThresholdArg.getIntValue());
                    if (0 < this.maxNbAddIterations && (long)this.maxNbAddIterations < this.sizeThreshold) {
                        throw new ArgumentException(ToolsMessages.ERR_ADDRATE_SIZE_THRESHOLD_LOWER_THAN_ITERATIONS.get());
                    }
                } else {
                    this.timeToWait = TimeUnit.NANOSECONDS.convert(delAgeThresholdArg.getIntValue(), TimeUnit.SECONDS);
                }
            }
        }

        private void setSizeThreshold(long entriesSizeThreshold) {
            this.sizeThreshold = entriesSizeThreshold;
            this.toggleDelete = true;
        }

        private final class AddRateTimerThread
        extends PerformanceRunner.TimerThread {
            private AddRateTimerThread(long timeToWait) {
                super(AddPerformanceRunner.this, timeToWait);
            }

            @Override
            void performStopOperations() {
                if (AddPerformanceRunner.this.purgeEnabled && AddPerformanceRunner.this.isPurgeBranchRunning.compareAndSet(false, true)) {
                    if (!AddRate.this.isScriptFriendly()) {
                        AddRate.this.println(LocalizableMessage.raw((CharSequence)"Purge phase...", (Object[])new Object[0]));
                    }
                    try {
                        AddPerformanceRunner.this.joinAllWorkerThreads();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException();
                    }
                } else if (!AddPerformanceRunner.this.purgeEnabled) {
                    AddPerformanceRunner.this.stopTool();
                }
            }
        }

        private final class AddDeleteWorkerThread
        extends PerformanceRunner.WorkerThread {
            private AddDeleteWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
                super(AddPerformanceRunner.this, connection, connectionFactory);
            }

            @Override
            public Promise<?, LdapException> performOperation(Connection connection, DataSource[] dataSources, long currentTimeNs) {
                this.startPurgeIfMaxNumberAddReached();
                this.startToggleDeleteIfAgeThresholdReached(currentTimeNs);
                try {
                    String entryToRemove = this.getEntryToRemove();
                    if (entryToRemove != null) {
                        return this.doDelete(connection, currentTimeNs, entryToRemove);
                    }
                    return this.doAdd(connection, currentTimeNs);
                }
                catch (AddRateExecutionEndedException a) {
                    return Promises.newResultPromise((Object)ResultCode.OTHER);
                }
                catch (IOException e) {
                    return Promises.newExceptionPromise((Exception)((Object)LdapException.newLdapException((ResultCode)ResultCode.OTHER, (Throwable)e)));
                }
            }

            private void startToggleDeleteIfAgeThresholdReached(long currentTime) {
                if (!AddPerformanceRunner.this.toggleDelete && AddPerformanceRunner.this.delThreshold == DeleteThreshold.AGE_THRESHOLD && !AddPerformanceRunner.this.dnEntriesAdded.isEmpty() && (Long)AddPerformanceRunner.this.dnEntriesAdded.firstKey() + AddPerformanceRunner.this.timeToWait < currentTime) {
                    AddPerformanceRunner.this.setSizeThreshold(AddPerformanceRunner.this.entryCount.getCount());
                }
            }

            private void startPurgeIfMaxNumberAddReached() {
                AtomicBoolean purgeLatch = new AtomicBoolean();
                if (!AddPerformanceRunner.this.isPurgeBranchRunning.get() && 0 < AddPerformanceRunner.this.maxNbAddIterations && (long)AddPerformanceRunner.this.maxNbAddIterations < AddPerformanceRunner.this.addCounter.getCount() && purgeLatch.compareAndSet(false, true)) {
                    AddPerformanceRunner.this.newPurgerThread().start();
                }
            }

            private String getEntryToRemove() throws AddRateExecutionEndedException {
                if (AddPerformanceRunner.this.isPurgeBranchRunning.get()) {
                    return this.purgeEntry();
                }
                if (AddPerformanceRunner.this.toggleDelete && AddPerformanceRunner.this.entryCount.getCount() > AddPerformanceRunner.this.sizeThreshold) {
                    return this.removeFirstAddedEntry();
                }
                return null;
            }

            private String purgeEntry() throws AddRateExecutionEndedException {
                if (!AddPerformanceRunner.this.dnEntriesAdded.isEmpty()) {
                    return this.removeFirstAddedEntry();
                }
                this.localStopRequested = true;
                throw new AddRateExecutionEndedException();
            }

            private String removeFirstAddedEntry() {
                Map.Entry entry = AddPerformanceRunner.this.dnEntriesAdded.pollFirstEntry();
                return entry != null ? (String)entry.getValue() : null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Promise<Result, LdapException> doAdd(Connection connection, long currentTime) throws IOException {
                Entry entry;
                EntryGenerator entryGenerator = AddPerformanceRunner.this.generator;
                synchronized (entryGenerator) {
                    entry = AddPerformanceRunner.this.generator.readEntry();
                }
                AddStatsHandler addHandler = new AddStatsHandler(currentTime, entry.getName().toString());
                return connection.addAsync(Requests.newAddRequest((Entry)entry)).thenOnResultOrException((ResultHandler)addHandler, (ExceptionHandler)addHandler);
            }

            private Promise<?, LdapException> doDelete(Connection connection, long currentTime, String entryToRemove) {
                DeleteStatsHandler deleteHandler = new DeleteStatsHandler(currentTime);
                return connection.deleteAsync(Requests.newDeleteRequest((String)entryToRemove)).thenOnResultOrException((ResultHandler)deleteHandler, (ExceptionHandler)deleteHandler);
            }
        }

        private final class AddRateStatsThread
        extends StatsThread {
            private static final int PERCENTAGE_ADD_COLUMN_WIDTH = 6;
            private static final String PERCENTAGE_ADD = "org.forgerock.opendj.add_percentage";

            private AddRateStatsThread(PerformanceRunner perfRunner, ConsoleApplication app) {
                super(perfRunner, app);
            }

            @Override
            void resetAdditionalStats() {
                AddPerformanceRunner.this.addCounter = AddRateStatsThread.newIntervalCounter();
                AddPerformanceRunner.this.deleteCounter = AddRateStatsThread.newIntervalCounter();
            }

            @Override
            List<MultiColumnPrinter.Column> registerAdditionalColumns() {
                this.registry.register(PERCENTAGE_ADD, (Metric)new RatioGauge(){

                    protected RatioGauge.Ratio getRatio() {
                        long addIntervalCount = AddPerformanceRunner.this.addCounter.refreshIntervalCount();
                        long deleteIntervalCount = AddPerformanceRunner.this.deleteCounter.refreshIntervalCount();
                        return RatioGauge.Ratio.of((double)(addIntervalCount * 100L), (double)(addIntervalCount + deleteIntervalCount));
                    }
                });
                return Collections.singletonList(MultiColumnPrinter.column((String)PERCENTAGE_ADD, (String)"Add%", (int)6, (int)2));
            }
        }

        private final class DeleteStatsHandler
        extends PerformanceRunner.UpdateStatsResultHandler<Result> {
            private DeleteStatsHandler(long startTime) {
                super(AddPerformanceRunner.this, startTime);
            }

            @Override
            void updateAdditionalStatsOnResult() {
                AddPerformanceRunner.this.deleteCounter.inc();
                AddPerformanceRunner.this.entryCount.dec();
            }
        }

        private final class AddStatsHandler
        extends PerformanceRunner.UpdateStatsResultHandler<Result> {
            private final String entryDN;

            private AddStatsHandler(long currentTime, String entryDN) {
                super(AddPerformanceRunner.this, currentTime);
                this.entryDN = entryDN;
            }

            @Override
            void updateAdditionalStatsOnResult() {
                switch (AddPerformanceRunner.this.delStrategy) {
                    case RANDOM: {
                        long newKey;
                        do {
                            newKey = ((Random)AddPerformanceRunner.this.randomSeq.get()).nextInt();
                        } while (AddPerformanceRunner.this.dnEntriesAdded.putIfAbsent(newKey, this.entryDN) != null);
                        break;
                    }
                    case FIFO: {
                        long uniqueTime = this.operationStartTimeNs;
                        while (AddPerformanceRunner.this.dnEntriesAdded.putIfAbsent(uniqueTime, this.entryDN) != null) {
                            ++uniqueTime;
                        }
                        break;
                    }
                }
                AddPerformanceRunner.this.addCounter.inc();
                AddPerformanceRunner.this.entryCount.inc();
            }
        }
    }

    private static final class AddRateExecutionEndedException
    extends LdapException {
        private AddRateExecutionEndedException() {
            super(Responses.newResult((ResultCode)ResultCode.OTHER));
        }
    }
}

