/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.server.config.server.SNMPConnectionHandlerCfg;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ServerContext;
import org.opends.server.snmp.SNMPClassLoaderProvider;
import org.opends.server.types.HostPort;
import org.opends.server.types.InitializationException;

public final class SNMPConnectionHandler
extends ConnectionHandler<SNMPConnectionHandlerCfg>
implements ConfigurationChangeListener<SNMPConnectionHandlerCfg>,
AlertGenerator {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    SNMPConnectionHandlerCfg currentConfig;
    private LinkedList<ClientConnection> connectionList;
    private LinkedList<HostPort> listeners = new LinkedList();
    private SNMPClassLoaderProvider provider;
    private boolean isOperational = false;

    public SNMPConnectionHandler() {
        super("SNMPConnectionHandler");
        this.connectionList = new LinkedList();
    }

    public void initializeConnectionHandler(ServerContext serverContext, SNMPConnectionHandlerCfg configuration) throws ConfigException, InitializationException {
        if (configuration == null) {
            logger.error(ProtocolMessages.ERR_SNMP_CONNHANDLER_NO_CONFIGURATION);
            return;
        }
        this.currentConfig = configuration;
        String jarLocation = this.currentConfig.getOpendmkJarfile();
        if (jarLocation == null || jarLocation.length() == 0) {
            logger.error(ProtocolMessages.ERR_SNMP_CONNHANDLER_NO_OPENDMK_JARFILES);
            return;
        }
        File jarFile = new File(jarLocation);
        File fullpathFile = !jarFile.isAbsolute() ? new File(DirectoryServer.getServerRoot(), this.currentConfig.getOpendmkJarfile()) : new File(this.currentConfig.getOpendmkJarfile());
        if (!fullpathFile.exists()) {
            logger.error(ProtocolMessages.ERR_SNMP_CONNHANDLER_OPENDMK_JARFILES_DOES_NOT_EXIST, (Object)fullpathFile.getAbsolutePath());
            return;
        }
        this.listeners.clear();
        this.listeners.add(new HostPort("0.0.0.0", this.currentConfig.getListenPort()));
        if (!this.isOperational(fullpathFile)) {
            logger.error(ProtocolMessages.ERR_SNMP_CONNHANDLER_OPENDMK_JARFILES_NOT_OPERATIONAL, (Object)fullpathFile.getAbsolutePath());
            return;
        }
        this.provider = new SNMPClassLoaderProvider();
        try {
            this.provider.initializeConnectionHandler(this.currentConfig);
        }
        catch (Exception ex) {
            logger.error(ProtocolMessages.ERR_SNMP_CONNHANDLER_BAD_CONFIGURATION);
            return;
        }
    }

    public String getConnectionHandlerName() {
        return "SNMP Connection Handler";
    }

    public String getProtocol() {
        return "SNMP";
    }

    public Collection<HostPort> getListeners() {
        return this.listeners;
    }

    public Collection<ClientConnection> getClientConnections() {
        return this.connectionList;
    }

    public void run() {
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SNMPConnectionHandler");
    }

    public boolean isConfigurationChangeAcceptable(SNMPConnectionHandlerCfg configuration, List<LocalizableMessage> unacceptableReasons) {
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(SNMPConnectionHandlerCfg configuration) {
        if (this.isOperational && this.provider != null) {
            return this.provider.applyConfigurationChange(configuration);
        }
        return null;
    }

    public DN getComponentEntryDN() {
        return this.currentConfig.dn();
    }

    public String getClassName() {
        return SNMPConnectionHandler.class.getName();
    }

    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        return alerts;
    }

    private void addFile(File file) {
        try {
            String url = "jar:" + file.toURI().toURL() + "!/";
            URL u = new URL(url);
            URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initSnmpClasses() {
        try {
            URLClassLoader opendsLoader = (URLClassLoader)DirectoryServer.getClassLoader();
            Class.forName("com.sun.management.comm.SnmpV3AdaptorServer", true, opendsLoader);
            Class.forName("com.sun.management.snmp.InetAddressAcl", true, opendsLoader);
            Class.forName("com.sun.management.snmp.SnmpEngineParameters", true, opendsLoader);
            Class.forName("com.sun.management.snmp.UserAcl", true, opendsLoader);
            this.isOperational = true;
        }
        catch (ClassNotFoundException ex) {
            this.isOperational = false;
        }
    }

    public boolean isOperational(File file) {
        this.addFile(file);
        this.initSnmpClasses();
        return this.isOperational;
    }

    public boolean isOperational() {
        return this.isOperational;
    }

    public void finalizeConnectionHandler(LocalizableMessage finalizeReason) {
        if (this.provider != null) {
            this.provider.finalizeConnectionHandler();
        }
    }
}

