/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.snmp;

import com.sun.management.snmp.agent.SnmpMib;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.server.snmp.DsEntry;
import org.opends.server.snmp.DsTableEntry;
import org.opends.server.snmp.SNMPMonitor;

public class DsTableEntryImpl
extends DsTableEntry
implements DsEntry {
    private static final long serialVersionUID = -3346380035687141480L;
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private MBeanServer server;
    private SNMPMonitor monitor;
    private ObjectName entryName;
    private Integer applIndex;

    public DsTableEntryImpl(SnmpMib mib, MBeanServer server, int index) {
        super(mib);
        this.server = server;
        this.monitor = SNMPMonitor.getMonitor(server);
        this.applIndex = new Integer(index);
    }

    @Override
    public Byte[] getDsServerType() {
        try {
            String value1 = (String)this.monitor.getAttribute("rootDSE,Rdn1=cn-monitor,Rdn2=cn-Version", "fullVersion");
            String value2 = (String)this.monitor.getAttribute("rootDSE,Rdn1=cn-monitor,Rdn2=cn-Version", "buildID");
            return SNMPMonitor.string2ByteArray(value1 + " - " + value2);
        }
        catch (Exception ex) {
            logger.traceException((Throwable)ex);
            return null;
        }
    }

    @Override
    public Long getDsCacheHits() {
        try {
            Long value = Long.parseLong((String)this.monitor.getAttribute("rootDSE,Rdn1=cn-monitor,Rdn2=cn-Entry_Caches", "entryCacheHits"));
            return SNMPMonitor.counter32Value(value);
        }
        catch (Exception ex) {
            logger.traceException((Throwable)ex);
            return 0L;
        }
    }

    @Override
    public Long getDsCacheEntries() {
        try {
            Long value = Long.parseLong((String)this.monitor.getAttribute("rootDSE,Rdn1=cn-monitor,Rdn2=cn-Entry_Caches", "currentEntryCacheCount"));
            return SNMPMonitor.gauge32Value(value);
        }
        catch (Exception ex) {
            logger.traceException((Throwable)ex);
            return 0L;
        }
    }

    @Override
    public Long getDsMasterEntries() {
        Set<ObjectName> monitorBackends = null;
        Long result = 0L;
        try {
            monitorBackends = this.server.queryNames(SNMPMonitor.pattern, null);
            for (ObjectName name : monitorBackends) {
                Object value = this.monitor.getAttribute(name, "ds-backend-entry-count");
                if (value == null) continue;
                result = result + new Long((String)value);
            }
            return SNMPMonitor.gauge32Value(result);
        }
        catch (Exception ex) {
            logger.traceException((Throwable)ex);
            return 0L;
        }
    }

    @Override
    public String getDsServerDescription() {
        return Utilities.getServerRootDirectory().getAbsolutePath();
    }

    @Override
    public ObjectName getObjectName() {
        if (this.entryName == null) {
            try {
                this.entryName = new ObjectName("org.opends.server.snmp:type=DsTableEntry,name=rootDSE,Rdn1=cn-monitor,Rdn2=cn-System_Information");
            }
            catch (Exception ex) {
                logger.traceException((Throwable)ex);
            }
        }
        return this.entryName;
    }
}

