/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.rest2ldap.AuthenticatedConnectionContext;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

final class DirectConnectionFilter
implements Filter {
    private final ConnectionFactory connectionFactory;

    public DirectConnectionFilter(ConnectionFactory connectionFactory) {
        this.connectionFactory = (ConnectionFactory)Reject.checkNotNull((Object)connectionFactory, (String)"connectionFactory cannot be null");
    }

    public Promise<Response, NeverThrowsException> filter(final Context context, final Request request, final Handler next) {
        final AtomicReference connectionHolder = new AtomicReference();
        return this.connectionFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(Connection connection) {
                connectionHolder.set(connection);
                return next.handle((Context)new AuthenticatedConnectionContext(context, connection), request);
            }
        }, Utils.handleConnectionFailure()).thenFinally(Utils.close(connectionHolder));
    }
}

