/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.http.oauth2.AccessTokenException;
import org.forgerock.http.oauth2.AccessTokenInfo;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.http.util.Json;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

final class CtsAccessTokenResolver
implements AccessTokenResolver {
    private static final Filter FR_CORE_TOKEN_OC_FILTER = Filter.equality((String)"objectclass", (Object)"frCoreToken");
    private final ConnectionFactory connectionFactory;
    private final DN ctsBaseDN;

    CtsAccessTokenResolver(ConnectionFactory connectionFactory, String ctsBaseDN) {
        this.connectionFactory = (ConnectionFactory)Reject.checkNotNull((Object)connectionFactory, (String)"connectionFactory cannot be null");
        this.ctsBaseDN = DN.valueOf((String)((String)Reject.checkNotNull((Object)ctsBaseDN, (String)"ctsBaseDN cannot be null")));
    }

    public Promise<AccessTokenInfo, AccessTokenException> resolve(Context context, final String token) {
        final AtomicReference connectionHolder = new AtomicReference();
        return this.connectionFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, SearchResultEntry, LdapException>(){

            public Promise<SearchResultEntry, LdapException> apply(Connection connection) throws LdapException {
                connectionHolder.set(connection);
                return connection.searchSingleEntryAsync(Requests.newSingleEntrySearchRequest((DN)CtsAccessTokenResolver.this.ctsBaseDN.child("coreTokenId", (Object)token), (SearchScope)SearchScope.BASE_OBJECT, (Filter)FR_CORE_TOKEN_OC_FILTER, (String[])new String[]{"coreTokenObject"}));
            }
        }).then((Function)new Function<SearchResultEntry, AccessTokenInfo, AccessTokenException>(){

            public AccessTokenInfo apply(SearchResultEntry entry) throws AccessTokenException {
                JsonValue accessToken = CtsAccessTokenResolver.this.parseJson(entry.getAttribute("coreTokenObject").firstValueAsString(), token);
                String tokenName = CtsAccessTokenResolver.this.getRequiredFirstValue(accessToken.get("tokenName"));
                if (!tokenName.equals("access_token")) {
                    throw Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_CTS_INVALID_TOKEN_TYPE.get((Object)token, (Object)tokenName));
                }
                return new AccessTokenInfo(accessToken, token, (Set)accessToken.get("scope").required().as(JsonValueFunctions.setOf(String.class)), Long.parseLong(CtsAccessTokenResolver.this.getRequiredFirstValue(accessToken.get("expireTime"))));
            }
        }, (Function)new Function<LdapException, AccessTokenInfo, AccessTokenException>(){

            public AccessTokenInfo apply(LdapException e) throws AccessTokenException {
                throw Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_CTS_TOKEN_NOT_FOUND.get((Object)token, (Object)e.getMessage()), (Exception)((Object)e));
            }
        }).thenCatchRuntimeException((Function)new Function<RuntimeException, AccessTokenInfo, AccessTokenException>(){

            public AccessTokenInfo apply(RuntimeException e) throws AccessTokenException {
                throw Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_CTS_TOKEN_RESOLUTION.get((Object)token, (Object)e.getMessage()), e);
            }
        }).thenFinally(Utils.close(connectionHolder));
    }

    private String getRequiredFirstValue(JsonValue list) {
        return (String)list.required().asList(String.class).get(0);
    }

    private JsonValue parseJson(String accessTokenJson, String token) throws AccessTokenException {
        try {
            return new JsonValue(Json.readJson((String)accessTokenJson));
        }
        catch (IOException e) {
            throw Utils.newAccessTokenException(Rest2ldapMessages.ERR_OAUTH2_CTS_INVALID_JSON_TOKEN.get((Object)token));
        }
    }
}

