/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class JsonConstantPropertyMapper
extends PropertyMapper {
    private final JsonValue value;

    JsonConstantPropertyMapper(Object value) {
        this.value = new JsonValue(value);
    }

    @Override
    boolean isRequired() {
        return false;
    }

    @Override
    boolean isMultiValued() {
        return false;
    }

    public String toString() {
        return "constant(" + this.value + ")";
    }

    @Override
    Promise<List<Attribute>, ResourceException> create(Context context, Resource resource, JsonPointer path, JsonValue v) {
        if (!Utils.isNullOrEmpty(v) && !v.getObject().equals(this.value.getObject())) {
            return Utils.newBadRequestException(Rest2ldapMessages.ERR_CREATION_READ_ONLY_FIELD.get((Object)path)).asPromise();
        }
        return Promises.newResultPromise(Collections.emptyList());
    }

    @Override
    void getLdapAttributes(JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
    }

    @Override
    Promise<Filter, ResourceException> getLdapFilter(Context context, Resource resource, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        return Promises.newResultPromise((Object)this.getLdapFilter0(subPath, type, valueAssertion));
    }

    private Filter getLdapFilter0(JsonPointer subPath, FilterType type, Object valueAssertion) {
        JsonValue subValue = this.value.get(subPath);
        if (subValue == null) {
            return Filter.alwaysFalse();
        }
        if (type == FilterType.PRESENT) {
            return Filter.alwaysTrue();
        }
        if (this.value.isString() && valueAssertion instanceof String) {
            String v1 = Utils.toLowerCase(this.value.asString());
            String v2 = Utils.toLowerCase((String)valueAssertion);
            switch (type) {
                case CONTAINS: {
                    return Utils.toFilter(v1.contains(v2));
                }
                case STARTS_WITH: {
                    return Utils.toFilter(v1.startsWith(v2));
                }
            }
            return this.compare(type, v1, v2);
        }
        if (this.value.isNumber() && valueAssertion instanceof Number) {
            Double v1 = this.value.asDouble();
            Double v2 = ((Number)valueAssertion).doubleValue();
            return this.compare(type, v1, v2);
        }
        if (this.value.isBoolean() && valueAssertion instanceof Boolean) {
            Boolean v1 = this.value.asBoolean();
            Boolean v2 = (Boolean)valueAssertion;
            return this.compare(type, v1, v2);
        }
        return Filter.alwaysFalse();
    }

    @Override
    Promise<List<Modification>, ResourceException> patch(Context context, Resource resource, JsonPointer path, PatchOperation operation) {
        return Utils.newBadRequestException(Rest2ldapMessages.ERR_PATCH_READ_ONLY_FIELD.get((Object)path)).asPromise();
    }

    @Override
    Promise<JsonValue, ResourceException> read(Context context, Resource resource, JsonPointer path, Entry e) {
        return Promises.newResultPromise((Object)this.value.copy());
    }

    @Override
    Promise<List<Modification>, ResourceException> update(Context context, Resource resource, JsonPointer path, Entry e, JsonValue v) {
        if (!Utils.isNullOrEmpty(v) && !v.getObject().equals(this.value.getObject())) {
            return Utils.newBadRequestException(Rest2ldapMessages.ERR_MODIFY_READ_ONLY_FIELD.get((Object)"update", (Object)path)).asPromise();
        }
        return Promises.newResultPromise(Collections.emptyList());
    }

    private <T extends Comparable<T>> Filter compare(FilterType type, T v1, T v2) {
        switch (type) {
            case EQUAL_TO: {
                return Utils.toFilter(v1.equals(v2));
            }
            case GREATER_THAN: {
                return Utils.toFilter(v1.compareTo(v2) > 0);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return Utils.toFilter(v1.compareTo(v2) >= 0);
            }
            case LESS_THAN: {
                return Utils.toFilter(v1.compareTo(v2) < 0);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return Utils.toFilter(v1.compareTo(v2) <= 0);
            }
        }
        return Filter.alwaysFalse();
    }

    @Override
    JsonValue toJsonSchema() {
        return JsonConstantPropertyMapper.toJsonSchema(this.value);
    }

    private static JsonValue toJsonSchema(JsonValue value) {
        if (value.isMap()) {
            JsonValue jsonSchema = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"object")}));
            JsonValue jsonProps = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));
            for (String key : value.keys()) {
                jsonProps.put(key, (Object)JsonConstantPropertyMapper.toJsonSchema(value.get(key)));
            }
            jsonSchema.put("properties", jsonProps.getObject());
            return jsonSchema;
        }
        if (value.isCollection()) {
            JsonValue jsonSchema = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"array")}));
            JsonValue firstItem = value.get((String)value.keys().iterator().next());
            JsonValue firstItemJson = JsonConstantPropertyMapper.toJsonSchema(firstItem);
            jsonSchema.put("items", firstItemJson != null ? firstItemJson.getObject() : null);
            if (value.getObject() instanceof Set) {
                jsonSchema.put("uniqueItems", (Object)true);
            }
            return jsonSchema;
        }
        if (value.isBoolean()) {
            return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"boolean"), JsonValue.field((String)"default", (Object)value)}));
        }
        if (value.isString()) {
            return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"string"), JsonValue.field((String)"default", (Object)value)}));
        }
        if (value.isNumber()) {
            return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"number"), JsonValue.field((String)"default", (Object)value)}));
        }
        if (value.isNull()) {
            return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"null")}));
        }
        throw new IllegalStateException("Unsupported json value: " + value);
    }
}

