/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.xml;

import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.forgerock.util.xml.XMLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class XMLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLUtils.class);
    private static final Object SECURITY_MANAGER;
    private static final Integer ENTITY_EXP_LIMIT;

    private XMLUtils() {
    }

    public static DocumentBuilder getSafeDocumentBuilder(boolean validating) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validating);
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        dbf.setExpandEntityReferences(false);
        if (SECURITY_MANAGER != null) {
            dbf.setAttribute("http://apache.org/xml/properties/security-manager", SECURITY_MANAGER);
        }
        try {
            dbf.setAttribute("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", ENTITY_EXP_LIMIT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(new XMLHandler());
        return db;
    }

    public static SAXParser getSafeSAXParser(boolean validating) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(validating);
        saxFactory.setNamespaceAware(true);
        saxFactory.setXIncludeAware(false);
        saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser sp = saxFactory.newSAXParser();
        if (SECURITY_MANAGER != null) {
            sp.setProperty("http://apache.org/xml/properties/security-manager", SECURITY_MANAGER);
        }
        try {
            sp.setProperty("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", ENTITY_EXP_LIMIT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sp.getXMLReader().setEntityResolver(new XMLHandler());
        return sp;
    }

    static {
        ENTITY_EXP_LIMIT = Integer.getInteger("org.forgerock.util.xml.entity.expansion.limit", 5000);
        Object securityManager = null;
        try {
            Class<?> securityManagerClass = Class.forName("org.apache.xerces.util.SecurityManager");
            securityManager = securityManagerClass.newInstance();
            Method setEntityExpansionLimit = securityManagerClass.getMethod("setEntityExpansionLimit", Integer.TYPE);
            setEntityExpansionLimit.invoke(securityManager, ENTITY_EXP_LIMIT);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.debug("Not using Xerces");
        }
        catch (Exception ex) {
            LOGGER.debug("Unable to set expansion limit for Xerces, using default settings", (Throwable)ex);
            securityManager = null;
        }
        SECURITY_MANAGER = securityManager;
    }
}

