/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openidm.accountchange;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.forgerock.http.Client;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.http.protocol.Form;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.spi.Loader;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.crypto.JsonCrypto;
import org.forgerock.json.crypto.JsonCryptoException;
import org.forgerock.json.crypto.JsonEncryptor;
import org.forgerock.json.crypto.simple.SimpleEncryptor;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.KeyManagers;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.server.config.server.AccountStatusNotificationHandlerCfg;
import org.forgerock.openidm.accountchange.OpenidmAccountStatusNotificationHandlerMessages;
import org.forgerock.openidm.accountchange.PersistedQueue;
import org.forgerock.openidm.accountchange.meta.OpenidmAccountStatusNotificationHandlerCfgDefn;
import org.forgerock.openidm.accountchange.server.OpenidmAccountStatusNotificationHandlerCfg;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationProperty;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class OpenidmAccountStatusNotificationHandler
extends AccountStatusNotificationHandler<OpenidmAccountStatusNotificationHandlerCfg>
implements ConfigurationChangeListener<OpenidmAccountStatusNotificationHandlerCfg>,
ServerShutdownListener {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final String THREADNAME = "OpenIDM AccountStatus Notification Handler Thread";
    private static final String ASYMMETRIC_CIPHER = "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    private static final byte PWD_CHANGED = 1;
    private static final byte PWD_RESET = 2;
    private String logFileName;
    private File logFile;
    private String hostname;
    private OpenidmAccountStatusNotificationHandlerCfg currentConfig;
    private long interval;
    private boolean stopRequested;
    private Thread backgroundThread;
    private PersistedQueue queue;
    private JsonEncryptor encryptor;
    private final ObjectMapper mapper = new ObjectMapper();
    private HttpClientHandler httpClientHandler;
    private Client client;
    private URI openidmURI;
    private OpenidmAccountStatusNotificationHandlerCfgDefn.OpenidmCompatMode compatMode;
    private static Loader serviceLoader = new Loader(){

        public <S> S load(Class<S> service, Options options) {
            ServiceLoader<S> loader = ServiceLoader.load(service, OpenidmAccountStatusNotificationHandler.class.getClassLoader());
            Iterator<S> i = loader.iterator();
            return i.hasNext() ? (S)i.next() : null;
        }
    };

    public void initializeStatusNotificationHandler(OpenidmAccountStatusNotificationHandlerCfg configuration) throws ConfigException, InitializationException {
        if (logger.isTraceEnabled()) {
            logger.trace("Start initialization of OpenIDM status notification handler");
        }
        this.currentConfig = configuration;
        this.currentConfig.addOpenidmChangeListener(this);
        try {
            this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            this.hostname = "UnknownHost";
        }
        this.logFileName = configuration.getLogFile();
        this.initializeLogFile(this.logFileName);
        try {
            this.initializeOpenIDMClient(configuration);
        }
        catch (DirectoryException ex) {
            throw new InitializationException(ex.getMessageObject(), (Throwable)ex);
        }
        this.interval = configuration.getUpdateInterval();
        if (this.interval > 0L) {
            this.queue = new PersistedQueue(StaticUtils.getFileForPath((String)this.currentConfig.getLogFile()), "OpenIDMSyncQueue", 10);
            this.initializeBackGroundProcessing();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Successfully finished initialization of OpenIDM status notification handler, using update interval: %s ms", (Object)this.getInterval());
        }
    }

    public boolean isConfigurationAcceptable(AccountStatusNotificationHandlerCfg configuration, List<LocalizableMessage> unacceptableReasons) {
        OpenidmAccountStatusNotificationHandlerCfg config = (OpenidmAccountStatusNotificationHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    public boolean isConfigurationChangeAcceptable(OpenidmAccountStatusNotificationHandlerCfg configuration, List<LocalizableMessage> unacceptableReasons) {
        try {
            String keyManagerProv;
            this.getOpenIDMURI(configuration);
            if (configuration.getSSLCertNickname() == null && (configuration.getOpenidmUsername() == null || configuration.getOpenidmPassword() == null)) {
                unacceptableReasons.add(OpenidmAccountStatusNotificationHandlerMessages.ERR_OPENIDM_PWSYNC_INVALID_AUTHENTICATION_CONFIG.get());
                return false;
            }
            if (configuration.getSSLCertNickname() != null && ((keyManagerProv = configuration.getKeyManagerProvider()) == null || keyManagerProv.isEmpty())) {
                unacceptableReasons.add(OpenidmAccountStatusNotificationHandlerMessages.ERR_OPENIDM_PWSYNC_NO_KEYMANAGER_PROVIDER.get());
                return false;
            }
        }
        catch (ConfigException ex) {
            unacceptableReasons.add(ex.getMessageObject());
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(OpenidmAccountStatusNotificationHandlerCfg configuration) {
        ConfigChangeResult configChangeResult = new ConfigChangeResult();
        String newLogFileName = configuration.getLogFile();
        if (!this.logFileName.equals(newLogFileName)) {
            configChangeResult.setAdminActionRequired(true);
            configChangeResult.addMessage(OpenidmAccountStatusNotificationHandlerMessages.INFO_OPENIDM_PWSYNC_LOGFILE_CHANGE_REQUIRES_RESTART.get((Object)this.logFileName, (Object)newLogFileName));
        }
        if (this.currentConfig.getUpdateInterval() == 0L != (configuration.getUpdateInterval() == 0L)) {
            configChangeResult.setAdminActionRequired(true);
            configChangeResult.addMessage(OpenidmAccountStatusNotificationHandlerMessages.INFO_OPENIDM_PWSYNC_UPDATE_INTERVAL_CHANGE_REQUIRES_RESTART.get((Object)this.currentConfig.getUpdateInterval(), (Object)configuration.getUpdateInterval()));
        } else {
            this.interval = configuration.getUpdateInterval();
        }
        this.currentConfig = configuration;
        try {
            StaticUtils.close((Closeable[])new Closeable[]{this.httpClientHandler});
            this.initializeOpenIDMClient(configuration);
            configChangeResult.setResultCode(ResultCode.SUCCESS);
        }
        catch (ConfigException | DirectoryException | InitializationException ex) {
            configChangeResult.setResultCode(ResultCode.UNDEFINED);
            configChangeResult.setAdminActionRequired(true);
            configChangeResult.addMessage(((LocalizableException)ex).getMessageObject());
        }
        return configChangeResult;
    }

    private void initializeOpenIDMClient(OpenidmAccountStatusNotificationHandlerCfg configuration) throws DirectoryException, ConfigException, InitializationException {
        String certNickname = configuration.getSSLCertNickname();
        X509KeyManager x509KeyManager = certNickname != null ? this.getKeyManager(configuration) : null;
        TrustManager[] trustMgrs = this.getTrustManagers(configuration);
        X509Certificate serverCert = this.getServerCertificate(trustMgrs, configuration);
        this.encryptor = new SimpleEncryptor(ASYMMETRIC_CIPHER, serverCert.getPublicKey(), configuration.getPrivateKeyAlias());
        this.initializeHttpClient(configuration, x509KeyManager, trustMgrs);
    }

    private void initializeHttpClient(OpenidmAccountStatusNotificationHandlerCfg configuration, X509KeyManager keyManager, TrustManager[] trustManagers) throws ConfigException, InitializationException {
        this.compatMode = configuration.getOpenidmCompatMode();
        this.openidmURI = this.getOpenIDMURI(configuration);
        Options options = Options.defaultOptions();
        options.set(HttpClientHandler.OPTION_LOADER, serviceLoader);
        options.set(HttpClientHandler.OPTION_MAX_CONNECTIONS, 16);
        boolean isHTTPS = "https".equalsIgnoreCase(this.openidmURI.getScheme());
        if (isHTTPS) {
            options.set(HttpClientHandler.OPTION_KEY_MANAGERS, new KeyManager[]{keyManager});
            options.set(HttpClientHandler.OPTION_TRUST_MANAGERS, trustManagers);
        }
        try {
            this.httpClientHandler = new HttpClientHandler(options);
        }
        catch (HttpApplicationException e) {
            logger.traceException((Throwable)e, "Error when creating HTTP client handler");
            throw new InitializationException(OpenidmAccountStatusNotificationHandlerMessages.ERR_OPENIDM_PWSYNC_INITIALIZATIONEXCEPTION.get((Object)e.getMessage()));
        }
        this.client = new Client((Handler)this.httpClientHandler);
    }

    private void initializeLogFile(String logFileName) throws ConfigException {
        this.logFileName = logFileName;
        this.logFile = StaticUtils.getFileForPath((String)logFileName);
        if (!this.logFile.exists()) {
            if (!this.logFile.mkdirs()) {
                throw new ConfigException(OpenidmAccountStatusNotificationHandlerMessages.ERR_OPENIDM_PWSYNC_LOGFILE_UNABLE_TO_CREATE_DIRECTORY.get((Object)logFileName));
            }
        } else if (!this.logFile.isDirectory()) {
            throw new ConfigException(OpenidmAccountStatusNotificationHandlerMessages.ERR_OPENIDM_PWSYNC_LOGFILE_ALREADY_EXISTS.get((Object)logFileName));
        }
    }

    private X509Certificate getServerCertificate(TrustManager[] trustMgrs, OpenidmAccountStatusNotificationHandlerCfg configuration) throws ConfigException {
        X509TrustManager trustMgr = (X509TrustManager)trustMgrs[0];
        String serverCertSubject = configuration.getCertificateSubjectDN().toString();
        for (X509Certificate cert : trustMgr.getAcceptedIssuers()) {
            String subjectX500Principal = cert.getSubjectX500Principal().getName("CANONICAL");
            if (!serverCertSubject.equalsIgnoreCase(subjectX500Principal)) continue;
            return cert;
        }
        throw new ConfigException(OpenidmAccountStatusNotificationHandlerMessages.ERR_OPENIDM_PWSYNC_INVALID_SERVERKEYALIAS.get((Object)serverCertSubject));
    }

    private TrustManager[] getTrustManagers(OpenidmAccountStatusNotificationHandlerCfg configuration) throws DirectoryException {
        DN trustMgrDN = configuration.getTrustManagerProviderDN();
        TrustManagerProvider trustManagerProvider = DirectoryServer.getTrustManagerProvider((DN)trustMgrDN);
        if (logger.isTraceEnabled()) {
            logger.trace("Trust Manager: %s, Server certificate subject: %s", (Object)trustMgrDN, (Object)configuration.getCertificateSubjectDN());
        }
        return trustManagerProvider.getTrustManagers();
    }

    private X509KeyManager getKeyManager(OpenidmAccountStatusNotificationHandlerCfg configuration) throws DirectoryException, ConfigException {
        String certNickname;
        DN keyMgrDN = configuration.getKeyManagerProviderDN();
        if (keyMgrDN == null) {
            throw new ConfigException(OpenidmAccountStatusNotificationHandlerMessages.ERR_OPENIDM_PWSYNC_NO_KEYMANAGER_PROVIDER.get());
        }
        KeyManagerProvider keyManagerProvider = DirectoryServer.getKeyManagerProvider((DN)keyMgrDN);
        KeyManager[] keyManagers = keyManagerProvider.getKeyManagers();
        X509KeyManager x509KeyManager = (X509KeyManager)keyManagers[0];
        if (x509KeyManager.getPrivateKey(certNickname = configuration.getSSLCertNickname()) == null) {
            throw new ConfigException(OpenidmAccountStatusNotificationHandlerMessages.ERR_OPENIDM_PWSYNC_INVALID_CLIENT_CERT_NICKNAME.get((Object)certNickname));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Key Manager: %s, Client certificate nickname: %s", (Object)keyMgrDN, (Object)certNickname);
        }
        return KeyManagers.useSingleCertificate((String)certNickname, (X509KeyManager)x509KeyManager);
    }

    private URI getOpenIDMURI(OpenidmAccountStatusNotificationHandlerCfg configuration) throws ConfigException {
        try {
            return new URI(configuration.getOpenidmUrl());
        }
        catch (URISyntaxException ex) {
            logger.traceException((Throwable)ex);
            throw new ConfigException(OpenidmAccountStatusNotificationHandlerMessages.ERR_OPENIDM_PWSYNC_MALFORMEDURLEXCEPTION.get((Object)configuration.getOpenidmUrl(), (Object)ex.getMessage()), (Throwable)ex);
        }
    }

    public void handleStatusNotification(AccountStatusNotification notification) {
        if (logger.isTraceEnabled()) {
            logger.trace("Received notification for user: " + notification.getUserDN());
        }
        OpenidmAccountStatusNotificationHandlerCfg config = this.currentConfig;
        HashMap<String, List<String>> returnedData = new HashMap<String, List<String>>();
        String userDN = String.valueOf(notification.getUserDN());
        Entry userEntry = notification.getUserEntry();
        SortedSet<AttributeType> notificationAttrs = config.getAttributeType();
        for (AttributeType t : notificationAttrs) {
            for (Attribute a : userEntry.getAllAttributes(t)) {
                ArrayList<String> attrVals = new ArrayList<String>();
                String attrName = a.getAttributeDescription().getAttributeType().getNameOrOID();
                for (ByteString v : a) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Adding end user attribute value " + v + " from attr " + attrName + "to notification");
                    }
                    attrVals.add(v.toString());
                }
                returnedData.put(attrName, attrVals);
            }
        }
        AccountStatusNotificationType notifType = notification.getNotificationType();
        if (AccountStatusNotificationType.PASSWORD_CHANGED != notifType && AccountStatusNotificationType.PASSWORD_RESET != notifType) {
            return;
        }
        List newPasswords = (List)notification.getNotificationProperties().get(AccountStatusNotificationProperty.NEW_PASSWORD);
        byte passwordEvent = notifType == AccountStatusNotificationType.PASSWORD_CHANGED ? (byte)1 : 2;
        this.processOpenIDMNotification(passwordEvent, userDN, newPasswords, returnedData);
        if (logger.isTraceEnabled()) {
            logger.trace("Finished to process the notification to IDM for user: " + notification.getUserDN());
        }
    }

    private Map<String, Object> buildPatchForPasswords(List<String> newPasswords) throws JsonCryptoException {
        HashMap<String, Object> patchFields = new HashMap<String, Object>();
        JsonValue crypto = new JsonCrypto(this.encryptor.getType(), this.encryptor.encrypt(new JsonValue(newPasswords.get(0)))).toJsonValue();
        switch (this.compatMode) {
            case V2: {
                patchFields.put("replace", new JsonPointer(this.currentConfig.getPasswordAttribute()).toString());
                patchFields.put("value", crypto.asMap());
                break;
            }
            case V3: {
                patchFields.put("operation", "replace");
                patchFields.put("field", new JsonPointer(this.currentConfig.getPasswordAttribute()).toString());
                patchFields.put("value", crypto.asMap());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compatibility mode: " + (Object)((Object)this.compatMode));
            }
        }
        return patchFields;
    }

    private void processOpenIDMNotification(byte passwordEvent, String userDN, List<String> newPasswords, Map<String, List<String>> returnedData) {
        if (logger.isTraceEnabled()) {
            logger.trace("Process notification: user %s 's password %s. Additional data: %s", (Object)userDN, (Object)(passwordEvent == 1 ? "changed" : "reset"), returnedData);
        }
        try {
            String paramPrefix = this.compatMode == OpenidmAccountStatusNotificationHandlerCfgDefn.OpenidmCompatMode.V2 ? "_" : "";
            Map<String, String> queryParameters = this.buildQueryParameters(paramPrefix, userDN, passwordEvent, returnedData);
            Map<String, Object> passwordsPatch = this.buildPatchForPasswords(newPasswords);
            if (this.interval > 0L) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Pushing modification to local storage for user: %s", (Object)userDN);
                }
                HashMap<String, Map<String, Object>> request = new HashMap<String, Map<String, Object>>(2);
                request.put("queryParameter", queryParameters);
                request.put("patch", passwordsPatch);
                try {
                    StringWriter writer = new StringWriter();
                    this.mapper.writeValue(writer, request);
                    this.queue.push(userDN, writer.toString());
                }
                catch (Exception ex) {
                    logger.traceException((Throwable)ex, "Error when pushing modification to queue");
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Posting REST request to IDM for user: %s", (Object)userDN);
                }
                this.postRequestToIDM(queryParameters, passwordsPatch);
            }
        }
        catch (Exception ex) {
            logger.traceException((Throwable)ex, "Error when processing modification for user: %s", (Object)userDN);
        }
    }

    private Map<String, String> buildQueryParameters(String paramPrefix, String userDN, byte passwordEvent, Map<String, List<String>> returnedData) {
        HashMap<String, String> queryParameter = new HashMap<String, String>(returnedData.size());
        queryParameter.put(paramPrefix + "passwordEvent", Byte.toString(passwordEvent));
        queryParameter.put(paramPrefix + "resourceHostname", this.hostname);
        queryParameter.put(paramPrefix + "messageTimestamp", Long.toString(System.currentTimeMillis()));
        queryParameter.put(paramPrefix + "resourceAccountDN", userDN);
        for (Map.Entry<String, List<String>> e : returnedData.entrySet()) {
            if (e.getValue().size() == 1) {
                queryParameter.put(e.getKey(), e.getValue().get(0));
                continue;
            }
            if (e.getValue().size() <= 1) continue;
            StringBuilder listString = new StringBuilder();
            for (String s : e.getValue()) {
                listString.append(s).append("\t");
            }
            queryParameter.put(e.getKey(), listString.toString());
        }
        return queryParameter;
    }

    private Promise<Boolean, NeverThrowsException> postRequestToIDM(Map<String, String> queryParameter, Map<String, Object> passwordsPatch) {
        final Request request = this.buildHttpRequest(queryParameter, passwordsPatch);
        if (logger.isTraceEnabled()) {
            try {
                logger.trace("Posting to IDM url=[%s], query params=[%s], json patch=[%s]", (Object)request.getUri(), (Object)request.getForm(), (Object)request.getEntity().getString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.client.send(request).then(new Function<Response, Boolean, NeverThrowsException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean apply(Response response) {
                try {
                    Status status = response.getStatus();
                    if (status.isSuccessful()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Success when posting to IDM. Message received: %s", (Object)response.getEntity());
                        }
                        Boolean bl = true;
                        return bl;
                    }
                    if (logger.isTraceEnabled()) {
                        String message = status.equals(Status.UNAUTHORIZED) ? "Access non authorized by the server, check your credentials" : (status.equals(Status.NOT_FOUND) ? "HTTP response: object not found" : (status.equals(Status.CONFLICT) ? "HTTP response: conflict (matches multiple objects or patch failure)" : "Unexpected status"));
                        Exception cause = response.getCause();
                        logger.trace("Failure when posting to IDM. Status: %s. Message: %s. Cause: %s", (Object)status, (Object)message, cause != null ? cause : "N/A");
                    }
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    request.close();
                    response.close();
                }
            }
        });
    }

    private Request buildHttpRequest(Map<String, String> queryParameter, Map<String, Object> passwordsPatch) {
        Request request = new Request();
        request.setMethod("POST");
        request.setUri(this.openidmURI);
        Headers headers = request.getHeaders();
        headers.add("X-Requested-With", (Object)"OpenDJPlugin");
        if (this.currentConfig.getOpenidmUsername() != null && this.currentConfig.getOpenidmPassword() != null) {
            headers.add("X-OpenIDM-Username", (Object)this.currentConfig.getOpenidmUsername());
            headers.add("X-OpenIDM-Password", (Object)this.currentConfig.getOpenidmPassword());
        }
        Form form = new Form();
        form.add((Object)"_action", (Object)"patch");
        form.add((Object)"_queryId", (Object)this.currentConfig.getQueryId());
        for (Map.Entry<String, String> e : queryParameter.entrySet()) {
            form.add((Object)e.getKey(), (Object)e.getValue());
        }
        form.appendRequestQuery(request);
        ArrayList<Map<String, Object>> finalPatch = new ArrayList<Map<String, Object>>(1);
        finalPatch.add(passwordsPatch);
        request.getEntity().setJson(finalPatch);
        return request;
    }

    public String getShutdownListenerName() {
        return THREADNAME;
    }

    public void processServerShutdown(LocalizableMessage reason) {
        this.stopRequested = true;
        while (this.backgroundThread != null && this.backgroundThread.isAlive()) {
            try {
                this.backgroundThread.interrupt();
                this.backgroundThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        DirectoryServer.deregisterShutdownListener((ServerShutdownListener)this);
        this.queue.close();
        StaticUtils.close((Closeable[])new Closeable[]{this.httpClientHandler});
        this.backgroundThread = null;
    }

    private long getInterval() {
        return this.interval * 1000L;
    }

    private void initializeBackGroundProcessing() {
        if (this.backgroundThread == null) {
            DirectoryServer.registerShutdownListener((ServerShutdownListener)this);
            this.stopRequested = false;
            this.backgroundThread = new BackGroundThread();
            this.backgroundThread.start();
        }
    }

    private boolean isShuttingDown() {
        return this.stopRequested;
    }

    private class BackGroundThread
    extends DirectoryThread {
        BackGroundThread() {
            super(OpenidmAccountStatusNotificationHandler.THREADNAME);
        }

        public void run() {
            while (!OpenidmAccountStatusNotificationHandler.this.isShuttingDown()) {
                try {
                    long sleepInterval = OpenidmAccountStatusNotificationHandler.this.getInterval();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Background thread - sleeping for " + sleepInterval + " milliseconds");
                    }
                    BackGroundThread.sleep((long)sleepInterval);
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (Exception e) {
                    logger.traceException((Throwable)e, "Error when sleeping");
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Queue size: " + OpenidmAccountStatusNotificationHandler.this.queue.size() + " items");
                }
                if (OpenidmAccountStatusNotificationHandler.this.queue.size() <= 0L) continue;
                String[] request = null;
                try {
                    while ((request = OpenidmAccountStatusNotificationHandler.this.queue.poll()) != null) {
                        Map item = OpenidmAccountStatusNotificationHandler.this.mapper.readValue(request[1], Map.class);
                        Map queryParameter = (Map)item.get("queryParameter");
                        Map passwordsPatch = (Map)item.get("patch");
                        final String[] currentRequest = request;
                        OpenidmAccountStatusNotificationHandler.this.postRequestToIDM(queryParameter, passwordsPatch).thenOnResult(new ResultHandler<Boolean>(){

                            @Override
                            public void handleResult(Boolean isSuccess) {
                                if (!isSuccess.booleanValue()) {
                                    try {
                                        OpenidmAccountStatusNotificationHandler.this.queue.push(currentRequest[0], currentRequest[1]);
                                    }
                                    catch (IOException ex) {
                                        logger.traceException((Throwable)ex, "Error when pushing back to queue a request");
                                    }
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    logger.traceException((Throwable)e, "Error when processing a queue element");
                }
            }
        }
    }
}

