/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto.simple;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import org.forgerock.json.crypto.JsonCryptoException;
import org.forgerock.json.crypto.simple.SimpleKeySelector;

public class SimpleKeyStoreSelector
implements SimpleKeySelector {
    private KeyStore keyStore;
    private char[] password;

    public SimpleKeyStoreSelector(KeyStore keyStore, String password) {
        this.keyStore = keyStore;
        this.password = password.toCharArray();
    }

    @Override
    public Key select(String key) throws JsonCryptoException {
        try {
            return this.keyStore.getKey(key, this.password);
        }
        catch (GeneralSecurityException gse) {
            throw new JsonCryptoException(gse);
        }
    }
}

