/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto.simple;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.forgerock.json.JsonValue;
import org.forgerock.json.crypto.JsonCryptoException;
import org.forgerock.json.crypto.JsonEncryptor;
import org.forgerock.util.encode.Base64;

public class SimpleEncryptor
implements JsonEncryptor {
    public static final String TYPE = "x-simple-encryption";
    private final ObjectMapper mapper = new ObjectMapper();
    private String cipher;
    private Key key;
    private String alias;

    public SimpleEncryptor(String cipher, Key key, String alias) {
        this.cipher = cipher;
        this.key = key;
        this.alias = alias;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private Object symmetric(Object object) throws GeneralSecurityException, IOException {
        Cipher symmetric = Cipher.getInstance(this.cipher);
        symmetric.init(1, this.key);
        String data = Base64.encode(symmetric.doFinal(this.mapper.writeValueAsBytes(object)));
        byte[] iv = symmetric.getIV();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("cipher", this.cipher);
        result.put("key", this.alias);
        result.put("data", data);
        if (iv != null) {
            result.put("iv", Base64.encode(iv));
        }
        return result;
    }

    private Object asymmetric(Object object) throws GeneralSecurityException, IOException {
        String symmetricCipher = "AES/ECB/PKCS5Padding";
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(128);
        SecretKey sessionKey = generator.generateKey();
        Cipher symmetric = Cipher.getInstance(symmetricCipher);
        symmetric.init(1, sessionKey);
        String data = Base64.encode(symmetric.doFinal(this.mapper.writeValueAsBytes(object)));
        Cipher asymmetric = Cipher.getInstance(this.cipher);
        asymmetric.init(1, this.key);
        HashMap<String, String> keyObject = new HashMap<String, String>();
        keyObject.put("cipher", this.cipher);
        keyObject.put("key", this.alias);
        keyObject.put("data", Base64.encode(asymmetric.doFinal(sessionKey.getEncoded())));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cipher", symmetricCipher);
        result.put("key", keyObject);
        result.put("data", data);
        return result;
    }

    @Override
    public JsonValue encrypt(JsonValue value) throws JsonCryptoException {
        Object object = value.getObject();
        try {
            return new JsonValue(this.key instanceof SecretKey ? this.symmetric(object) : this.asymmetric(object));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new JsonCryptoException(e);
        }
    }
}

