/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto;

import org.forgerock.json.JsonValue;
import org.forgerock.json.crypto.JsonCrypto;
import org.forgerock.json.crypto.JsonCryptoException;
import org.forgerock.json.crypto.JsonEncryptor;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;

public class JsonEncryptFunction
implements Function<JsonValue, JsonValue, JsonCryptoException> {
    private final JsonEncryptor encryptor;

    public JsonEncryptFunction(JsonEncryptor encryptor) {
        this.encryptor = Reject.checkNotNull(encryptor);
    }

    @Override
    public JsonValue apply(JsonValue value) throws JsonCryptoException {
        return new JsonCrypto(this.encryptor.getType(), this.encryptor.encrypt(value)).toJsonValue();
    }
}

