/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto;

import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.crypto.JsonCrypto;
import org.forgerock.json.crypto.JsonCryptoException;
import org.forgerock.json.crypto.JsonDecryptor;

public class JsonCryptoTransformer {
    private JsonDecryptor decryptor;

    public JsonCryptoTransformer(JsonDecryptor decryptor) {
        if (decryptor == null) {
            throw new NullPointerException();
        }
        this.decryptor = decryptor;
    }

    public void transform(JsonValue value) throws JsonException {
        JsonCrypto crypto;
        if (JsonCrypto.isJsonCrypto(value) && (crypto = new JsonCrypto(value)).getType().equals(this.decryptor.getType())) {
            try {
                value.setObject(this.decryptor.decrypt(crypto.getValue()).getObject());
            }
            catch (JsonCryptoException jce) {
                throw new JsonException(jce);
            }
        }
    }
}

