/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto;

import java.util.HashMap;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;

public class JsonCrypto {
    private String type;
    private JsonValue value;

    public JsonCrypto() {
    }

    public JsonCrypto(JsonValue value) throws JsonValueException {
        this.fromJsonValue(value);
    }

    public JsonCrypto(String type, JsonValue value) {
        this.setType(type);
        this.setValue(value);
    }

    public static boolean isJsonCrypto(JsonValue value) {
        boolean result = false;
        if (value.isDefined("$crypto")) {
            JsonValue crypto = value.get("$crypto");
            result = crypto.get("type").isString() && crypto.isDefined("value");
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public JsonValue getValue() {
        return this.value;
    }

    public void setValue(JsonValue value) {
        this.value = value;
    }

    public void fromJsonValue(JsonValue value) throws JsonValueException {
        JsonValue crypto = value.get("$crypto").required();
        this.type = crypto.get("type").required().asString();
        this.value = crypto.get("value").required();
    }

    public JsonValue toJsonValue() {
        HashMap<String, Object> crypto = new HashMap<String, Object>();
        crypto.put("type", this.type);
        crypto.put("value", this.value == null ? null : this.value.getObject());
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("$crypto", crypto);
        return new JsonValue(result);
    }
}

