/*
 * Decompiled with CFR 0.152.
 */
package org.openidentityplatform.opendj.ldif;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.TreeMap;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.util.Reject;

public final class JSONEntryWriter
implements EntryWriter {
    static ObjectMapper mapper = new ObjectMapper();
    final PrintWriter out;
    boolean firstEntry = true;

    public JSONEntryWriter(OutputStream out) {
        this.out = new PrintWriter(out);
        this.out.println("[");
    }

    @Override
    public void close() throws IOException {
        this.out.println("]");
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public JSONEntryWriter writeComment(CharSequence comment) throws IOException {
        return this;
    }

    @Override
    public JSONEntryWriter writeEntry(Entry entry) throws IOException {
        Reject.ifNull(entry);
        this.out.println((this.firstEntry ? " " : ",") + "{\"" + new String(JsonStringEncoder.getInstance().quoteAsString(entry.getName().toString())) + "\":[");
        this.firstEntry = false;
        TreeMap<String, AbstractMap.SimpleEntry<String, ByteString>> attr = new TreeMap<String, AbstractMap.SimpleEntry<String, ByteString>>();
        for (Attribute attribute : entry.getAllAttributes()) {
            String attributeDescription = attribute.getAttributeDescriptionAsString();
            if (attribute.isEmpty()) {
                attr.put(attributeDescription, new AbstractMap.SimpleEntry<String, ByteString>(attributeDescription, ByteString.empty()));
                continue;
            }
            for (ByteString value : attribute) {
                attr.put(attributeDescription + value, new AbstractMap.SimpleEntry<String, ByteString>(attributeDescription, value));
            }
        }
        boolean first = true;
        for (AbstractMap.SimpleEntry kv : attr.values()) {
            HashMap params = new HashMap(1);
            params.put(kv.getKey(), ((ByteSequence)kv.getValue()).toString());
            this.out.println(" " + (first ? " " : ",") + mapper.writeValueAsString(params));
            first = false;
        }
        this.out.println("]}");
        return this;
    }
}

