/*
 * Decompiled with CFR 0.152.
 */
package org.openidentityplatform.opendj.ldif;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldif.EntryReader;

public final class JSONEntryReader
implements EntryReader {
    static ObjectMapper mapper = new ObjectMapper();
    JsonParser parser;
    JsonToken token = null;

    public JSONEntryReader(InputStream in) throws JsonParseException, IOException {
        this.parser = mapper.getFactory().createParser(in);
        if (this.parser.nextToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException(this.parser, "invalid format");
        }
        this.token = this.parser.nextToken();
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    @Override
    public boolean hasNext() throws DecodeException, IOException {
        return this.token == JsonToken.START_OBJECT;
    }

    @Override
    public Entry readEntry() throws DecodeException, IOException {
        if (this.hasNext()) {
            String key;
            LinkedHashMapEntry res;
            Map<String, List<Map<String, String>>> entry = mapper.readValue(this.parser, new TypeReference<Map<String, List<Map<String, String>>>>(){});
            List<Map<String, String>> attrsArray = entry.get((res = new LinkedHashMapEntry(key = entry.keySet().iterator().next())).getName().toString());
            if (attrsArray == null) {
                attrsArray = entry.get(key);
            }
            for (Map<String, String> attrs : attrsArray) {
                for (Map.Entry<String, String> attr : attrs.entrySet()) {
                    res.addAttribute(attr.getKey(), attr.getValue());
                }
            }
            this.token = this.parser.nextToken();
            return res;
        }
        return null;
    }
}

