/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.util.Reject;

public final class Utils {
    public static void closeSilently(Closeable ... resources) {
        if (resources == null) {
            return;
        }
        Utils.closeSilently(Arrays.asList(resources));
    }

    public static void closeSilently(Iterable<? extends Closeable> resources) {
        if (resources == null) {
            return;
        }
        for (Closeable closeable : resources) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String joinAsString(String separator, Object ... values) {
        return Utils.joinAsString(separator, Arrays.asList(values));
    }

    public static String joinAsString(String separator, Iterable<?> values) {
        Reject.ifNull(separator);
        Reject.ifNull(values);
        StringBuilder builder = new StringBuilder();
        Utils.joinAsString(builder, separator, values);
        return builder.toString();
    }

    public static void joinAsString(StringBuilder builder, String separator, Object ... values) {
        Utils.joinAsString(builder, separator, Arrays.asList(values));
    }

    public static void joinAsString(StringBuilder builder, String separator, Iterable<?> values) {
        Reject.ifNull(builder);
        Reject.ifNull(separator);
        Reject.ifNull(values);
        Iterator<?> iterator = values.iterator();
        if (iterator.hasNext()) {
            builder.append(iterator.next());
            while (iterator.hasNext()) {
                builder.append(separator);
                builder.append(iterator.next());
            }
        }
    }

    public static ThreadFactory newThreadFactory(final ThreadGroup group, final String nameTemplate, final boolean isDaemon) {
        return new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                String name = String.format(nameTemplate, this.count.getAndIncrement());
                Thread t = new Thread(group, r, name);
                t.setDaemon(isDaemon);
                return t;
            }
        };
    }

    public static <T extends Enum<T>> T asEnum(String value, Class<T> type) {
        if (value == null) {
            return null;
        }
        Enum[] constants = (Enum[])type.getEnumConstants();
        if (constants == null) {
            throw new IllegalArgumentException("Type is not an enum class");
        }
        for (Enum constant : constants) {
            if (!value.equalsIgnoreCase(constant.toString())) continue;
            return (T)constant;
        }
        StringBuilder sb = new StringBuilder("Expecting String containing one of: ");
        sb.append(Utils.joinAsString(" ", constants));
        throw new IllegalArgumentException(sb.toString());
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private Utils() {
    }
}

