/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldif.AbstractLDIFReader;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.RejectedLDIFListener;
import org.forgerock.util.Reject;

public final class LDIFEntryReader
extends AbstractLDIFReader
implements EntryReader {
    private static final Entry EOF = new LinkedHashMapEntry();
    private Entry nextEntry;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Entry valueOfLDIFEntry(String ... ldifLines) {
        try (LDIFEntryReader reader = new LDIFEntryReader(ldifLines);){
            if (!reader.hasNext()) {
                LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_NO_CHANGE_RECORD_FOUND.get();
                throw new LocalizedIllegalArgumentException(message);
            }
            Entry entry = reader.readEntry();
            if (reader.hasNext()) {
                LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_MULTIPLE_CHANGE_RECORDS_FOUND.get();
                throw new LocalizedIllegalArgumentException(message);
            }
            Entry entry2 = entry;
            return entry2;
        }
        catch (DecodeException e) {
            throw new LocalizedIllegalArgumentException(e.getMessageObject());
        }
        catch (IOException e) {
            LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_UNEXPECTED_IO_ERROR.get(e.getMessage());
            throw new LocalizedIllegalArgumentException(message);
        }
    }

    public LDIFEntryReader(InputStream in) {
        super(in);
    }

    public LDIFEntryReader(List<String> ldifLines) {
        super(ldifLines);
    }

    public LDIFEntryReader(Reader reader) {
        super(reader);
    }

    public LDIFEntryReader(String ... ldifLines) {
        super(Arrays.asList(ldifLines));
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    @Override
    public boolean hasNext() throws DecodeException, IOException {
        return this.getNextEntry() != EOF;
    }

    @Override
    public Entry readEntry() throws DecodeException, IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Entry entry = this.nextEntry;
        this.nextEntry = null;
        return entry;
    }

    public LDIFEntryReader setExcludeAllOperationalAttributes(boolean excludeOperationalAttributes) {
        this.excludeOperationalAttributes = excludeOperationalAttributes;
        return this;
    }

    public LDIFEntryReader setExcludeAllUserAttributes(boolean excludeUserAttributes) {
        this.excludeUserAttributes = excludeUserAttributes;
        return this;
    }

    public LDIFEntryReader setExcludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull(attributeDescription);
        this.excludeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFEntryReader setExcludeBranch(DN excludeBranch) {
        Reject.ifNull(excludeBranch);
        this.excludeBranches.add(excludeBranch);
        return this;
    }

    public LDIFEntryReader setExcludeFilter(Matcher excludeFilter) {
        Reject.ifNull(excludeFilter);
        this.excludeFilters.add(excludeFilter);
        return this;
    }

    public LDIFEntryReader setIncludeAttribute(AttributeDescription attributeDescription) {
        Reject.ifNull(attributeDescription);
        this.includeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFEntryReader setIncludeBranch(DN includeBranch) {
        Reject.ifNull(includeBranch);
        this.includeBranches.add(includeBranch);
        return this;
    }

    public LDIFEntryReader setIncludeFilter(Matcher includeFilter) {
        Reject.ifNull(includeFilter);
        this.includeFilters.add(includeFilter);
        return this;
    }

    public LDIFEntryReader setRejectedLDIFListener(RejectedLDIFListener listener) {
        this.rejectedRecordListener = listener;
        return this;
    }

    public LDIFEntryReader setSchema(Schema schema) {
        Reject.ifNull(schema);
        this.schema = this.schemaValidationPolicy.adaptSchemaForValidation(schema);
        return this;
    }

    public LDIFEntryReader setSchemaValidationPolicy(SchemaValidationPolicy policy) {
        this.schemaValidationPolicy = SchemaValidationPolicy.copyOf(policy);
        this.schema = this.schemaValidationPolicy.adaptSchemaForValidation(this.schema);
        return this;
    }

    private Entry getNextEntry() throws DecodeException, IOException {
        while (this.nextEntry == null) {
            AbstractLDIFReader.LDIFRecord record = this.readLDIFRecord();
            if (record == null) {
                this.nextEntry = EOF;
                break;
            }
            try {
                DN entryDN = this.readLDIFRecordDN(record);
                if (entryDN == null) continue;
                if (this.isBranchExcluded(entryDN)) {
                    LocalizableMessage message = CoreMessages.ERR_LDIF_ENTRY_EXCLUDED_BY_DN.get(record.lineNumber, entryDN.toString());
                    this.handleSkippedRecord(record, message);
                    continue;
                }
                LinkedHashMapEntry entry = new LinkedHashMapEntry(entryDN);
                boolean schemaValidationFailure = false;
                LinkedList<LocalizableMessage> schemaErrors = new LinkedList<LocalizableMessage>();
                while (record.iterator.hasNext()) {
                    String ldifLine = record.iterator.next();
                    if (this.readLDIFRecordAttributeValue(record, ldifLine, entry, schemaErrors)) continue;
                    schemaValidationFailure = true;
                }
                if (this.isEntryExcluded(entry)) {
                    LocalizableMessage message = CoreMessages.ERR_LDIF_ENTRY_EXCLUDED_BY_FILTER.get(record.lineNumber, entryDN.toString());
                    this.handleSkippedRecord(record, message);
                    continue;
                }
                if (!this.schema.validateEntry(entry, this.schemaValidationPolicy, schemaErrors)) {
                    schemaValidationFailure = true;
                }
                if (schemaValidationFailure) {
                    this.handleSchemaValidationFailure(record, schemaErrors);
                    continue;
                }
                if (!schemaErrors.isEmpty()) {
                    this.handleSchemaValidationWarning(record, schemaErrors);
                }
                this.nextEntry = entry;
            }
            catch (DecodeException e) {
                this.handleMalformedRecord(record, e.getMessageObject());
            }
        }
        return this.nextEntry;
    }
}

